/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.splitter.utils.javacode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;

public class JavaClassBlock {
    private List<String> methodDeclareList = new ArrayList<String>();
    private String className;
    private String classComment;
    private boolean existsClassComment = true;

    public String getClassComment() {
        return this.classComment;
    }

    public void setClassComment(String classComment) {
        this.classComment = this.parseClassComment(classComment);
    }

    public List<String> getMethodDeclareList() {
        return Collections.unmodifiableList(this.methodDeclareList);
    }

    public void addMethodDeclare(String methodDeclare) {
        if (!methodDeclare.trim().isEmpty()) {
            this.methodDeclareList.add(methodDeclare);
        }
    }

    public List<Object> toJavaCodeBlocks() {
        if (this.methodDeclareList.isEmpty()) {
            if (this.className == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.classComment + this.className);
        }
        ArrayList<Object> list = new ArrayList<Object>(this.methodDeclareList.size());
        for (String s : this.methodDeclareList) {
            if (s.trim().startsWith("//") || s.trim().startsWith("/*")) {
                list.add("//" + this.className.replace("\r", "").replace("\n", "") + "\u5305\u542b\u7684\u51fd\u6570\r\n" + s.trim());
                continue;
            }
            list.add("//" + this.className.replace("\r", "").replace("\n", "") + "\u5305\u542b\u7684\u51fd\u6570\r\n" + this.classComment + s.trim());
        }
        return list;
    }

    private boolean isAscii(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private String parseClassComment(String classDeclare) {
        if (this.classComment != null) {
            return this.classComment;
        }
        String[] lines = classDeclare.split("\n");
        StringBuilder comment = new StringBuilder();
        boolean commentStart = false;
        if (lines.length > 1) {
            for (String line : lines) {
                if (line.trim().startsWith("//")) {
                    comment.append(line.trim());
                    continue;
                }
                if (commentStart) {
                    if (line.trim().endsWith("*/")) {
                        commentStart = false;
                    } else if (this.isAscii(line)) continue;
                    comment.append(line);
                    continue;
                }
                if (!line.trim().startsWith("/*")) continue;
                commentStart = true;
                comment.append(line);
            }
            this.classComment = comment.toString();
            this.existsClassComment = comment.length() > 0;
            return comment.toString();
        }
        this.existsClassComment = false;
        return "";
    }

    public String toString() {
        return "JavaClassBlock{classDeclare=" + this.classComment + this.className + ", methodDeclareList=" + this.methodDeclareList + '}';
    }

    public boolean isExistsClassComment() {
        return this.existsClassComment;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassDesc() {
        if (this.className.length() > 250) {
            return this.className.substring(0, 250);
        }
        if (StringUtils.isBlank((CharSequence)this.classComment)) {
            return this.className;
        }
        String x = this.classComment + "\r\n" + this.className;
        if (x.length() > 250) {
            return x.substring(x.length() - 250);
        }
        return x;
    }
}

