/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.splitter.utils.javacode;

import kd.bos.gptas.km.splitter.utils.javacode.JavaClassBlock;
import kd.bos.gptas.km.splitter.utils.javacode.JavaClassLexer;

public class JavaClassBlockParser {
    public static JavaClassBlock parse(String javaCode) {
        return JavaClassBlockParser.parse(javaCode, false, false);
    }

    public static JavaClassBlock parse(String javaCode, boolean dumpToken, boolean dumpBlock) {
        JavaClassLexer lexer = new JavaClassLexer(javaCode);
        JavaClassBlock javaClassBlock = new JavaClassBlock();
        StringBuilder s = new StringBuilder(1024);
        if (dumpToken) {
            JavaClassBlockParser.dumpToken(lexer);
        }
        boolean brace = false;
        while (!lexer.eof()) {
            JavaClassLexer.Token token = lexer.next();
            switch (token.type) {
                case CLASS_DECLARE: {
                    javaClassBlock.setClassComment(lexer.getClassComments());
                    javaClassBlock.setClassName(token.text);
                    break;
                }
                case ABSTRACT_METHOD_DECLARE: {
                    javaClassBlock.addMethodDeclare(lexer.getMethodComments() + token.text);
                    break;
                }
                case METHOD_DECLARE: {
                    s.setLength(0);
                    s.append(lexer.getMethodComments());
                    s.append(token.text);
                    while (!lexer.eof()) {
                        JavaClassLexer.Token next = lexer.next();
                        s.append(next.text);
                        if (next.type != JavaClassLexer.TokenType.CLOSE_BRACE) continue;
                    }
                    javaClassBlock.addMethodDeclare(s.toString());
                }
            }
        }
        if (dumpBlock) {
            JavaClassBlockParser.dumpBlock(javaClassBlock);
        }
        return javaClassBlock;
    }

    private static void dumpToken(JavaClassLexer lexer) {
        System.out.println("--------------------dumpToken--------------------");
        int i = 0;
        while (!lexer.eof()) {
            JavaClassLexer.Token token = lexer.next();
            System.out.println("#TOKEN-" + ++i + " " + (Object)((Object)token.type) + "\n" + token);
        }
        lexer.reset();
    }

    private static void dumpBlock(JavaClassBlock jsm) {
        System.out.println("--------------------dumpBlock--------------------");
        System.out.println("#Class\n" + jsm.getClassComment() + jsm.getClassName());
        int i = 0;
        for (String s : jsm.getMethodDeclareList()) {
            System.out.println("\n#BLOCK-" + ++i + "\n" + s);
        }
    }
}

