/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.splitter.utils.javacode;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class JavaClassLexer {
    private final Token SEPARATOR_TOKEN = new Token("", TokenType.SEPARATOR);
    private int size;
    private List<Token> tokens = new ArrayList<Token>(1024);
    private int pos = -1;
    private boolean classDeclared = false;

    public JavaClassLexer(String code) {
        this.parseTokens(code.toCharArray());
    }

    private void parseTokens(char[] chs) {
        boolean doubleQuote = false;
        boolean lineComment = false;
        boolean blockComment = false;
        boolean isAbstract = false;
        char pre = '\u0000';
        int i = -1;
        int N = chs.length;
        StringBuilder seg = new StringBuilder(32);
        int openBrace = 0;
        block9: while (++i < N) {
            char ch = chs[i];
            if (i > 0) {
                pre = chs[i - 1];
            }
            switch (ch) {
                case '\'': {
                    if (lineComment || blockComment || doubleQuote) break;
                    if (i + 2 < N) {
                        seg.append(chs[++i]);
                        seg.append(chs[++i]);
                        continue block9;
                    }
                    throw new IllegalArgumentException("Java code block incorrect: " + new String(chs, 0, i) + "^");
                }
                case '\"': {
                    if (lineComment || blockComment || pre == '\\') break;
                    doubleQuote = !doubleQuote;
                    break;
                }
                case '/': {
                    if (!(lineComment || blockComment || doubleQuote || i + 1 >= N)) {
                        if (chs[i + 1] == '/') {
                            ++i;
                            lineComment = true;
                            this.newToken(seg, TokenType.IDENTIFIER);
                            seg.append("//");
                            continue block9;
                        }
                        if (chs[i + 1] != '*') break;
                        ++i;
                        blockComment = true;
                        this.newToken(seg, TokenType.IDENTIFIER);
                        seg.append("/*");
                        continue block9;
                    }
                    if (!blockComment || pre != '*') break;
                    blockComment = false;
                    if (openBrace > 1) break;
                    seg.append('/');
                    this.newToken(seg, TokenType.BLOCK_COMMENT);
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (lineComment) {
                        lineComment = false;
                        if (openBrace <= 1) {
                            this.newToken(seg, TokenType.LINE_COMMENT);
                        }
                    }
                    if (this.classDeclared) break;
                    String line = seg.toString().trim();
                    if (line.startsWith("package ")) {
                        this.newToken(seg, TokenType.PACKAGE);
                        continue block9;
                    }
                    if (!line.startsWith("import ")) break;
                    this.newToken(seg, TokenType.IMPORT);
                    continue block9;
                }
                case '{': {
                    if (lineComment || blockComment || doubleQuote) break;
                    if (++openBrace == 1) {
                        String block = seg.toString();
                        isAbstract = block.contains(" interface ") || block.contains(" abstract ");
                        this.newToken(seg, TokenType.CLASS_DECLARE);
                        this.classDeclared = true;
                        seg.append('{');
                        this.newToken(seg, TokenType.OPEN_BRACE);
                        continue block9;
                    }
                    if (openBrace != 2) break;
                    this.newToken(seg, TokenType.METHOD_DECLARE);
                    seg.append('{');
                    this.newToken(seg, TokenType.OPEN_BRACE);
                    continue block9;
                }
                case '}': {
                    if (lineComment || blockComment || doubleQuote || --openBrace != 1) break;
                    this.newToken(seg, TokenType.METHOD_BODY);
                    seg.append('}');
                    this.newToken(seg, TokenType.CLOSE_BRACE);
                    continue block9;
                }
                case ';': {
                    if (!isAbstract || lineComment || blockComment || doubleQuote || openBrace != 1) break;
                    seg.append(';');
                    this.newToken(seg, TokenType.ABSTRACT_METHOD_DECLARE);
                    continue block9;
                }
            }
            seg.append(ch);
        }
        if (openBrace != 0) {
            throw new IllegalArgumentException("Java code block maybe incorrect: " + new String(chs));
        }
        String text = seg.toString().trim();
        if ("}".equals(text)) {
            seg.setLength(0);
            seg.append('}');
            this.newToken(seg, TokenType.CLOSE_BRACE);
        } else {
            this.newToken(seg, TokenType.IDENTIFIER);
        }
        this.size = this.tokens.size();
        if (this.size > 0) {
            Pattern pattern = Pattern.compile("\\s+");
            Token before = this.tokens.get(0);
            for (int j = 1; j < this.size; ++j) {
                String prefix;
                String beforeText;
                int p;
                Token cur = this.tokens.get(j);
                if ((cur.type == TokenType.LINE_COMMENT || cur.type == TokenType.BLOCK_COMMENT) && (p = (beforeText = before.text).lastIndexOf(10)) != -1 && p != beforeText.length() - 1 && pattern.matcher(prefix = beforeText.substring(p + 1)).matches()) {
                    this.tokens.set(j - 1, new Token(beforeText.substring(0, p), before.type));
                    cur = new Token(beforeText.substring(p + 1) + cur.text, cur.type);
                    this.tokens.set(j, cur);
                }
                before = cur;
            }
        }
    }

    private void newToken(StringBuilder seg, TokenType type) {
        String s = seg.toString();
        seg.setLength(0);
        if (!s.isEmpty()) {
            int p;
            if (!(type != TokenType.METHOD_DECLARE && type != TokenType.ABSTRACT_METHOD_DECLARE || (p = s.lastIndexOf(59)) == -1 || s.trim().endsWith(");") || (s = s.substring(p + 1)).indexOf(61) == -1)) {
                this.tokens.add(this.SEPARATOR_TOKEN);
                return;
            }
            if (!s.isEmpty()) {
                this.tokens.add(new Token(s, type));
            } else {
                this.tokens.add(this.SEPARATOR_TOKEN);
            }
        }
    }

    public Token next() {
        return this.tokens.get(++this.pos);
    }

    public boolean eof() {
        return this.pos + 1 >= this.size;
    }

    public void reset() {
        this.pos = -1;
    }

    public String getMethodComments() {
        return this.getComments(this.getPreviousUntilType(TokenType.CLOSE_BRACE, TokenType.OPEN_BRACE, TokenType.ABSTRACT_METHOD_DECLARE));
    }

    public String getClassComments() {
        return this.getComments(this.getPreviousUntilType(TokenType.PACKAGE));
    }

    private String getComments(List<Token> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder comment = new StringBuilder(128);
        for (Token token : list) {
            if (token.type != TokenType.LINE_COMMENT && token.type != TokenType.BLOCK_COMMENT) continue;
            comment.append(token.text).append('\n');
        }
        if (comment.length() == 0) {
            return "";
        }
        comment.setLength(comment.length() - 1);
        return comment.toString();
    }

    private List<Token> getPreviousUntilType(TokenType ... endType) {
        int i = this.pos;
        while (--i >= 0) {
            Token token = this.tokens.get(i);
            if (!this.in(token.type, endType) && token.type != TokenType.SEPARATOR) continue;
            return this.tokens.subList(i + 1, this.pos);
        }
        return this.tokens.subList(0, this.pos);
    }

    private boolean in(TokenType type, TokenType ... endType) {
        for (TokenType tokenType : endType) {
            if (type != tokenType) continue;
            return true;
        }
        return false;
    }

    static class Token {
        final TokenType type;
        final String text;

        Token(String text, TokenType type) {
            this.text = text;
            this.type = type;
        }

        public String toString() {
            return (Object)((Object)this.type) + ": " + this.text;
        }
    }

    static enum TokenType {
        SEPARATOR,
        LINE_COMMENT,
        BLOCK_COMMENT,
        IDENTIFIER,
        PACKAGE,
        IMPORT,
        CLASS_DECLARE,
        ABSTRACT_METHOD_DECLARE,
        METHOD_DECLARE,
        METHOD_BODY,
        OPEN_BRACE,
        CLOSE_BRACE;

    }
}

