/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.milvus;

import java.util.List;
import java.util.function.Consumer;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDaoGaIRepoImpl;
import kd.bos.gptas.milvus.MilvusDaoKmImpl;

public interface MilvusDao
extends AutoCloseable {
    public List<Chunk> search(List<Long> var1, String var2);

    public List<Chunk> search(List<Long> var1, String var2, int var3);

    public List<Chunk> searchByChunks(List<Long> var1, List<Long> var2, String var3, int var4);

    public List<Chunk> searchIds(List<Float> var1, List<Long> var2);

    public List<Chunk> searchIds(List<Float> var1, List<Long> var2, int var3);

    public boolean insert(Chunk var1);

    public List<Chunk> batchInsert(List<Chunk> var1);

    public boolean batchInsertAsync(String var1, List<Chunk> var2, Consumer<List<Chunk>> var3);

    public void delByIdList(List<Long> var1);

    public List<Chunk> query(List<Long> var1, List<Long> var2, boolean var3);

    public static MilvusDao create(String indexMethod) {
        return new MilvusDaoKmImpl(indexMethod);
    }

    public static MilvusDao createByKM(String indexMethod) {
        return new MilvusDaoKmImpl(indexMethod);
    }

    public static MilvusDao createByGaiRepo(long repoId) {
        MainEntityType repoType = EntityMetadataCache.getDataEntityType((String)"gai_repo_info");
        DynamicObject repo = BusinessDataReader.loadSingle((Object)repoId, (DynamicObjectType)repoType);
        String indexMethod = repo.getString("index_method");
        return new MilvusDaoGaIRepoImpl(indexMethod);
    }
}

