/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.milvus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.gson.JsonObject;
import io.milvus.client.MilvusServiceClient;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.grpc.DataType;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.response.QueryResultsWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.gptas.milvus.MilvusInsertThread;
import kd.bos.gptas.openapi.OpenApiClient;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.CollectionUtils;

class MilvusDaoImpl
implements MilvusDao {
    private static final Log log = LogFactory.getLog(MilvusDaoImpl.class);
    private static final int MAX_TOP = 200;
    private static final String SEARCH_PARAM = "{\"nprobe\":10, \"offset\":0}";
    private MilvusServiceClient milvusServiceClient = null;
    private static OpenApiClient openApiClient;
    private static final DistributeSessionlessCache cache;
    private final Config config;

    @Override
    public void close() throws Exception {
        if (this.milvusServiceClient != null) {
            this.milvusServiceClient.close();
        }
    }

    protected Set<Long> getSubmitIdSet(List<Chunk> chunkList) {
        HashSet<Long> set = new HashSet<Long>(chunkList.stream().map(o -> o.getId()).collect(Collectors.toList()));
        return set;
    }

    public MilvusDaoImpl(String indexMethod) {
        this.config = Config.valueOf(indexMethod);
        this.init();
    }

    private void createIndex() {
        CreateIndexParam createIndexParam = CreateIndexParam.newBuilder().withCollectionName(this.getCollectionName()).withFieldName("vector").withIndexType(IndexType.IVF_FLAT).withMetricType(MetricType.L2).withExtraParam(this.getDimensionParam()).withSyncMode(Boolean.FALSE).build();
        this.doCreateIndex(createIndexParam);
    }

    private String getCollectionName() {
        return String.format("M_%s_%s", RequestContext.get().getAccountId(), this.config.indexMethod);
    }

    private int getDimension() {
        return this.config.dimension;
    }

    private String getDimensionParam() {
        return String.format("{\"nlist\":%s}", this.getDimension());
    }

    @Override
    public List<Chunk> search(List<Long> repoIdList, String text) {
        return this.search(repoIdList, text, 5);
    }

    @Override
    public List<Chunk> search(List<Long> repoIdList, String text, int top) {
        List<List<Float>> vectorList = this.getVectors(Collections.singletonList(text));
        return this.searchIds(vectorList.get(0), repoIdList, top);
    }

    @Override
    public List<Chunk> searchByChunks(List<Long> repoIdList, List<Long> chunkIdList, String text, int top) {
        List<List<Float>> vectorList = this.getVectors(Collections.singletonList(text));
        SearchResults results = this.search(vectorList.get(0), repoIdList, chunkIdList, top);
        return this.toChunkList(results);
    }

    private List<Chunk> toChunkList(SearchResults results) {
        if (results != null) {
            List idList = results.getResults().getIds().getIntId().getDataList();
            if (idList.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Chunk> chunkList = new ArrayList<Chunk>(idList.size());
            int i = 0;
            for (Long aLong : idList) {
                Chunk chunk = new Chunk();
                chunk.setId(aLong);
                chunk.setScores(results.getResults().getScores(i++));
                chunkList.add(chunk);
            }
            return chunkList;
        }
        return Collections.emptyList();
    }

    private Map<String, String> callOpenAPI(String index_method, String params) {
        if (openApiClient == null) {
            openApiClient = OpenApiClient.builder().build();
        }
        HashMap<String, String> apiParams = new HashMap<String, String>(16);
        apiParams.put("indexmethod", index_method);
        apiParams.put("text", params);
        JsonObject jsonObject = openApiClient.requestPost("/kapi/v2/kdtest/aicc/gptas_synccall", SerializationUtils.toJsonString(apiParams));
        HashMap<String, String> map = new HashMap<String, String>(16);
        JsonObject data = jsonObject.getAsJsonObject("data").getAsJsonObject("result");
        for (String key : data.keySet()) {
            map.put(key, data.get(key).getAsString());
        }
        return map;
    }

    private List<List<Float>> getVectors(List<String> chunkTextList) {
        HashMap<String, Object> paramList = new HashMap<String, Object>();
        paramList.put("input", chunkTextList);
        String userName = RequestContext.get().getUserName();
        long start = System.currentTimeMillis();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("stream", "false");
        log.info("\u7528\u6237{}\u5f00\u59cb\u8c03\u7528embedding{} ", new Object[]{userName, "syncService", JSON.toJSON(paramList)});
        Map<String, String> result = this.callAICCService(paramList, contextMap);
        log.info("{} {} {} {}", new Object[]{userName, "syncService", JSON.toJSON(result), System.currentTimeMillis() - start});
        String taskId = result.get("id");
        String errMessage = result.get("message");
        String errorCode = result.get("errorCode");
        if (!"0".equals(errorCode)) {
            String lastError = (String)cache.get(this.getErrorTimeStampKey());
            if (lastError != null) {
                this.throwEmbeddingException(errorCode, errMessage);
            }
            result = this.callAICCService(paramList, contextMap);
            taskId = result.get("id");
            errMessage = result.get("message");
            errorCode = result.get("errorCode");
            if (!"0".equals(errorCode)) {
                cache.put(this.getErrorTimeStampKey(), (Object)String.valueOf(System.currentTimeMillis()), 180);
                this.throwEmbeddingException(errorCode, errMessage);
            }
        }
        String content = result.get("result");
        return this.config.getVector(content);
    }

    private void throwEmbeddingException(String errorCode, String errMessage) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"embedding\u8c03\u7528\u51fa\u9519%1$s):%2$s", (String)"MilvusDaoImpl_1", (String)"bos-devportal-gptas", (Object[])new Object[0]), errorCode, errMessage));
    }

    private String getErrorTimeStampKey() {
        return CacheKeyUtil.getAcctId() + "." + this.config.indexMethod + ".errortimestamp";
    }

    private Map<String, String> callAICCService(Map<String, Object> paramList, Map<String, String> contextMap) {
        String localEnable = SystemPropertyUtils.getProptyByTenant((String)"gpt.local.enable", (String)String.valueOf(Boolean.FALSE));
        Map result = String.valueOf(Boolean.TRUE).equals(localEnable) ? this.callOpenAPI(this.config.indexMethod, SerializationUtils.toJsonString(paramList)) : (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"syncService", (Object[])new Object[]{contextMap, this.config.indexMethod, JSON.toJSON(paramList).toString()});
        return result;
    }

    @Override
    public List<Chunk> searchIds(List<Float> vector, List<Long> repoIdList) {
        return this.searchIds(vector, repoIdList, 5);
    }

    @Override
    public List<Chunk> searchIds(List<Float> vector, List<Long> repoIdList, int top) {
        SearchResults results = this.search(vector, repoIdList, null, top);
        return this.toChunkList(results);
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    private String decode(String text) {
        if (Encrypters.isEncrypted((String)text)) {
            return Encrypters.decode((String)text);
        }
        return text;
    }

    private MilvusServiceClient getClient() {
        if (this.milvusServiceClient == null) {
            String tenantId = RequestContext.get().getTenantId();
            String milvusHost = SystemPropertyUtils.getProptyByTenant((String)"milvus.host", (String)tenantId);
            String milvusUser = SystemPropertyUtils.getProptyByTenant((String)"milvus.user", (String)tenantId);
            String milvusPasswd = SystemPropertyUtils.getProptyByTenant((String)"milvus.passwd", (String)tenantId);
            milvusPasswd = this.decode(milvusPasswd);
            if (this.isEmpty(milvusHost) || this.isEmpty(milvusUser) || this.isEmpty(milvusPasswd)) {
                String msg = ResManager.loadKDString((String)"\u9700\u8981\u5728MC\u4e2d\u914d\u7f6emilvus.host,milvus.user,milvus.passwd", (String)"MilvusDaoImpl_2", (String)"bos-devportal-gptas", (Object[])new Object[0]);
                throw new RuntimeException(msg);
            }
            int milvusPort = SystemPropertyUtils.getInteger((String)tenantId, (String)"milvus.port", (Integer)19530);
            this.milvusServiceClient = new MilvusServiceClient(ConnectParam.newBuilder().withHost(milvusHost).withPort(milvusPort).withAuthorization(milvusUser, milvusPasswd).withConnectTimeout(3L, TimeUnit.MINUTES).build());
            this.milvusServiceClient.withTimeout(2L, TimeUnit.MINUTES);
        }
        return this.milvusServiceClient;
    }

    private void init() {
        ArrayList<FieldType> fieldTypeList = new ArrayList<FieldType>();
        fieldTypeList.add(FieldType.newBuilder().withName("vector").withDataType(DataType.FloatVector).withDimension(Integer.valueOf(this.getDimension())).withAutoID(false).build());
        fieldTypeList.add(FieldType.newBuilder().withName("repoId").withDataType(DataType.Int64).build());
        if (this.doCreateCollection(fieldTypeList)) {
            log.info("collectionName:{} milvus createIndex start", (Object)this.getCollectionName());
            this.createIndex();
            log.info("collectionName:{} milvus createIndex end", (Object)this.getCollectionName());
        }
        log.info("collectionName:{} milvus doLoadCollection start", (Object)this.getCollectionName());
        this.doLoadCollection();
        log.info("collectionName:{} milvus doLoadCollection end", (Object)this.getCollectionName());
    }

    private void doCreateIndex(CreateIndexParam requestParam) {
        MilvusServiceClient milvusServiceClient = this.getClient();
        if (milvusServiceClient == null) {
            return;
        }
        R indexResult = milvusServiceClient.createIndex(requestParam);
        log.info("{} \u7d22\u5f15 {} \u521b\u5efa\u5b8c\u6210\uff0cresult\uff1a{}", new Object[]{this.getCollectionName(), requestParam.getCollectionName(), indexResult});
    }

    private boolean doCreateCollection(List<FieldType> fieldTypeList) {
        String message;
        log.info("milvus doCreateCollection start ");
        MilvusServiceClient milvusServiceClient = this.getClient();
        if (milvusServiceClient == null) {
            log.info("createCollection milvus\u672a\u542f\u7528");
            return false;
        }
        log.info("milvus hasCollection start ");
        R result = milvusServiceClient.hasCollection(HasCollectionParam.newBuilder().withCollectionName(this.getCollectionName()).build());
        if (result.getData() == null && ((message = result.getException().getMessage()).contains("username") || message.contains("password") || message.contains("correct"))) {
            log.info("createCollection milvus\u8d26\u53f7\u5bc6\u7801\u4e0d\u5bf9!!!!!!!");
            milvusServiceClient.close();
            return false;
        }
        log.info("milvus hasCollection end result:{} ", (Object)result);
        if (result.getData() == Boolean.TRUE) {
            log.info("{} collection \u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u518d\u91cd\u590d\u521b\u5efa", (Object)this.getCollectionName());
            return false;
        }
        CreateCollectionParam.Builder builder = CreateCollectionParam.newBuilder().withCollectionName(this.getCollectionName()).withDescription(this.getCollectionDescription()).withShardsNum(2);
        builder.addFieldType(FieldType.newBuilder().withName("id").withDataType(DataType.Int64).withPrimaryKey(true).withAutoID(false).build());
        for (FieldType fieldType : fieldTypeList) {
            if (fieldType.getName().equals("id")) continue;
            builder.addFieldType(fieldType);
        }
        CreateCollectionParam createCollectionParam = builder.build();
        log.info("{} \u521b\u5efa \u5f00\u59cb", (Object)this.getCollectionName());
        R createResult = milvusServiceClient.createCollection(createCollectionParam);
        log.info("{} \u521b\u5efa\u5b8c\u6210\uff0cresult\uff1a{}", (Object)this.getCollectionName(), (Object)createResult);
        return createResult.getStatus().intValue() == R.Status.Success.getCode();
    }

    private String getCollectionDescription() {
        return this.config.desc;
    }

    private void doLoadCollection() {
        MilvusServiceClient milvusServiceClient = this.getClient();
        if (milvusServiceClient == null) {
            log.error("loadCollection {} milvusServiceClient \u521b\u5efa\u5931\u8d25", (Object)this.getCollectionName());
            return;
        }
        R loadResult = milvusServiceClient.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(this.getCollectionName()).build());
        log.info("loadCollection {} result {}", (Object)this.getCollectionName(), (Object)loadResult);
    }

    @Override
    public boolean insert(Chunk chunk) {
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<Long> repoIdList = new ArrayList<Long>();
        ArrayList<List<Float>> vectorListList = new ArrayList<List<Float>>();
        if (chunk.getVector().isEmpty()) {
            List<List<Float>> vectors = this.getVectors(Collections.singletonList(chunk.getChunk()));
            chunk.setVector(vectors.get(0));
        }
        if (chunk.getVector() == null || chunk.getVector().size() != this.getDimension()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5411\u91cfsize\u4e0d\u5bf9%s", (String)"MilvusDaoImpl_3", (String)"bos-devportal-gptas", (Object[])new Object[0]), chunk.getVector().size()));
        }
        idList.add(chunk.getId());
        repoIdList.add(chunk.getRepositoryId());
        vectorListList.add(chunk.getVector());
        ArrayList<InsertParam.Field> fieldList = new ArrayList<InsertParam.Field>();
        fieldList.add(new InsertParam.Field("id", idList));
        fieldList.add(new InsertParam.Field("repoId", repoIdList));
        fieldList.add(new InsertParam.Field("vector", vectorListList));
        InsertParam insertParam = InsertParam.newBuilder().withCollectionName(this.getCollectionName()).withFields(fieldList).build();
        R insertResult = this.getClient().insert(insertParam);
        log.info("milvus batch insert {}", (Object)insertResult);
        return insertResult.getStatus().intValue() != R.Status.Success.getCode();
    }

    @Override
    public List<Chunk> batchInsert(List<Chunk> chunkList) {
        if (chunkList == null || chunkList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u6bb5\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u7a7a\u6587\u4ef6", (String)"MilvusDaoImpl_4", (String)"bos-devportal-gptas", (Object[])new Object[0]));
        }
        int size = chunkList.size();
        ArrayList<Long> idList = new ArrayList<Long>(size);
        ArrayList<Long> repoIdList = new ArrayList<Long>(size);
        ArrayList<List<Float>> vectorListList = new ArrayList<List<Float>>(size);
        for (Chunk chunk : chunkList) {
            try {
                if (chunk.getVector().isEmpty()) {
                    List<List<Float>> vectors = this.getVectors(Collections.singletonList(chunk.getChunk()));
                    chunk.setVector(vectors.get(0));
                }
                vectorListList.add(chunk.getVector());
                idList.add(chunk.getId());
                repoIdList.add(chunk.getRepositoryId());
            }
            catch (KDException ex) {
                chunk.setFailMsg(ex.getMessage());
            }
        }
        ArrayList<InsertParam.Field> fieldList = new ArrayList<InsertParam.Field>();
        fieldList.add(new InsertParam.Field("id", idList));
        fieldList.add(new InsertParam.Field("repoId", repoIdList));
        fieldList.add(new InsertParam.Field("vector", vectorListList));
        InsertParam insertParam = InsertParam.newBuilder().withCollectionName(this.getCollectionName()).withFields(fieldList).build();
        R insertResult = this.getClient().insert(insertParam);
        log.info("milvus batch insert {}", (Object)insertResult);
        if (insertResult.getStatus().intValue() != R.Status.Success.getCode()) {
            for (Chunk chunk : chunkList) {
                if (chunk.getFailMsg() != null) continue;
                chunk.setFailMsg(insertResult.getMessage());
            }
        }
        return chunkList;
    }

    @Override
    public boolean batchInsertAsync(String taskId, List<Chunk> chunkList, Consumer<List<Chunk>> resultCallBack) {
        MilvusInsertThread milvusInsertThread = new MilvusInsertThread(this, taskId);
        return milvusInsertThread.addChunkListAndStartThread(chunkList, resultCallBack);
    }

    private String orJoin(String field, List<?> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder exprBuilder = new StringBuilder();
        String or = " or ";
        for (Object repoId : list) {
            exprBuilder.append(field).append(" == ").append(repoId).append(or);
        }
        exprBuilder.delete(exprBuilder.length() - or.length(), exprBuilder.length());
        return exprBuilder.toString();
    }

    private SearchResults search(List<Float> vector, List<Long> repoIdList, List<Long> knlId, int top) {
        log.info("milvus search params,top:{}, repoIdList:{}", (Object)top, (Object)JSON.toJSONString(repoIdList));
        int currentTop = top == 0 ? 1 : Math.min(top, 200);
        log.info("milvus search params,exec top:{}", (Object)currentTop);
        List<String> search_output_fields = Collections.singletonList("repoId");
        List<List<Float>> search_vectors = Collections.singletonList(vector);
        String exprRepoId = this.orJoin("repoId", repoIdList);
        String exprId = this.orJoin("id", knlId);
        if (StringUtils.isNotBlank((CharSequence)exprId)) {
            exprRepoId = "(" + exprRepoId + ") and (" + exprId + ")";
        }
        SearchParam searchParam = SearchParam.newBuilder().withCollectionName(this.getCollectionName()).withMetricType(MetricType.L2).withOutFields(search_output_fields).withTopK(Integer.valueOf(currentTop)).withVectors(search_vectors).withVectorFieldName("vector").withExpr(exprRepoId).withParams(SEARCH_PARAM).build();
        R respSearch = this.getClient().search(searchParam);
        if (respSearch.getStatus().intValue() == R.Status.Success.getCode()) {
            return (SearchResults)respSearch.getData();
        }
        log.info("milvus search result {}", (Object)respSearch);
        return null;
    }

    @Override
    public void delByIdList(List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        StringBuilder expr = new StringBuilder("id");
        expr.append(" in [");
        String idStr = idList.stream().map(String::valueOf).collect(Collectors.joining(","));
        expr.append(idStr);
        expr.append(']');
        DeleteParam deleteParam = DeleteParam.newBuilder().withCollectionName(this.getCollectionName()).withExpr(expr.toString()).build();
        R r = this.getClient().delete(deleteParam);
        log.info("milvus del {} ,result {}", (Object)expr, (Object)r);
    }

    @Override
    public List<Chunk> query(List<Long> repoIdList, List<Long> idList, boolean fillChunk) {
        String repoIds = " repoId in [" + repoIdList.stream().map(String::valueOf).collect(Collectors.joining(",")) + "]";
        String ids = "";
        if (CollectionUtils.isNotEmpty(idList)) {
            ids = "and id in [" + idList.stream().map(String::valueOf).collect(Collectors.joining(",")) + "]";
        }
        ArrayList<String> outFields = new ArrayList<String>(2);
        outFields.add("repoId");
        outFields.add("id");
        outFields.add("vector");
        QueryParam queryParam = QueryParam.newBuilder().withCollectionName(this.getCollectionName()).withConsistencyLevel(ConsistencyLevelEnum.STRONG).withExpr(repoIds + ids).withOutFields(outFields).withOffset(Long.valueOf(0L)).withLimit(Long.valueOf(CollectionUtils.isEmpty(idList) ? 100L : (long)idList.size())).build();
        R resultsR = this.getClient().query(queryParam);
        if (resultsR.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new KDBizException("milvus query err:" + resultsR.getMessage());
        }
        QueryResultsWrapper resultsWrapper = new QueryResultsWrapper((QueryResults)resultsR.getData());
        List repoIdResultList = resultsWrapper.getFieldWrapper("repoId").getFieldData();
        List idResultList = resultsWrapper.getFieldWrapper("id").getFieldData();
        List vectorList = resultsWrapper.getFieldWrapper("vector").getFieldData();
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>(repoIdResultList.size());
        int i = 0;
        boolean from = false;
        int dim = resultsWrapper.getFieldWrapper("vector").getDim();
        for (Object o : repoIdResultList) {
            Chunk chunk = new Chunk();
            chunk.setRepositoryId((Long)o);
            chunk.setId((Long)idResultList.get(i));
            chunkList.add(chunk);
            chunk.setVector((List)vectorList.get(i));
            ++i;
        }
        return chunkList;
    }

    static {
        cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    }

    private static enum Config {
        AZURE_EMBEDDING_ADA_002(1536, "AZURE_EMBEDDING_ADA_002", "repo file chunk aure 1536 dimension vector."){

            @Override
            public List<List<Float>> getVector(String content) {
                List list = (List)JSONPath.read((String)content, (String)"$.data[0].embedding", List.class);
                return Collections.singletonList(JSON.parseObject((String)JSON.toJSONString((Object)list), (TypeReference)new TypeReference<List<Float>>(){}, (Feature[])new Feature[0]));
            }
        }
        ,
        BAIDU_EMBEDDING_V1(384, "BAIDU_EMBEDDING_V1", "repo file chunk baidu 384 dimension vector."){

            @Override
            public List<List<Float>> getVector(String content) {
                JSONObject contentJson = JSON.parseObject((String)content);
                if (!contentJson.containsKey((Object)"usage")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"embedding \u8c03\u7528\u9519\u8bef%s", (String)"MilvusDaoImpl_0", (String)"bos-devportal-gptas", (Object[])new Object[0]), content));
                }
                JSONArray jsonArray = contentJson.getJSONArray("data");
                ArrayList<List<Float>> vectorList = new ArrayList<List<Float>>(384);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    String embeddingString = jsonArray.getJSONObject(i).getString("embedding");
                    List vectors = (List)JSON.parseObject((String)embeddingString, (TypeReference)new TypeReference<List<Float>>(){}, (Feature[])new Feature[0]);
                    vectorList.add(vectors);
                }
                return vectorList;
            }
        }
        ,
        KINGDEE_EMBEDDING(768, "KINGDEE_EMBEDDING", "repo file chunk aure 768 dimension vector. "){

            @Override
            public List<List<Float>> getVector(String content) {
                JSONObject contentJson = JSON.parseObject((String)content);
                JSONArray jsonArray = contentJson.getJSONArray("data");
                ArrayList<List<Float>> vectorList = new ArrayList<List<Float>>(768);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    String embeddingString = jsonArray.getJSONObject(i).getString("embedding");
                    List vectors = (List)JSON.parseObject((String)embeddingString, (TypeReference)new TypeReference<List<Float>>(){}, (Feature[])new Feature[0]);
                    vectorList.add(vectors);
                }
                return vectorList;
            }
        };

        private final int dimension;
        private final String indexMethod;
        private final String desc;

        abstract List<List<Float>> getVector(String var1);

        private Config(int dimension, String indexMethod, String desc) {
            this.dimension = dimension;
            this.indexMethod = indexMethod;
            this.desc = desc;
        }
    }
}

