/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.milvus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDaoImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

class MilvusDaoKmImpl
extends MilvusDaoImpl {
    public MilvusDaoKmImpl(String indexMethod) {
        super(indexMethod);
    }

    @Override
    public List<Chunk> searchIds(List<Float> vector, List<Long> repoIdList, int top) {
        List<Chunk> list = super.searchIds(vector, repoIdList, top);
        MilvusDaoKmImpl.fillChunkText(list);
        return list;
    }

    @Override
    public List<Chunk> searchByChunks(List<Long> repoIdList, List<Long> chunkIdList, String text, int top) {
        List<Chunk> list = super.searchByChunks(repoIdList, chunkIdList, text, top);
        MilvusDaoKmImpl.fillChunkText(list);
        return list;
    }

    @Override
    public List<Chunk> query(List<Long> repoIdList, List<Long> idList, boolean fillChunk) {
        List<Chunk> result = super.query(repoIdList, idList, fillChunk);
        if (fillChunk) {
            MilvusDaoKmImpl.fillChunkText(result);
        }
        return result;
    }

    static void fillChunkText(List<Chunk> list) {
        Long[] ids = new Long[list.size()];
        int i = 0;
        HashMap<Long, Chunk> map = new HashMap<Long, Chunk>(16);
        for (Chunk chunk : list) {
            ids[i++] = chunk.getId();
            map.put(chunk.getId(), chunk);
        }
        QFilter qFilter = new QFilter("segmententity.id", "in", (Object)ids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"knl_corpus", (String)"knl_corpus", (String)"segmententity.id,segmententity.segment_tag,group.number,codedes,id,len(inputcontent_tag) inputcontentlength", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            for (Row row : ds) {
                Long id = row.getLong("segmententity.id");
                Chunk chunk = (Chunk)map.get(id);
                if (chunk == null) continue;
                chunk.setChunk(row.getString("segmententity.segment_tag"));
                chunk.setGroupNumber(row.getString("group.number"));
                chunk.setCodeDesc(row.getString("codedes"));
                chunk.setKNLId(row.getLong("id"));
                chunk.setKNLLength(row.getLong("inputcontentlength"));
            }
        }
    }

    @Override
    protected Set<Long> getSubmitIdSet(List<Chunk> chunkList) {
        Long[] ids = new Long[chunkList.size()];
        int i = 0;
        for (Chunk chunk : chunkList) {
            ids[i++] = chunk.getId();
        }
        QFilter qFilter = new QFilter("segmententity.id", "in", (Object)ids);
        QFilter qFilter1 = new QFilter("status", "=", (Object)"B");
        HashSet<Long> set = new HashSet<Long>(chunkList.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"knl_corpus", (String)"knl_corpus", (String)"segmententity.id", (QFilter[])new QFilter[]{qFilter, qFilter1}, (String)"id");){
            for (Row row : ds) {
                set.add(row.getLong("segmententity.id"));
            }
        }
        return set;
    }
}

