/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.milvus;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.gptas.milvus.MilvusDaoImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;

class MilvusInsertThread {
    private static final Log logger = LogFactory.getLog(MilvusInsertThread.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private final MilvusDao milvusDao;
    private final String taskId;

    public MilvusInsertThread(MilvusDao milvusDao, String taskId) {
        this.milvusDao = milvusDao;
        this.taskId = taskId;
    }

    public boolean addChunkListAndStartThread(List<Chunk> list, Consumer<List<Chunk>> resultCallBack) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        String[] s = new String[list.size()];
        int i = 0;
        for (Chunk chunk : list) {
            s[i++] = SerializationUtils.toJsonString((Object)chunk);
        }
        cache.addList(this.getChunkListKey(), s, 28800);
        if (cache.inc(this.getSingleThreadKey(), 180) == 1L) {
            ThreadPools.executeOnce((String)(this.getClass().getName() + "." + this.taskId), () -> this.batchInsertRunner(resultCallBack));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchInsertRunner(Consumer<List<Chunk>> callBack) {
        try {
            String key = this.getChunkListKey();
            String[] first = cache.getList(key);
            long now = System.currentTimeMillis();
            while (first != null && first.length > 0) {
                logger.info("start batch size: {}  ", (Object)first.length);
                if (System.currentTimeMillis() - now > 170000L) {
                    cache.inc(this.getSingleThreadKey(), 180);
                    now = System.currentTimeMillis();
                }
                cache.removeListObjects(key, 0, first.length);
                ArrayList<Chunk> chunkList = new ArrayList<Chunk>(first.length);
                boolean i = false;
                for (String s : first) {
                    chunkList.add((Chunk)SerializationUtils.fromJsonString((String)s, Chunk.class));
                }
                Set<Long> submitIdSet = ((MilvusDaoImpl)this.milvusDao).getSubmitIdSet(chunkList);
                chunkList.removeIf(o -> !submitIdSet.contains(o.getId()));
                if (!chunkList.isEmpty()) {
                    List<Chunk> resultList = this.milvusDao.batchInsert(chunkList);
                    try {
                        logger.info("finished size: {}  ", (Object)resultList.size());
                        callBack.accept(resultList);
                        Set<Long> submitIdSet1 = ((MilvusDaoImpl)this.milvusDao).getSubmitIdSet(chunkList);
                        chunkList.removeIf(o -> submitIdSet1.contains(o.getId()));
                        ArrayList<Long> delIds = new ArrayList<Long>(16);
                        for (Chunk chunk : chunkList) {
                            delIds.add(chunk.getId());
                        }
                        if (!delIds.isEmpty()) {
                            this.milvusDao.delByIdList(delIds);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                }
                first = cache.getList(key);
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        finally {
            cache.remove(this.getSingleThreadKey());
        }
    }

    private String getChunkListKey() {
        return CacheKeyUtil.getAcctId() + ".qa_chunklist." + this.taskId;
    }

    private static String getDelChunkListKey() {
        return CacheKeyUtil.getAcctId() + ".qa_delchunklist";
    }

    private String getSingleThreadKey() {
        return MilvusInsertThread.getSingleThreadKey(this.taskId);
    }

    private static String getSingleThreadKey(String taskId) {
        return CacheKeyUtil.getAcctId() + ".qa_chunkthread." + taskId;
    }

    public static boolean isThreadRunning(String taskId) {
        String key = MilvusInsertThread.getSingleThreadKey(taskId);
        return StringUtils.isNotBlank((CharSequence)((CharSequence)cache.get(key)));
    }
}

