/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.milvus;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.km.IFrameUtil;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.qa.QACache;
import kd.bos.gptas.qa.QASessionCache;
import kd.bos.gptas.qa.QAUtil;
import kd.bos.gptas.qa.model.LLMAPIMsg;
import kd.bos.gptas.qa.model.QAModel;
import kd.bos.gptas.qa.model.RefFile;
import kd.bos.gptas.qa.model.UserHistoryMessage;
import kd.bos.gptas.qa.webapi.QAService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;

public class MilvusTestPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(MilvusTestPlugin.class);
    private static final String[] rmWWW = new String[]{"(^| )(what|who|how|which|where|why)('re|'s)? ", "(^| )('s|'re|is|are|were|was|do|does|did|don't|doesn't|didn't|has|have|be|there|you|me|your|my|mine|just|please|may|i|should|would|wouldn't|will|won't|done|go|for|with|so|the|a|an|by|i'm|it's|he's|she's|they|they're|you're|as|by|on|in|at|up|out|down) "};
    private static final String symbols = "[ :\\r\\n\\t,\uff0c\u3002\uff1f?/`!\uff01&\\^%%]+";
    private boolean invalidEntry = false;
    private static final boolean test = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit repo = (BasedataEdit)this.getControl("repo");
        repo.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setShowApproved(false);
        });
        this.addClickListeners(new String[]{"btnok", "btnres", "btnanswer", "btnhis"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setItemValueByID("sessionuser", (Object)13466739);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"sessionid"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabh"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("content")) {
            this.invalidEntry = true;
        }
        if (e.getProperty().getName().equals("enablemulti")) {
            this.getView().setEnable((Boolean)this.getModel().getValue("enablemulti"), new String[]{"sessionid"});
            this.getView().setVisible((Boolean)this.getModel().getValue("enablemulti"), new String[]{"tabh"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (ctl.getKey()) {
            case "btnok": {
                this.doFillChunks();
                break;
            }
            case "btnanswer": {
                if (this.invalidEntry) {
                    this.doFillChunks();
                }
                this.doAnswer();
                break;
            }
            case "btnhis": {
                MilvusTestPlugin.refreshHistory(this.getView());
            }
        }
    }

    private void doAnswer() {
        DynamicObject repo = (DynamicObject)this.getModel().getValue("repo");
        if (repo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u77e5\u8bc6\u5e93\u3002", (String)"MilvusTestPlugin_0", (String)"bos-devportal-gptas", (Object[])new Object[0]));
            return;
        }
        String question = (String)this.getModel().getValue("content");
        if (StringUtils.isBlank((CharSequence)question)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9700\u8981\u68c0\u7d22\u7684\u5185\u5bb9\u3002", (String)"MilvusTestPlugin_1", (String)"bos-devportal-gptas", (Object[])new Object[0]));
            return;
        }
        this.getModel().clearNoDataRow();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryentity.getSelectRows();
        List chunkAllList = JSON.parseArray((String)this.getView().getPageCache().get("chunklist"), Chunk.class);
        if (selectRows != null && selectRows.length > 0) {
            HashSet<Long> set = new HashSet<Long>(16);
            for (int selectRow : selectRows) {
                set.add(((DynamicObject)rows.get(selectRow)).getLong("chunkid"));
            }
            chunkAllList.removeIf(o -> !set.contains(o.getId()));
        }
        boolean chk2000 = (Boolean)this.getModel().getValue("chk2000");
        List<Map<String, String>> promptList = QAUtil.createPromptList(repo.getString("number"), chunkAllList, chk2000);
        String prompt = QAUtil.getActionPromptFromFile("prompt/QA.md");
        prompt = prompt.replace("{{chunks}}", SerializationUtils.toJsonString(promptList));
        prompt = prompt.replace("{{user_input}}", (String)this.getModel().getValue("content"));
        boolean enableAsync = (Boolean)this.getModel().getValue("enableasync");
        String chatSessionId = MilvusTestPlugin.getChatSessionId(this.getView());
        if (StringUtils.isBlank((CharSequence)chatSessionId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4f1a\u8bddID\u3002", (String)"MilvusTestPlugin_3", (String)"bos-devportal-gptas", (Object[])new Object[0]));
        }
        if (enableAsync) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnanswer"});
            String requestId = UUID.randomUUID().toString();
            QASessionCache qaSessionCache = new QASessionCache(chatSessionId);
            List<UserHistoryMessage> userHistoryMessageList = qaSessionCache.getHistoryMessage();
            if (UserHistoryMessage.isNextQuestion(userHistoryMessageList)) {
                String summaryPrompt = QAUtil.buildSummaryPrompt(question, userHistoryMessageList);
                question = QAUtil.invokePromptService("gptas-default", summaryPrompt, "");
                prompt = QAUtil.buildNextPrompt(question, repo.getString("number"), chatSessionId);
            }
            qaSessionCache.putHistoryMessageInput(question, prompt);
            String taskId = QAUtil.invokePromptServiceAsync("gptas-default", prompt, chatSessionId);
            new QACache(requestId).setTaskId(taskId).setExternal(true).save();
            String pageId = this.getView().getPageId();
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            ThreadPools.executeOnce((String)((Object)((Object)this)).getClass().getName(), () -> MilvusTestPlugin.doAsyncAnswer(rootPageId, pageId, requestId, RequestContext.get().getTraceId()));
        } else {
            MilvusTestPlugin.refreshHistory(this.getView());
            QASessionCache qaSessionCache = new QASessionCache(chatSessionId);
            List<UserHistoryMessage> userHistoryMessageList = qaSessionCache.getHistoryMessage();
            if (UserHistoryMessage.isNextQuestion(userHistoryMessageList)) {
                String summaryPrompt = QAUtil.buildSummaryPrompt(question, userHistoryMessageList);
                question = QAUtil.invokePromptService("gptas-default", summaryPrompt, "");
                prompt = QAUtil.buildNextPrompt(question, repo.getString("number"), chatSessionId);
            }
            String answer = QAUtil.invokePromptService("bos_qa_nolib", prompt, chatSessionId);
            Markdown markdown = (Markdown)this.getView().getControl("markdownap");
            qaSessionCache.putHistoryMessage(question, prompt, answer);
            List<Object> chunkIdList = QAModel.parseChunkIdList(answer);
            List<RefFile> refFiles = QAModel.parseRefFileList(answer, false);
            new QASessionCache(chatSessionId).putLastRefFile(refFiles);
            answer = QAModel.removeRefFile(answer);
            markdown.setText(answer);
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int i = 0;
            for (DynamicObject row : rows) {
                long chunkid = row.getLong("chunkid");
                boolean found = false;
                for (Object o2 : chunkIdList) {
                    if (chunkid != Long.parseLong(o2.toString())) continue;
                    found = true;
                }
                entryGrid.setRowBackcolor(found ? "lightgreen" : "", new int[]{i++});
            }
            MilvusTestPlugin.refreshHistory(this.getView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAsyncAnswer(String rootPageId, String pageId, String requestId, String traceId) {
        QACache qaCache;
        RequestContext.get().setTraceId(traceId);
        IFormView formView = SessionManager.getCurrent().getViewNoPlugin(pageId);
        IFormView rootView = SessionManager.getCurrent().getViewNoPlugin(rootPageId);
        Markdown markdown = (Markdown)formView.getControl("markdownap");
        EntryGrid entryGrid = (EntryGrid)formView.getControl("entryentity");
        try {
            CustomApiResult<LLMAPIMsg> result = null;
            int k = 0;
            StringBuilder fullText = new StringBuilder();
            do {
                if (!(result = new QAService().qaPolling("", "", requestId, 0, "", "", null, "")).isStatus()) {
                    markdown.setText(result.getMessage());
                } else if (!((LLMAPIMsg)result.getData()).isStatus()) {
                    markdown.setText(((LLMAPIMsg)result.getData()).getErrMsg());
                } else {
                    fullText.append(((LLMAPIMsg)result.getData()).getData().getLlmValue());
                    markdown.setText(fullText.toString());
                }
                IFrameUtil.sendFormActionByWS(rootView, formView);
                ++k;
            } while (result.isStatus() && ((LLMAPIMsg)result.getData()).isStatus() && !((LLMAPIMsg)result.getData()).getData().isEnd());
            QACache qaCache2 = new QACache(requestId);
            String[] chunkIdList = qaCache2.getRef();
            DynamicObjectCollection rows = formView.getModel().getEntryEntity("entryentity");
            int i = 0;
            for (DynamicObject row : rows) {
                long chunkid = row.getLong("chunkid");
                boolean found = false;
                for (String o : chunkIdList) {
                    if (chunkid != Long.parseLong(o)) continue;
                    found = true;
                }
                entryGrid.setRowBackcolor(found ? "lightgreen" : "", new int[]{i++});
            }
            MilvusTestPlugin.refreshHistory(formView);
            qaCache = new QACache(requestId);
            qaCache.setExternal(false);
        }
        catch (Exception ex) {
            QACache qaCache3;
            try {
                logger.error((Throwable)ex);
                formView.showTipNotification(ex.getMessage());
                qaCache3 = new QACache(requestId);
                qaCache3.setExternal(false);
            }
            catch (Throwable throwable) {
                QACache qaCache4 = new QACache(requestId);
                qaCache4.setExternal(false);
                qaCache4.release();
                formView.setEnable(Boolean.TRUE, new String[]{"btnanswer"});
                IFrameUtil.sendFormActionByWS(rootView, formView);
                throw throwable;
            }
            qaCache3.release();
            formView.setEnable(Boolean.TRUE, new String[]{"btnanswer"});
            IFrameUtil.sendFormActionByWS(rootView, formView);
        }
        qaCache.release();
        formView.setEnable(Boolean.TRUE, new String[]{"btnanswer"});
        IFrameUtil.sendFormActionByWS(rootView, formView);
    }

    private static String removeWhy(String input) {
        Pattern pattern = Pattern.compile(symbols);
        Matcher matcher = pattern.matcher(input);
        input = matcher.replaceAll("");
        for (String s : rmWWW) {
            pattern = Pattern.compile(s);
            input = pattern.matcher(input).replaceAll("");
        }
        return input;
    }

    private String summaryQuestion(String question) {
        String chatSessionId = MilvusTestPlugin.getChatSessionId(this.getView());
        List<UserHistoryMessage> userHistoryMessageList = new QASessionCache(chatSessionId).getHistoryMessage();
        if (UserHistoryMessage.isNextQuestion(userHistoryMessageList)) {
            String s = QAUtil.buildSummaryPrompt(question, userHistoryMessageList);
            question = QAUtil.invokePromptService("bos_qa_nolib", s);
        }
        return question;
    }

    private static String getChatSessionId(IFormView formView) {
        boolean enablemulti = (Boolean)formView.getModel().getValue("enablemulti");
        if (!enablemulti) {
            return "";
        }
        String chatSessionId = (String)formView.getModel().getValue("sessionid");
        return chatSessionId;
    }

    private void doFillChunks() {
        DynamicObject repo = (DynamicObject)this.getModel().getValue("repo");
        if (repo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u77e5\u8bc6\u5e93\u3002", (String)"MilvusTestPlugin_0", (String)"bos-devportal-gptas", (Object[])new Object[0]));
            return;
        }
        String question = (String)this.getModel().getValue("content");
        if (StringUtils.isBlank((CharSequence)question)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9700\u8981\u68c0\u7d22\u7684\u5185\u5bb9\u3002", (String)"MilvusTestPlugin_1", (String)"bos-devportal-gptas", (Object[])new Object[0]));
            return;
        }
        boolean chkrmww = (Boolean)this.getModel().getValue("chkremovewhy");
        if (chkrmww) {
            question = MilvusTestPlugin.removeWhy(question);
        }
        question = this.summaryQuestion(question);
        this.getModel().setValue("sumamry", (Object)question);
        String chatSessionId = MilvusTestPlugin.getChatSessionId(this.getView());
        List<Chunk> chunkList = QAUtil.searchChunkList(question, repo.getString("number"), (Integer)this.getModel().getValue("top"), chatSessionId);
        this.getModel().deleteEntryData("entryentity");
        if (!chunkList.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entryentity", chunkList.size());
            QFilter qFilter = new QFilter("segmententity.id", "in", (Object)chunkList.stream().map(Chunk::getId).toArray());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"knl_corpus", (String)"id,segmententity.id,length(inputcontent_tag) as inputcontent_tag,group.type", (QFilter[])new QFilter[]{qFilter});
            HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject dynamicObject : query) {
                map.put(dynamicObject.getLong("segmententity.id"), dynamicObject);
            }
            int i = 0;
            IDataEntityProperty property = this.getModel().getDataEntityType().findProperty("article");
            DynamicObject data = this.getModel().getDataEntity(true);
            DynamicObjectCollection rows = data.getDynamicObjectCollection("entryentity");
            for (Chunk chunk : chunkList) {
                this.getModel().setValue("chunk", (Object)chunk.getChunk(), i);
                this.getModel().setValue("chunk_tag", (Object)chunk.getChunk(), i);
                this.getModel().setValue("score", (Object)Float.valueOf(chunk.getScores()), i);
                this.getModel().setItemValueByID(property, (DynamicObject)rows.get(i), (Object)((DynamicObject)map.get(chunk.getId())).getString("id"), false);
                this.getModel().setValue("chunkid", (Object)chunk.getId(), i);
                this.getModel().setValue("articlecount", (Object)((DynamicObject)map.get(chunk.getId())).getString("inputcontent_tag"), i);
                this.getModel().setValue("chunkcount", (Object)(chunk.getChunk() == null ? 0 : chunk.getChunk().length()), i);
                this.getModel().setValue("groupnumber", (Object)((DynamicObject)map.get(chunk.getId())).getString("group.type"), i);
                ++i;
            }
            this.getView().getPageCache().put("chunklist", JSON.toJSONString(chunkList));
        }
    }

    private static void refreshHistory(IFormView formView) {
        boolean enablemulti = (Boolean)formView.getModel().getValue("enablemulti");
        if (!enablemulti) {
            return;
        }
        String chatSessionId = MilvusTestPlugin.getChatSessionId(formView);
        QASessionCache qaSessionCache = new QASessionCache(chatSessionId);
        DynamicObject user = (DynamicObject)formView.getModel().getValue("sessionuser");
        qaSessionCache.setUserForTest(user.getLong("id"));
        Object[] chunkList = qaSessionCache.getChunkList();
        formView.getModel().setValue("refchunkid", (Object)Arrays.deepToString(chunkList));
        List<RefFile> lastRefFile = qaSessionCache.getLastRefFile();
        formView.getModel().setValue("lastreffile", (Object)SerializationUtils.toJsonString(lastRefFile));
        formView.getModel().deleteEntryData("entryh");
        List<UserHistoryMessage> userHistoryMessages = new QASessionCache(chatSessionId).getHistoryMessage();
        if (userHistoryMessages != null && !userHistoryMessages.isEmpty()) {
            formView.getModel().batchCreateNewEntryRow("entryh", userHistoryMessages.size());
            int i = 0;
            for (UserHistoryMessage userHistoryMessage : userHistoryMessages) {
                formView.getModel().setValue("hquestion", (Object)userHistoryMessage.getUser(), i);
                formView.getModel().setValue("hquestion_tag", (Object)userHistoryMessage.getUser(), i);
                formView.getModel().setValue("hanswer", (Object)userHistoryMessage.getAssistant(), i);
                formView.getModel().setValue("hanswer_tag", (Object)userHistoryMessage.getAssistant(), i);
                ++i;
            }
        }
    }
}

