/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.openapi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.gptas.autoact.exception.ChatException;
import kd.bos.gptas.openapi.AccessTokenManager;
import kd.bos.gptas.openapi.OpenApiException;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenApiClient {
    private static final Gson GSON = new Gson();
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");
    private static final String DEFAULT_CONFIG_FILE = "openapi.properties";
    private static final String DEFAULT_READ_TIMEOUT = "200000";
    private static final String DEFAULT_CONNECT_TIMEOUT = "20000";
    private static final String DEFAULT_MAX_IDLE_CONNECTIONS = "20";
    private static final String DEFAULT_KEEP_ALIVE_DURATION = "600000";
    private static final String DEFAULT_LANGUAGE = "zh_CN";
    private final long readTimeout;
    private final long connectTimeout;
    private final int maxIdleConnections;
    private final long keepAliveDuration;
    private final Map<String, Object> data;
    private final String host;
    private final String tokenPath;
    private final OkHttpClient httpClient;

    private OpenApiClient(Builder builder) {
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.maxIdleConnections = builder.maxIdleConnections;
        this.keepAliveDuration = builder.keepAliveDuration;
        this.data = builder.data;
        this.host = builder.host;
        this.tokenPath = builder.tokenPath;
        this.httpClient = new OkHttpClient.Builder().readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(this.maxIdleConnections, this.keepAliveDuration, TimeUnit.MILLISECONDS)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject requestPost(String path, String message) {
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)message);
        Request request = new Request.Builder().url(this.url(this.host, path)).post(requestBody).header("access_token", this.getAccessToken()).header("Content-Type", "application/json").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            JsonObject jsonObject = this.handleResponse(response);
            return jsonObject;
        }
        catch (IOException e) {
            return this.handleIOException(e);
        }
    }

    private String url(String host, String path) {
        if (!host.endsWith("/")) {
            host = host + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return host + path;
    }

    private JsonObject handleResponse(Response response) throws IOException {
        if (response.code() != 200) {
            throw new OpenApiException(response.message(), String.valueOf(response.code()));
        }
        JsonObject responseJson = (JsonObject)GSON.fromJson(response.body().string(), JsonObject.class);
        String errorCode = Optional.ofNullable(responseJson.get("errorCode")).map(JsonElement::getAsString).orElse(null);
        if (errorCode != null && !errorCode.equals("0")) {
            String message = Optional.ofNullable(responseJson.get("message")).map(JsonElement::getAsString).orElse(null);
            throw new OpenApiException(message, errorCode);
        }
        return responseJson;
    }

    private JsonObject handleIOException(IOException e) {
        JsonObject errorJson = new JsonObject();
        errorJson.addProperty("errorCode", "IO_EXCEPTION");
        errorJson.addProperty("message", e.getMessage());
        return errorJson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAccessToken() {
        String accessToken = AccessTokenManager.getAccessToken(this.data);
        if (accessToken != null) {
            return accessToken;
        }
        HashMap<String, Object> requestData = new HashMap<String, Object>(this.data);
        requestData.put("nonce", UUID.randomUUID().toString());
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String timestamp = now.format(formatter);
        requestData.put("timestamp", timestamp);
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)GSON.toJson(requestData));
        Request request = new Request.Builder().url(this.tokenPath).post(requestBody).header("Content-Type", "application/json").build();
        try (Response response = this.httpClient.newCall(request).execute();){
            JsonObject responseJson = (JsonObject)GSON.fromJson(response.body().string(), JsonObject.class);
            String errorCode = Optional.ofNullable(responseJson.get("errorCode")).map(JsonElement::getAsString).orElse(null);
            if (errorCode != null && !errorCode.equals("0")) {
                String message = Optional.ofNullable(responseJson.get("message")).map(JsonElement::getAsString).orElse(null);
                throw new ChatException(errorCode + ": " + message);
            }
            JsonObject resultData = responseJson.getAsJsonObject("data");
            long expiredTime = resultData.get("expires_in").getAsLong();
            accessToken = resultData.get("access_token").getAsString();
            AccessTokenManager.setAccessToken(this.data, accessToken, System.currentTimeMillis() + Math.abs(expiredTime));
            String string = accessToken;
            return string;
        }
        catch (IOException e) {
            throw new OpenApiException("Failed to get access token from " + this.tokenPath, e);
        }
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public static class Builder {
        private String configFile = "openapi.properties";
        private long readTimeout;
        private long connectTimeout;
        private int maxIdleConnections;
        private long keepAliveDuration;
        private String host;
        private String tokenPath;
        private Map<String, Object> data;

        public Builder() {
            this.loadProperties();
        }

        public Builder configFile(String configFile) {
            this.configFile = configFile;
            this.loadProperties();
            return this;
        }

        public Builder readTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder maxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public Builder keepAliveDuration(long keepAliveDuration) {
            this.keepAliveDuration = keepAliveDuration;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.tokenPath = host + "/kapi/oauth2/getToken";
            return this;
        }

        public Builder data(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public OpenApiClient build() {
            return new OpenApiClient(this);
        }

        private void loadProperties() {
            Properties props = new Properties();
            try (InputStream in = OpenApiClient.class.getClassLoader().getResourceAsStream(this.configFile);){
                props.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load config file: " + this.configFile, e);
            }
            this.readTimeout = Long.parseLong(props.getProperty("openapi.readTimeout", OpenApiClient.DEFAULT_READ_TIMEOUT));
            this.connectTimeout = Long.parseLong(props.getProperty("openapi.connectTimeout", OpenApiClient.DEFAULT_CONNECT_TIMEOUT));
            this.maxIdleConnections = Integer.parseInt(props.getProperty("openapi.maxIdleConnections", OpenApiClient.DEFAULT_MAX_IDLE_CONNECTIONS));
            this.keepAliveDuration = Long.parseLong(props.getProperty("openapi.keepAliveDuration", OpenApiClient.DEFAULT_KEEP_ALIVE_DURATION));
            this.host = props.getProperty("openapi.host");
            this.tokenPath = this.host + "/kapi/oauth2/getToken";
            this.data = new HashMap<String, Object>();
            this.data.put("username", props.getProperty("openapi.data.username"));
            this.data.put("client_id", props.getProperty("openapi.data.clientId"));
            this.data.put("client_secret", props.getProperty("openapi.data.clientSecret"));
            this.data.put("accountId", props.getProperty("openapi.data.accountId"));
            this.data.put("language", props.getProperty("openapi.data.language", OpenApiClient.DEFAULT_LANGUAGE));
        }
    }
}

