/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;

public class QACache {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final int CACHE_TIMEOUT = 3600;
    private final Map<String, String> mapCache;
    private final String reqId;
    private static final String allMatch = "#{8}(\\d+?)#{8}";
    private static final String partiMatch = "(#{8}\\d+#{1,8}$)|(#{8}\\d+$)|(#{1,8}$)";
    private String reservedCharacters = "";
    private StringBuilder refIds = new StringBuilder();

    public String getReqId() {
        return this.reqId;
    }

    public QACache(String reqId) {
        this.reqId = reqId;
        this.mapCache = cache.getAll(QACache.getReqRegionKey(reqId));
    }

    public static QACache getByTaskId(String taskId) {
        String reqId = (String)cache.get(QACache.getRegionKey(taskId));
        if (StringUtils.isNotBlank((CharSequence)reqId)) {
            return new QACache(reqId);
        }
        return null;
    }

    public void release() {
        if (this.isExternal()) {
            this.save();
            this.saveRef();
            return;
        }
        cache.remove(QACache.getRegionKey(this.getTaskId()));
        cache.remove(QACache.getReqRegionKey(this.reqId));
        cache.remove(QACache.getRegionKey(this.getTaskId()) + ".llmdata");
        cache.remove(QACache.getRegionKey(this.getTaskId()) + ".reserve");
        cache.remove(QACache.getRegionKey(this.getTaskId()) + ".llmreflist");
    }

    public QACache save() {
        cache.put(QACache.getReqRegionKey(this.reqId), this.mapCache, 3600);
        return this;
    }

    public boolean isStop() {
        return this.mapCache.get("stop") != null && "true".equals(this.mapCache.get("stop"));
    }

    public QACache stop() {
        this.mapCache.put("stop", "true");
        return this;
    }

    private static String getRegionKey(String taskId) {
        return CacheKeyUtil.getAcctId() + ".qacallback." + taskId;
    }

    private static String getReqRegionKey(String reqId) {
        return CacheKeyUtil.getAcctId() + ".qacallback.req." + reqId;
    }

    public String getTaskId() {
        return this.mapCache.get("taskid");
    }

    public QACache setTaskId(String taskId) {
        this.mapCache.put("taskid", taskId);
        cache.put(QACache.getRegionKey(taskId), (Object)this.reqId);
        return this;
    }

    public String popLLMData() {
        String key = QACache.getRegionKey(this.getTaskId()) + ".llmdata";
        String s = cache.getListObject(key, 0);
        if (s != null) {
            cache.removeListObject(key, 0);
        }
        return s;
    }

    public void pushLLMData(String value) {
        String key = QACache.getRegionKey(this.getTaskId()) + ".llmdata";
        cache.addList(key, new String[]{value});
    }

    public String getReservedCharacters() {
        return this.reservedCharacters;
    }

    public void saveRef() {
        String[] list = this.toRefList();
        String key = QACache.getRegionKey(this.getTaskId()) + ".llmreflist";
        if (list != null) {
            cache.addList(key, list);
            this.refIds = new StringBuilder();
        }
        key = QACache.getRegionKey(this.getTaskId()) + ".reserve";
        if (this.reservedCharacters != null) {
            cache.put(key, (Object)this.reservedCharacters, 1000, TimeUnit.SECONDS);
        }
    }

    private String[] toRefList() {
        if (this.refIds.length() > 0) {
            String refIdsString = this.refIds.toString();
            if (refIdsString.endsWith(",")) {
                refIdsString = refIdsString.substring(0, refIdsString.length() - 1);
            }
            return refIdsString.split(",");
        }
        return null;
    }

    public String[] getRef() {
        String[] list = this.toRefList();
        String key = QACache.getRegionKey(this.getTaskId()) + ".llmreflist";
        String[] redisList = cache.getList(key);
        if (list == null || list.length == 0) {
            return redisList;
        }
        if (redisList == null || redisList.length == 0) {
            return list;
        }
        String[] newList = new String[list.length + redisList.length];
        System.arraycopy(redisList, 0, newList, 0, redisList.length);
        System.arraycopy(list, 0, newList, redisList.length, list.length);
        return newList;
    }

    public void initReservedCharacters() {
        String key = QACache.getRegionKey(this.getTaskId()) + ".reserve";
        this.reservedCharacters = (String)cache.get(key);
    }

    public String reservedLLMValue(String llmValue, boolean isEnd) {
        String newLLMValue = llmValue;
        if (this.reservedCharacters != null && !"".equals(this.reservedCharacters)) {
            newLLMValue = this.reservedCharacters + llmValue;
            this.reservedCharacters = "";
        }
        newLLMValue = this.doParseRefId(newLLMValue);
        if (!isEnd) {
            Pattern pattern = Pattern.compile(partiMatch);
            Matcher matcher = pattern.matcher(newLLMValue);
            if (matcher.find()) {
                this.reservedCharacters = matcher.group(0);
            }
            return matcher.replaceAll("");
        }
        return newLLMValue;
    }

    private String doParseRefId(String llmValue) {
        Pattern pattern = Pattern.compile(allMatch);
        Matcher matcher = pattern.matcher(llmValue);
        while (matcher.find()) {
            String group = matcher.group(1);
            this.refIds.append(group).append(",");
        }
        return matcher.replaceAll("");
    }

    public QACache setExternal(boolean external) {
        if (external) {
            this.mapCache.put("external", "true");
        } else {
            this.mapCache.remove("external");
        }
        return this;
    }

    public boolean isExternal() {
        return this.mapCache.containsKey("external");
    }
}

