/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.gptas.qa.QAUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QARecordAction
implements IGPTAction {
    private static final Logger log = LoggerFactory.getLogger(QARecordAction.class);
    private static final String QA_DISP = "QA_RECORD";
    private static final Pattern pattern = Pattern.compile("#+(\\d+?)#+");

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        log.info("QARecordAction.invokeAction, action is " + action + " param is " + SerializationUtils.toJsonString(params));
        if (action.startsWith(QA_DISP)) {
            Object[] businessIds;
            params.put("action", action);
            String answer = params.get("answer");
            Matcher matcher = pattern.matcher(answer);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            while (matcher.find()) {
                ids.add(Long.parseLong(matcher.group(1)));
            }
            log.info("QARecordAction.invokeAction, ids is " + SerializationUtils.toJsonString(ids));
            if (ids.size() > 0 && (businessIds = QAUtil.getChunkBusinessIds(ids.toArray())) != null) {
                QAUtil.saveQARecord(params, Arrays.asList(businessIds));
            }
        }
        return null;
    }
}

