/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.km.IFrameUtil;
import kd.bos.gptas.km.assistant.AssistantPreset;

public class QAResultFormPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject assistant = (DynamicObject)this.getModel().getValue("assistant");
        if (assistant != null) {
            this.getView().getPageCache().put("type", assistant.getString("number"));
        }
        this.loadDemoAssistantCard();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.loadDemoAssistantCard();
        }
    }

    private void loadDemoAssistantCard() {
        Object assistant = this.getModel().getValue("assistant");
        if (null == assistant) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"assistantentry"});
            return;
        }
        String assistantName = ((DynamicObject)assistant).getString("name");
        int index = this.getModel().createNewEntryRow("assistantentry");
        Long assistantId = (Long)((DynamicObject)assistant).getPkValue();
        String assistantImg = ((DynamicObject)assistant).getString("icon");
        if (AssistantPreset.isPresetAssistant(assistantId).booleanValue() && StringUtils.isBlank((CharSequence)assistantImg)) {
            String presetIconUrl = AssistantPreset.getIconUrl(assistantId);
            this.getModel().setValue("assistanticon", (Object)IFrameUtil.buildImageUrl(presetIconUrl, false), index);
        } else {
            this.getModel().setValue("assistanticon", (Object)assistantImg, index);
        }
        this.getModel().setValue("assistantname", (Object)assistantName, index);
        this.getModel().setDataChanged(false);
    }
}

