/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.gptas.qa.model.RefFile;
import kd.bos.gptas.qa.model.UserHistoryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QASessionCache {
    private static final Logger logger = LoggerFactory.getLogger(QASessionCache.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final int CACHE_TIMEOUT = 3600;
    public static final String REFFILE = ".reffile";
    public static final String HISTORY = ".his";
    public static final String HISTORY_TEMP = ".his_temp";
    public static final String LAST_REFFILE = ".lastreffile";
    private final String chatSessionId;
    private Long userId = 0L;

    public QASessionCache(String chatSessionId) {
        this.chatSessionId = chatSessionId;
    }

    public void setUserForTest(Long userId) {
        this.userId = userId;
    }

    public QASessionCache putHistoryMessage(String input, String user, String assiant) {
        UserHistoryMessage userHistoryMessage = new UserHistoryMessage();
        userHistoryMessage.setInput(input);
        userHistoryMessage.setUser(user);
        userHistoryMessage.setAssistant(assiant);
        this.putHistoryMessage(userHistoryMessage, true);
        return this;
    }

    public QASessionCache putHistoryMessageInput(String input, String user) {
        UserHistoryMessage userHistoryMessage = new UserHistoryMessage();
        userHistoryMessage.setInput(input);
        userHistoryMessage.setUser(user);
        this.putHistoryMessage(userHistoryMessage, false);
        return this;
    }

    public QASessionCache putHistoryMessageAssistant(String asssitant, boolean isEnd) {
        UserHistoryMessage userHistoryMessage = new UserHistoryMessage();
        userHistoryMessage.setAssistant(asssitant);
        this.putHistoryMessage(userHistoryMessage, isEnd);
        return this;
    }

    private void putHistoryMessage(UserHistoryMessage historyMessage, boolean isEnd) {
        if (StringUtils.isBlank((CharSequence)this.chatSessionId)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)historyMessage.getInput())) {
            if (StringUtils.isNotBlank((CharSequence)historyMessage.getAssistant())) {
                String key = this.getKey() + HISTORY_TEMP;
                cache.remove(key);
                String[] list = new String[]{SerializationUtils.toJsonString((Object)historyMessage)};
                cache.addList(this.getKey() + HISTORY, list, 3600);
            } else {
                String key = this.getKey() + HISTORY_TEMP;
                cache.put(key, (Object)SerializationUtils.toJsonString((Object)historyMessage), 3600);
            }
        } else {
            String key = this.getKey() + HISTORY_TEMP;
            String s = (String)cache.get(key);
            if (StringUtils.isBlank((CharSequence)s)) {
                logger.error("temp history lost {}", (Object)SerializationUtils.toJsonString((Object)historyMessage));
                return;
            }
            UserHistoryMessage lastHistory = (UserHistoryMessage)SerializationUtils.fromJsonString((String)s, UserHistoryMessage.class);
            lastHistory.setAssistant((lastHistory.getAssistant() == null ? "" : lastHistory.getAssistant()) + historyMessage.getAssistant());
            historyMessage = lastHistory;
            if (isEnd) {
                cache.remove(key);
                String[] list = new String[]{SerializationUtils.toJsonString((Object)historyMessage)};
                cache.addList(this.getKey() + HISTORY, list, 3600);
            } else {
                cache.put(key, (Object)SerializationUtils.toJsonString((Object)historyMessage), 3600);
            }
        }
    }

    public List<UserHistoryMessage> getHistoryMessage() {
        return this.getList(HISTORY, UserHistoryMessage.class);
    }

    private <T> List<T> getList(String subKey, Class<T> claz) {
        if (StringUtils.isBlank((CharSequence)this.chatSessionId)) {
            return Collections.emptyList();
        }
        String[] listCache = cache.getList(this.getKey() + subKey);
        logger.info("get {} list size {}", (Object)claz.getSimpleName(), listCache == null ? "null" : Integer.valueOf(listCache.length));
        if (listCache != null && listCache.length > 0) {
            ArrayList<Object> list = new ArrayList<Object>(listCache.length);
            for (String s : listCache) {
                list.add(SerializationUtils.fromJsonString((String)s, claz));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<RefFile> getLastRefFile() {
        return this.getList(LAST_REFFILE, RefFile.class);
    }

    public String[] getChunkList() {
        if (StringUtils.isBlank((CharSequence)this.chatSessionId)) {
            return null;
        }
        String key = this.getKey() + REFFILE;
        String[] result = cache.getList(this.getKey() + REFFILE);
        logger.info("getChunkList key: {}, size {}", (Object)key, (Object)result.length);
        return result;
    }

    public QASessionCache addChunkList(String[] chunkList) {
        if (StringUtils.isBlank((CharSequence)this.chatSessionId)) {
            return this;
        }
        if (chunkList == null || chunkList.length == 0) {
            return this;
        }
        String key = this.getKey() + REFFILE;
        logger.info("addChunkList key:{}, size {}", (Object)key, (Object)chunkList.length);
        cache.addList(key, chunkList, 3600);
        return this;
    }

    public QASessionCache putLastRefFile(List<RefFile> refFileList) {
        if (StringUtils.isBlank((CharSequence)this.chatSessionId)) {
            return this;
        }
        String key = this.getKey() + LAST_REFFILE;
        if (refFileList == null || refFileList.isEmpty()) {
            logger.info(" remove lastRefFile size {}", (Object)key);
            cache.remove(key);
            return this;
        }
        String[] listCache = new String[refFileList.size()];
        int i = 0;
        for (RefFile refFile : refFileList) {
            listCache[i++] = SerializationUtils.toJsonString((Object)refFile);
        }
        logger.info("putLastRefFile  key: {}  size {}", (Object)key, (Object)refFileList.size());
        cache.resetList(key, listCache, 3600);
        return this;
    }

    private String getKey() {
        return CacheKeyUtil.getAcctId() + ".qasessioncache." + (this.userId == 0L ? RequestContext.get().getCurrUserId() : this.userId.longValue()) + "." + this.chatSessionId;
    }

    public void clear() {
        cache.remove(this.getKey() + HISTORY_TEMP);
        cache.remove(this.getKey() + HISTORY);
        cache.remove(this.getKey() + REFFILE);
    }
}

