/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.gptas.openapi.OpenApiClient;
import kd.bos.gptas.qa.PromptTemplateEnum;
import kd.bos.gptas.qa.QASessionCache;
import kd.bos.gptas.qa.model.RefFile;
import kd.bos.gptas.qa.model.UserHistoryMessage;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QAUtil {
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    private static final Logger log = LoggerFactory.getLogger(QAUtil.class);
    private static final Long DEFAULT_ASSISTANT_ID = 100000L;
    public static final int MAX_TOKEN_LENGTH = 7800;
    private static final Map<String, String> SDKMap = new HashMap<String, String>();

    public static DynamicObjectCollection getChunks(Object[] chunkIds) {
        QFilter qFilter = new QFilter("segmententity.id", "in", (Object)chunkIds);
        return QueryServiceHelper.query((String)"knl_corpus", (String)"id,segmententity.segtime", (QFilter[])new QFilter[]{qFilter});
    }

    public static Object[] getChunkBusinessIds(Object[] chunkIds) {
        return chunkIds;
    }

    public static List<DynamicObject> getFileNameByChunkId(Object[] chunkIds) {
        QFilter qFilter = new QFilter("segmententity.id", "in", (Object)chunkIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"knl_corpus", (String)"id,number,name,datasource_id,segmententity.id,segmententity.segtime", (QFilter[])new QFilter[]{qFilter});
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (DynamicObject row : rows) {
            if (map.containsKey(row.get("id"))) continue;
            map.put(row.get("id"), row);
            list.add(row);
        }
        return list;
    }

    public static void saveQAResult(Map<String, String> params, Long assistantId, String resultType, Integer clientType, List<Object> knlId, List<String> fdbkType, String fdbkDesc) {
        String number;
        Map map;
        String question = params.get("question");
        String currentPageId = params.get("PAGE_ID");
        String formId = "";
        if (params.containsKey("api")) {
            formId = "API";
        } else {
            IFormView viewNoPlugin;
            if (kd.bos.util.StringUtils.isNotEmpty((String)currentPageId)) {
                viewNoPlugin = SessionManager.getCurrent().getViewNoPlugin(currentPageId);
                if (viewNoPlugin == null) {
                    viewNoPlugin = SessionManager.getCurrent().getViewNoPlugin(params.get("ROOT_PAGE_ID"));
                }
            } else {
                viewNoPlugin = SessionManager.getCurrent().getViewNoPlugin(params.get("ROOT_PAGE_ID"));
            }
            formId = QAUtil.getSourceByFormView(viewNoPlugin);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_qaresult");
        DynamicObject data = new DynamicObject((DynamicObjectType)type);
        long id = ID.genLongId();
        String billNo = "QAR_" + id;
        if (params.containsKey("billno")) {
            BusinessDataWriter.delete((String)"bos_qaresult", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)params.get("billno"))});
            billNo = params.get("billno");
        }
        data.set("billno", (Object)billNo);
        data.set("billstatus", (Object)"A");
        data.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        data.set("userinput", (Object)QAUtil.safeSubString(question, 2000));
        data.set("userinput_tag", (Object)question);
        data.set("answer", (Object)QAUtil.safeSubString(params.get("answer"), 2000));
        data.set("answer_tag", (Object)params.get("answer"));
        data.set("currentpage", (Object)formId);
        data.set("type", (Object)resultType);
        data.set("clienttype", (Object)clientType);
        if ("C".equals(resultType)) {
            data.set("fdbktype", (Object)(null == fdbkType ? "" : String.join((CharSequence)",", fdbkType)));
            data.set("fdbkdesc", (Object)(null == fdbkDesc ? "" : fdbkDesc));
        }
        if (null == assistantId || 0L == assistantId) {
            assistantId = DEFAULT_ASSISTANT_ID;
        }
        data.set("assistant", (Object)assistantId);
        String action = params.get("action");
        if (kd.bos.util.StringUtils.isNotEmpty((String)action) && action.startsWith("QA_DISP") && !(map = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = action.substring(8)))})).isEmpty()) {
            DynamicObject row = (DynamicObject)map.values().iterator().next();
            data.set("grouptype_id", row.get("id"));
        }
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        for (Object o : knlId) {
            DynamicObject row = entryentity.addNew();
            row.set("file_id", o);
        }
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new Object[]{data});
    }

    public static void saveQARecord(Map<String, String> params, List<Object> knlId) {
        log.info("QAUtil.saveQARecord knlId " + SerializationUtils.toJsonString(knlId));
        String question = params.get("question");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_qarecord");
        DynamicObject data = new DynamicObject((DynamicObjectType)type);
        long id = ID.genLongId();
        String billNo = "QARECORD_" + id;
        if (params.containsKey("billno")) {
            BusinessDataWriter.delete((String)"bos_qarecord", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)params.get("billno"))});
            billNo = params.get("billno");
        }
        data.set("billno", (Object)billNo);
        data.set("billstatus", (Object)"A");
        data.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        data.set("question", (Object)QAUtil.safeSubString(question, 2000));
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        for (Object o : knlId) {
            DynamicObject row = entryentity.addNew();
            row.set("segmentid", o);
        }
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new Object[]{data});
    }

    private static String safeSubString(String text, int maxLen) {
        if (text.length() > maxLen) {
            return text.substring(0, maxLen);
        }
        return text;
    }

    static String getSourceByFormView(IFormView viewNoPlugin) {
        String formId;
        if (viewNoPlugin == null) {
            return "null formid ";
        }
        String caption = viewNoPlugin.getFormShowParameter().getCaption();
        if (viewNoPlugin.getFormShowParameter() instanceof ListShowParameter) {
            formId = ((ListShowParameter)viewNoPlugin.getFormShowParameter()).getBillFormId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)caption)) {
                caption = caption + ResManager.loadKDString((String)"\u5217\u8868", (String)"QAUtil_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
            }
        } else {
            formId = viewNoPlugin.getFormShowParameter().getFormId();
        }
        if (kd.bos.util.StringUtils.isEmpty((String)caption) && kd.bos.util.StringUtils.isNotEmpty((String)formId)) {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            caption = formConfig.getCaption().toString();
        }
        formId = caption + "(" + formId + ")";
        return formId;
    }

    public static String buildPrompt(String question, String number, String chatSessionId) {
        return QAUtil.buildPrompt(question, number, chatSessionId, 0);
    }

    public static String buildPrompt(String question, String number, String chatSessionId, Integer promptTemplateType) {
        PromptTemplateEnum promptTemplateEnum = PromptTemplateEnum.fromType(promptTemplateType);
        String promptTemplatePath = promptTemplateEnum.getPath();
        String prompt = QAUtil.getActionPromptFromFile(promptTemplatePath);
        if (promptTemplateEnum == PromptTemplateEnum.QA || promptTemplateEnum == PromptTemplateEnum.Java_CodeGen || promptTemplateEnum == PromptTemplateEnum.KingScript_CodeGen) {
            List<Chunk> result = QAUtil.searchChunkList(question, number, 5, chatSessionId);
            List<Map<String, String>> chunkList = QAUtil.createPromptList(number, result, false);
            prompt = prompt.replace("{{chunks}}", SerializationUtils.toJsonString(chunkList));
        }
        prompt = prompt.replace("{{user_input}}", question);
        return prompt;
    }

    public static String buildNextPrompt(String question, String number, String chatSessionId) {
        String prompt = QAUtil.getActionPromptFromFile("prompt/QANext.md");
        List<Chunk> result = QAUtil.searchChunkList(question, number, 5, chatSessionId);
        List<Map<String, String>> chunkList = QAUtil.createPromptList(number, result, false);
        prompt = prompt.replace("{{chunks}}", SerializationUtils.toJsonString(chunkList));
        prompt = prompt.replace("{{user_input}}", question);
        return prompt;
    }

    public static String buildSummaryPrompt(String question, List<UserHistoryMessage> historyMessages) {
        String prompt = QAUtil.getActionPromptFromFile("prompt/QASummary.md");
        prompt = prompt.replace("{{user_input}}", question);
        StringBuilder userHistory = new StringBuilder();
        StringBuilder userQ = new StringBuilder();
        StringBuilder userA = new StringBuilder();
        int i = 1;
        for (UserHistoryMessage historyMessage : historyMessages) {
            userHistory.append("Q").append(i).append(": ").append(historyMessage.getInput()).append("\n");
            userQ.append(historyMessage.getUser()).append("\n");
            userHistory.append("A").append(i).append(": ").append(historyMessage.getAssistant()).append("\n");
            userA.append(historyMessage.getAssistant()).append("\n");
            ++i;
        }
        prompt = prompt.replace("{{user_history}}", userHistory.toString());
        prompt = prompt.replace("{{user_q}}", userQ.toString());
        prompt = prompt.replace("{{user_a}}", userA.toString());
        return prompt;
    }

    public static List<Map<String, String>> createPromptList(String number, List<Chunk> result, boolean allArticle) {
        List<Map<String, String>> chunkList = SDKMap.containsKey(number) ? QAUtil.createCodePromptList(result) : QAUtil.createKMPromptList(result, allArticle);
        return chunkList;
    }

    public static List<Chunk> searchChunkList(String question, String number, int top, String chatSessionId) {
        List<Chunk> result;
        Throwable qFilterKNL;
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"corpus_libs");
        Map mapCorpus = BusinessDataReader.loadFromCache((DynamicObjectType)type, (QFilter[])new QFilter[]{qFilter});
        Optional first = mapCorpus.values().stream().findFirst();
        if (!first.isPresent()) {
            throw new RuntimeException("corpus_libs not exists. " + number);
        }
        QASessionCache qaSessionCache = new QASessionCache(chatSessionId);
        ArrayList<Long> lastRefChunkIds = new ArrayList<Long>(16);
        List<RefFile> lastRefFile = qaSessionCache.getLastRefFile();
        if (CollectionUtils.isNotEmpty(lastRefFile)) {
            MainEntityType knlType = EntityMetadataCache.getDataEntityType((String)"knl_corpus");
            ArrayList<Long> idList = new ArrayList<Long>(lastRefFile.size());
            for (RefFile refFile : lastRefFile) {
                idList.add(Long.parseLong(refFile.getId()));
            }
            qFilterKNL = new QFilter("id", "in", idList);
            String[] knlCorpus = BusinessDataReader.loadFromCache((DynamicObjectType)knlType, (QFilter[])new QFilter[]{qFilterKNL});
            for (Map.Entry kv : knlCorpus.entrySet()) {
                DynamicObjectCollection chunks = ((DynamicObject)kv.getValue()).getDynamicObjectCollection("segmententity");
                for (DynamicObject row : chunks) {
                    lastRefChunkIds.add(row.getLong("id"));
                }
            }
        }
        try {
            qFilterKNL = null;
            try (MilvusDao milvusDao = MilvusDao.createByKM(((DynamicObject)first.get()).getString("indexmethod"));){
                result = milvusDao.searchByChunks(Collections.singletonList(((DynamicObject)first.get()).getLong("id")), lastRefChunkIds, question, top);
            }
            catch (Throwable knlCorpus) {
                qFilterKNL = knlCorpus;
                throw knlCorpus;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String[] existsChunkIds = qaSessionCache.getChunkList();
        HashSet<Long> existsChunkIdSet = new HashSet<Long>();
        if (existsChunkIds != null) {
            for (String existsChunkId : existsChunkIds) {
                existsChunkIdSet.add(Long.parseLong(existsChunkId));
            }
        }
        result.removeIf(o -> o.getChunk() == null || existsChunkIdSet.contains(o.getId()));
        if (SDKMap.containsKey(number)) {
            QAUtil.fillSDKChunk(result, SDKMap.get(number), ((DynamicObject)first.get()).getLong("id"));
        }
        result.removeIf(o -> o.getChunk() == null || existsChunkIdSet.contains(o.getId()));
        String[] chunkIds = new String[result.size()];
        int i = 0;
        for (Chunk chunk : result) {
            chunkIds[i++] = String.valueOf(chunk.getId());
        }
        qaSessionCache.addChunkList(chunkIds);
        return result;
    }

    public static List<Map<String, String>> createKMPromptList(List<Chunk> result, boolean allArticle) {
        HashMap<Object[], Long> artileCount = new HashMap<Object[], Long>(16);
        if (allArticle) {
            int n = 0;
            for (Chunk chunk : result) {
                Object[] pk = chunk.getKNLId();
                if (artileCount.containsKey(pk)) continue;
                n = (int)((long)n + chunk.getKNLLength());
                artileCount.put(pk, chunk.getKNLLength());
            }
            allArticle = n <= 4000;
        }
        ArrayList<Map<String, String>> chunkList = new ArrayList<Map<String, String>>(result.size());
        if (allArticle) {
            Object[] articles;
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"knl_corpus");
            for (Object article : articles = BusinessDataReader.load((Object[])artileCount.keySet().toArray(new Object[0]), (IDataEntityType)type)) {
                DynamicObject row = (DynamicObject)article;
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("doc_id", row.getString("id"));
                map.put("content", row.getString("inputcontent_tag"));
                chunkList.add(map);
            }
        } else {
            int total = 0;
            for (Chunk chunk : result) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)chunk.getChunk())) continue;
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("doc_id", String.valueOf(chunk.getId()));
                map.put("content", chunk.getChunk());
                if (total + chunk.getChunk().length() > 7800) {
                    String chunkText = chunk.getChunk();
                    chunkText = chunkText.substring(0, total + chunkText.length() - 7800);
                    map.put("content", chunkText);
                    chunkList.add(map);
                    break;
                }
                chunkList.add(map);
                total += chunk.getChunk().length();
            }
        }
        return chunkList;
    }

    private static List<Map<String, String>> createCodePromptList(List<Chunk> result) {
        result.removeIf(o -> o.getKNLId() == null);
        HashMap mapChunk = new HashMap(16);
        result.forEach(o -> {
            List chunkList = mapChunk.computeIfAbsent(o.getKNLId(), k -> new ArrayList(16));
            chunkList.add(o);
        });
        ArrayList<Map<String, String>> chunkList = new ArrayList<Map<String, String>>(result.size());
        int total = 0;
        for (Map.Entry kv : mapChunk.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("doc_id", String.valueOf(((Chunk)((List)kv.getValue()).get(0)).getId()));
            StringBuilder content = new StringBuilder();
            content.append(((Chunk)((List)kv.getValue()).get(0)).getCodeDesc()).append("{ \r\n");
            for (Chunk chunk : (List)kv.getValue()) {
                String[] split = chunk.getChunk().split("[\r\n]");
                if (split[0].length() + 2 >= chunk.getChunk().length()) continue;
                content.append(chunk.getChunk().substring(split[0].length() + 2));
            }
            content.append("\r\n}");
            map.put("content", content.toString());
            if (total + content.length() > 7800) {
                content.delete(7800 - total, content.length());
                map.put("content", content.toString());
                chunkList.add(map);
                break;
            }
            chunkList.add(map);
            total += content.length();
        }
        return chunkList;
    }

    private static void fillSDKChunk(List<Chunk> chunkList, String sdkNumber, Long repoId) {
        QFilter qFilter = new QFilter("number", "=", (Object)sdkNumber);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"corpus_libs");
        Map mapCorpus = BusinessDataReader.loadFromCache((DynamicObjectType)type, (QFilter[])new QFilter[]{qFilter});
        Optional first = mapCorpus.values().stream().findFirst();
        if (!first.isPresent()) {
            log.warn("sdk corpus lib not exists.{} ", (Object)sdkNumber);
            return;
        }
        List<Long> sdkRepoList = Collections.singletonList(((DynamicObject)first.get()).getLong("id"));
        try (MilvusDao milvusDao = MilvusDao.createByKM(((DynamicObject)first.get()).getString("indexmethod"));){
            List<Chunk> vectorList = milvusDao.query(Collections.singletonList(repoId), chunkList.stream().map(o -> o.getId()).collect(Collectors.toList()), false);
            HashMap<Long, Chunk> map = new HashMap<Long, Chunk>(16);
            for (Chunk chunk : vectorList) {
                List<Chunk> sdkList = milvusDao.searchIds(chunk.getVector(), sdkRepoList);
                for (Chunk c : sdkList) {
                    map.put(c.getId(), c);
                }
            }
            chunkList.addAll(map.values());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getActionPromptFromFile(String filePath) {
        QFilter qFilter = new QFilter("path", "=", (Object)filePath);
        qFilter.or("number", "=", (Object)filePath);
        Optional<String> prompt = QAUtil.loadPromptFromSkillcorpus(qFilter);
        if (prompt.isPresent()) {
            return prompt.get();
        }
        try (InputStream stream = QAUtil.class.getResourceAsStream("/" + QAUtil.class.getPackage().getName().replace(".", "/") + "/" + filePath);){
            int i;
            if (stream == null) {
                String string = "";
                return string;
            }
            StringBuilder s = new StringBuilder();
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, buf.length)) != -1) {
                s.append(new String(buf, 0, i));
            }
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<String> loadPromptFromSkillcorpus(QFilter qFilter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_skillcorpus", (String)"number, name, inputcontent, inputcontent_tag", (QFilter[])qFilter.and(enableFilter).toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            String json = dynamicObjects[0].getString("inputcontent_tag");
            return Optional.of(json);
        }
        return Optional.empty();
    }

    public static String invokePromptService(Object promptNumber, String input) {
        return QAUtil.invokePromptService(promptNumber, input, "");
    }

    public static String invokePromptService(Object promptNumber, String input, String chatSessionId) {
        String localEnable = SystemPropertyUtils.getProptyByTenant((String)"gpt.local.enable", (String)String.valueOf(Boolean.FALSE));
        if (String.valueOf(Boolean.TRUE).equals(localEnable)) {
            JsonObject jsonObject;
            OpenApiClient openApiClient = OpenApiClient.builder().build();
            HashMap<String, Object> apiParams = new HashMap<String, Object>(16);
            apiParams.put("stream", Boolean.FALSE);
            apiParams.put("promptNumber", promptNumber);
            apiParams.put("input", input);
            apiParams.put("chatSessionId", chatSessionId);
            apiParams.put("varParams", new HashMap(1));
            if (kd.bos.util.StringUtils.isNotEmpty((String)chatSessionId)) {
                jsonObject = openApiClient.requestPost("/kapi/v2/kdtest/gai/promptSyncCallUseHistory", SerializationUtils.toJsonString(apiParams));
                jsonObject = jsonObject.getAsJsonObject("data").getAsJsonObject("result");
            } else {
                jsonObject = openApiClient.requestPost("/kapi/v2/gai/prompt/syncCall", SerializationUtils.toJsonString(apiParams));
            }
            HashMap map = new HashMap(16);
            return jsonObject.getAsJsonObject("data").get("llmValue").getAsString();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", promptNumber)};
        Map prompt = BusinessDataReader.loadFromCache((String)"gai_prompt", (QFilter[])qFilters);
        Optional first = prompt.values().stream().findFirst();
        if (first.isPresent()) {
            boolean status;
            DynamicObject promptData = (DynamicObject)prompt.values().stream().findFirst().get();
            HashMap blank_params = new HashMap(16);
            Map ret = kd.bos.util.StringUtils.isNotEmpty((String)chatSessionId) ? (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCallUseHistoryMsg", (Object[])new Object[]{chatSessionId, promptData.get("id"), input, blank_params}) : (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])new Object[]{promptData.get("id"), input, blank_params});
            boolean bl = status = ret.get("status") != null && (Boolean)ret.get("status") != false;
            if (status) {
                Map dataMap = (Map)ret.get("data");
                return (String)dataMap.get("llmValue");
            }
            throw new RuntimeException((String)ret.get("errMsg"));
        }
        throw new RuntimeException("prompt not exists. number:=" + promptNumber);
    }

    public static String invokePromptServiceAsync(String promptNumber, String input) {
        return QAUtil.invokePromptServiceAsync(promptNumber, input, "");
    }

    public static String invokePromptServiceAsync(String promptNumber, String input, String chatSessionId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)promptNumber)};
        Map prompt = BusinessDataReader.loadFromCache((String)"gai_prompt", (QFilter[])qFilters);
        Optional first = prompt.values().stream().findFirst();
        if (first.isPresent()) {
            DynamicObject promptData = (DynamicObject)prompt.values().stream().findFirst().get();
            HashMap blank_params = new HashMap(16);
            Map ret = kd.bos.util.StringUtils.isNotEmpty((String)chatSessionId) ? (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"asyncCallUseHistoryMsg", (Object[])new Object[]{QAUtil.buildCallBackInfo(), chatSessionId, true, promptData.get("id"), input, blank_params}) : (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"asyncCall", (Object[])new Object[]{QAUtil.buildCallBackInfo(), true, promptData.get("id"), input, blank_params});
            String taskId = QAUtil.getTaskId(ret);
            if (StringUtils.isBlank((CharSequence)taskId)) {
                throw new RuntimeException((String)ret.get("errMsg"));
            }
            return taskId;
        }
        throw new RuntimeException("prompt not exists. number:=" + promptNumber);
    }

    private static String getTaskId(Map<String, Object> result) {
        boolean status;
        boolean bl = status = result.get("status") != null && (Boolean)result.get("status") != false;
        if (status) {
            Map data = (Map)result.get("data");
            return (String)data.get("task_id");
        }
        return "";
    }

    private static Map<String, String> buildCallBackInfo() {
        HashMap<String, String> callBackInfo = new HashMap<String, String>();
        callBackInfo.put("cloudId", "bos");
        callBackInfo.put("appId", "bos");
        callBackInfo.put("serviceName", "QACallBackService");
        callBackInfo.put("methodName", "callBack");
        return callBackInfo;
    }

    static {
        SDKMap.put("cosmic_codegen_java", "cosmic_java_sdk");
        SDKMap.put("cosmic_codegen_kingscript", "cosmic_kingscript_sdk");
    }
}

