/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.client;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.gptas.km.IFrameUtil;
import kd.bos.gptas.qa.client.QAClient;
import kd.bos.gptas.qa.model.QAModel;

public class QAAction
implements IGPTAction {
    private static final String QA_DISP = "QA_DISP";
    private static final Pattern pattern = Pattern.compile("#+(\\d+?)#+");

    public Map<String, String> invokeAction(String action, Map<String, String> params) {
        if (action.startsWith(QA_DISP)) {
            params.put("action", action);
            String question = params.get("question");
            QAModel qaModel = QAClient.create().qa(question, action.substring(8), "");
            String answer = qaModel.getAnswer();
            params.put("answer", qaModel.getAnswer());
            params.put("qamodel", JSON.toJSONString((Object)qaModel));
            HashMap<String, String> result = new HashMap<String, String>(16);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_qagptanswer");
            formShowParameter.setCustomParam("actionparams", (Object)SerializationUtils.toJsonString(params));
            result.put("result", IFrameUtil.buildUrl(this.calcRows(answer) * 24 + 5 + 41 + 16 + qaModel.getRefFileList().size() * 45, formShowParameter));
            return result;
        }
        return null;
    }

    private int calcRows(String value) {
        String[] split = value.split("\n");
        int total = 0;
        for (String s : split) {
            total += (this.getStringLen(s) - 1) / 42 + 1;
        }
        return total;
    }

    private int getStringLen(String value) {
        int len = 0;
        if (value != null) {
            char[] ch;
            for (char c : ch = value.toCharArray()) {
                if (c > '\u007f') {
                    len += 2;
                    continue;
                }
                ++len;
            }
        }
        return len;
    }
}

