/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.gptas.qa.QAUtil;
import kd.bos.gptas.qa.client.QAClient;
import kd.bos.gptas.qa.model.LLMAPIMsg;
import kd.bos.gptas.qa.model.QAModel;
import kd.bos.gptas.qa.webapi.QAService;
import kd.bos.gptas.utils.QaUserTrackUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;

public class QAClientLocalImpl
implements QAClient {
    private static final Log logger = LogFactory.getLog(QAClientLocalImpl.class);

    @Override
    public QAModel qa(String question, String courps_lib, String chatSessionId) {
        CustomApiResult<QAModel> qa = new QAService().qa(question, courps_lib, 4, "", chatSessionId, String.valueOf(RequestContext.get().getCurrUserId()));
        return (QAModel)qa.getData();
    }

    @Override
    public LLMAPIMsg qaPolling(String question, String courps_lib, String requestId, Integer clientType, String userType, String chatSessionId, Integer promptTemplateType, String uid) {
        CustomApiResult<LLMAPIMsg> result = new QAService().qaPolling(question, courps_lib, requestId, clientType, userType, chatSessionId, promptTemplateType, uid);
        if (result.isStatus()) {
            return (LLMAPIMsg)result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public void qaFeedback(String billNo, String question, String answer, String type, String courps_lib, List<Long> knlIds, Integer clientType, String userType, List<String> fdbkType, String fdbkDesc, Long assistantId) {
        QaUserTrackUtil.recordUserAction("qaFeedback", 0, "", "");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("question", question);
        params.put("answer", answer);
        params.put("action", "QA_DISP_" + courps_lib);
        params.put("billno", billNo);
        ArrayList<Object> list = new ArrayList<Object>(knlIds);
        QAUtil.saveQAResult(params, assistantId, type, clientType, list, fdbkType, fdbkDesc);
    }
}

