/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.client;

import com.alibaba.fastjson.JSON;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.gptas.openapi.OpenApiClient;
import kd.bos.gptas.qa.client.QAClient;
import kd.bos.gptas.qa.model.LLMAPIMsg;
import kd.bos.gptas.qa.model.QAModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class QAClientRemoteImpl
implements QAClient {
    private static final Log logger = LogFactory.getLog(QAClientRemoteImpl.class);
    private OpenApiClient openApiClient;

    public QAClientRemoteImpl(String url, String userName, String clientId, String clientSecret, String accountId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("username", userName);
        data.put("client_id", clientId);
        data.put("client_secret", clientSecret);
        data.put("accountId", accountId);
        data.put("language", RequestContext.get().getLang().toString());
        this.openApiClient = OpenApiClient.builder().keepAliveDuration(600000L).connectTimeout(20000L).readTimeout(200000L).maxIdleConnections(20).data(data).host(url).build();
    }

    @Override
    public QAModel qa(String question, String courps_lib, String chatSessionId) {
        HashMap<String, String> msg = new HashMap<String, String>(16);
        msg.put("question", question);
        msg.put("number", courps_lib);
        msg.put("chatSessionId", chatSessionId);
        JsonObject jsonObject = this.openApiClient.requestPost("kapi/v2/devgptas/qa", JSON.toJSONString(msg));
        String errorCode = jsonObject.get("errorCode").getAsString();
        if ("0".equals(errorCode)) {
            return (QAModel)JSON.parseObject((String)jsonObject.getAsJsonObject("data").toString(), QAModel.class);
        }
        QAModel qaModel = new QAModel();
        qaModel.setAnswer(jsonObject.get("message").getAsString());
        return qaModel;
    }

    @Override
    public LLMAPIMsg qaPolling(String question, String courps_lib, String requestId, Integer clientType, String userType, String chatSessionId, Integer promptTemplateType, String uid) {
        HashMap<String, Object> msg = new HashMap<String, Object>(16);
        msg.put("question", question);
        msg.put("number", courps_lib);
        msg.put("chatSessionId", chatSessionId);
        msg.put("requestId", requestId);
        msg.put("clientType", clientType);
        msg.put("userType", userType);
        msg.put("promptTemplateType", promptTemplateType);
        msg.put("uid", uid);
        JsonObject jsonObject = this.openApiClient.requestPost("kapi/v2/devgptas/qaPolling", JSON.toJSONString(msg));
        String errorCode = jsonObject.get("errorCode").getAsString();
        if ("0".equals(errorCode)) {
            return (LLMAPIMsg)JSON.parseObject((String)jsonObject.getAsJsonObject("data").toString(), LLMAPIMsg.class);
        }
        throw new RuntimeException(jsonObject.get("message").getAsString());
    }

    @Override
    public void qaFeedback(String billNo, String question, String answer, String type, String courps_lib, List<Long> knlIds, Integer clientType, String userType, List<String> fdbkType, String fdbkDesc, Long assistantId) {
        HashMap<String, Object> msg = new HashMap<String, Object>(16);
        msg.put("billno", billNo);
        msg.put("question", question);
        msg.put("answer", answer);
        msg.put("type", type);
        msg.put("grouptype", courps_lib);
        msg.put("knlIds", knlIds);
        msg.put("clientType", clientType);
        msg.put("userType", userType);
        msg.put("assistantId", assistantId);
        JsonObject jsonObject = this.openApiClient.requestPost("kapi/v2/devgptas/qaFeedback", JSON.toJSONString(msg));
        String errorCode = jsonObject.get("errorCode").getAsString();
        if (!"0".equals(errorCode)) {
            logger.error(jsonObject.get("message").getAsString());
        }
    }
}

