/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.client;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.km.IFrameUtil;
import kd.bos.gptas.qa.client.QAClient;
import kd.bos.gptas.qa.model.QAModel;
import kd.bos.gptas.qa.model.RefFile;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;

public class QADispResultFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String KNL_URL = "https://vip.kingdee.com/knowledge/%s";
    private static final Log logger = LogFactory.getLog(QADispResultFormPlugin.class);
    private static final long COSMIC_FORUM_ARTICLE = 1000L;
    private static final long COSMIC_FORUM_QUESTION = 1001L;
    private static final long COSMIC_INPUT = 1002L;
    private static final long COSMIC_VIDEO = 1003L;
    private static final String ROOT_PAGE_ID = "ROOT_PAGE_ID";
    public static final String ACTIONMAP = "actionparams";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void showInputArticle(String fileId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("bos_knldetail");
        baseShowParameter.setPkId((Object)fileId);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String rootPageId = this.getActionParams().get(ROOT_PAGE_ID);
        IFormView formView = SessionManager.getCurrent().getViewNoPlugin(rootPageId);
        formView.showForm((FormShowParameter)baseShowParameter);
        IFrameUtil.sendFormActionByWS(rootPageId, formView.getActionResult());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, String> actionparams = this.getActionParams();
        if (actionparams == null) {
            return;
        }
        String answer = actionparams.get("answer");
        QAModel qaModel = (QAModel)JSON.parseObject((String)actionparams.get("qamodel"), QAModel.class);
        this.getModel().setValue("answer", (Object)answer);
        Markdown markdownap = (Markdown)this.getControl("markdownap");
        markdownap.setText(answer);
        if (qaModel.getRefFileList().size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", qaModel.getRefFileList().size());
            int seq = 0;
            for (RefFile refFile : qaModel.getRefFileList()) {
                this.getModel().setValue("txttitle", (Object)refFile.getName(), seq);
                this.getModel().setValue("txtseq", (Object)("[" + (seq + 1) + "]"), seq);
                ++seq;
            }
        } else {
            long id = ID.genLongId();
            String billNo = "QAR_" + id;
            QAClient.create().qaFeedback(billNo, actionparams.get("question"), actionparams.get("answer"), "A", actionparams.get("action").substring(8), Collections.emptyList(), 99, "", Collections.emptyList(), "", 100000L);
        }
    }

    public void afterBindData(EventObject e) {
        String s;
        super.afterBindData(e);
        if (this.getModel().getEntryRowCount("entryentity") == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
        }
        if ("false".equals(s = this.getView().getPageCache().get("resenable"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"resyes", "resno"});
        }
    }

    private Map<String, String> getActionParams() {
        return (Map)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam(ACTIONMAP)), Map.class);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String resultType;
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("doyes")) {
            resultType = "B";
        } else if (args.getOperateKey().equals("dono")) {
            resultType = "C";
        } else {
            return;
        }
        QAModel qaModel = this.getQAModel();
        long id = ID.genLongId();
        String billNo = "QAR_" + id;
        Map<String, String> actionParams = this.getActionParams();
        ArrayList<Long> list = new ArrayList<Long>(qaModel.getRefFileList().size());
        for (RefFile refFile : qaModel.getRefFileList()) {
            list.add(Long.parseLong(refFile.getId()));
        }
        QAClient.create().qaFeedback(billNo, actionParams.get("question"), actionParams.get("answer"), resultType, actionParams.get("action").substring(8), list, 99, "", Collections.emptyList(), "", 100000L);
        this.getView().setEnable(Boolean.FALSE, new String[]{"resyes", "resno"});
        this.getView().getPageCache().put("resenable", "false");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        QAModel qaModel = this.getQAModel();
        if (qaModel.getRefFileList().size() <= rowIndex) {
            return;
        }
        RefFile refFile = qaModel.getRefFileList().get(rowIndex);
        if (StringUtils.isNotBlank((CharSequence)refFile.getUrl())) {
            this.getView().openUrl(refFile.getUrl());
        } else {
            long datasource = refFile.getDataSourceId();
            if (datasource == 1002L) {
                this.showInputArticle(refFile.getId());
            } else if (datasource == 1003L) {
                this.showVideoArticle(refFile.getId(), refFile.getSegTime());
            }
        }
    }

    private QAModel getQAModel() {
        Map<String, String> actionParams = this.getActionParams();
        QAModel qaModel = (QAModel)JSON.parseObject((String)actionParams.get("qamodel"), QAModel.class);
        return qaModel;
    }

    private void showVideoArticle(String fileId, Long currentTime) {
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("bos_knlvideo");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setCustomParam("id", (Object)fileId);
        baseShowParameter.setCustomParam("currenttime", (Object)currentTime.toString());
        String rootPageId = this.getActionParams().get(ROOT_PAGE_ID);
        IFormView formView = SessionManager.getCurrent().getViewNoPlugin(rootPageId);
        formView.showForm(baseShowParameter);
        IFrameUtil.sendFormActionByWS(rootPageId, formView.getActionResult());
    }
}

