/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.gptas.qa.QAUtil;
import kd.bos.gptas.qa.model.RefFile;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.share.ShareUrlService;

@ApiModel
public class QAModel
implements Serializable {
    public static final long COSMIC_FORUM_ARTICLE = 1000L;
    public static final long COSMIC_FORUM_QUESTION = 1001L;
    public static final long COSMIC_INPUT = 1002L;
    public static final long COSMIC_VIDEO = 1003L;
    private static final String KNL_URL = "https://vip.kingdee.com/knowledge/%s";
    private static final Pattern pattern = Pattern.compile("#+(\\d+?)#+");
    @ApiParam(value="\u95ee\u9898")
    private @ApiParam(value="\u95ee\u9898") String question;
    @ApiParam(value="\u7b54\u6848")
    private @ApiParam(value="\u7b54\u6848") String answer;
    @ApiParam(value="\u5f15\u7528\u6587\u4ef6\u5217\u8868")
    private @ApiParam(value="\u5f15\u7528\u6587\u4ef6\u5217\u8868") List<RefFile> refFileList = new ArrayList<RefFile>();

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public List<RefFile> getRefFileList() {
        return this.refFileList;
    }

    public void setRefFileList(List<RefFile> refFileList) {
        this.refFileList = refFileList;
    }

    public static List<RefFile> parseRefFileList(String answer, boolean createShareUrl) {
        List<Object> list = QAModel.parseChunkIdList(answer);
        return QAModel.parseRefFileList(list, createShareUrl);
    }

    public static List<Object> parseChunkIdList(String answer) {
        ArrayList<Object> list = new ArrayList<Object>(16);
        Matcher matcher = pattern.matcher(answer);
        while (matcher.find()) {
            list.add(Long.parseLong(matcher.group(1)));
        }
        return list;
    }

    public static String removeRefFile(String answer) {
        Matcher matcher = pattern.matcher(answer);
        return matcher.replaceAll("");
    }

    public static List<RefFile> parseRefFileList(List<Object> list, boolean createShareUrl) {
        ArrayList<RefFile> refFileList = new ArrayList<RefFile>(16);
        if (!list.isEmpty()) {
            List<DynamicObject> rows = QAUtil.getFileNameByChunkId(list.toArray());
            for (DynamicObject row : rows) {
                String shareUrl;
                RefFile refFile = new RefFile();
                refFile.setName(row.getString("name"));
                refFile.setNumber(row.getString("number"));
                refFile.setId(row.getString("id"));
                long datasource = row.getLong("datasource_id");
                if (datasource == 1000L || datasource == 1001L) {
                    refFile.setUrl(String.format(KNL_URL, refFile.getNumber()));
                } else if (datasource == 1002L) {
                    if (createShareUrl) {
                        shareUrl = ShareUrlService.createShareUrl((String)"bos_knldetail", (String)row.getString("id"), (int)300, (String)RequestContext.get().getUserId(), (String)RequestContext.get().getLang().toString(), (String)RequestContext.get().getAccountId());
                        refFile.setUrl(shareUrl);
                    }
                } else if (datasource == 1003L) {
                    if (createShareUrl) {
                        shareUrl = ShareUrlService.createShareUrl((String)"bos_knlvideo", (String)row.getString("segmententity.id"), (int)300, (String)RequestContext.get().getUserId(), (String)RequestContext.get().getLang().toString(), (String)RequestContext.get().getAccountId());
                        refFile.setUrl(shareUrl);
                    }
                    refFile.setSegTime(row.getInt("segmententity.segtime"));
                }
                refFile.setDataSourceId(datasource);
                refFileList.add(refFile);
            }
        }
        return refFileList;
    }
}

