/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.recommend;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class RecommendQAFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RecommendQAFormPlugin.class);
    private final List<String> faqList = new ArrayList<String>();

    public void initialize() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object actionObj = showParameter.getCustomParam("actionparams");
        if (actionObj instanceof String) {
            Map actionParams = (Map)SerializationUtils.fromJsonString((String)((String)actionObj), Map.class);
            String questions = (String)actionParams.get("recommend.question");
            List questionList = (List)SerializationUtils.fromJsonString((String)questions, List.class);
            this.faqList.addAll(questionList);
            logger.info("RecommendQAFormPlugin.initialize answer" + actionObj);
        }
    }

    public void afterBindData(EventObject e) {
        this.fillFAQList();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        logger.info("RecommendQAFormPlugin.beforeDoOperation source" + source.getOperateKey() + "  type is" + source.getType());
        if (source.getOperateKey().startsWith("setqa")) {
            int index = Integer.parseInt(source.getOperateKey().substring(5));
            String text = this.getView().getPageCache().get("labelap" + index);
            logger.info("RecommendQAFormPlugin.beforeDoOperation  index" + index + " text is" + text);
            try {
                Map actionParams = (Map)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("actionparams")), Map.class);
                logger.info("RecommendQAFormPlugin.beforeDoOperation actionParams is" + SerializationUtils.toJsonString((Object)actionParams));
                String processNumber = (String)actionParams.get("proccess");
                QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)processNumber)};
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_process", (QFilter[])filters);
                if (obj == null) {
                    logger.error("GaiService.startProcessInSideBar error, {} process not exists.", (Object)processNumber);
                    return;
                }
                String designerPageId = (String)actionParams.get("ROOT_PAGE_ID");
                long processId = obj.getLong("id");
                HashMap<String, String> startParams = new HashMap<String, String>();
                startParams.put("input", text);
                try {
                    DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{processId, designerPageId, startParams, text});
                }
                catch (RuntimeException ex) {
                    Throwable cause;
                    for (cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof NoSuchMethodException)) continue;
                        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{processId, designerPageId, startParams});
                        break;
                    }
                    if (cause == null) {
                        throw ex;
                    }
                }
            }
            catch (Exception ex) {
                logger.error("GaiService.startProcessInSideBar error", (Throwable)ex);
            }
        }
    }

    private void fillFAQList() {
        String s = this.getView().getPageCache().get("lastfill");
        CharSequence[] excludes = StringUtils.isNotBlank((CharSequence)s) ? s.split(",") : new String[3];
        int[] indexes = this.getRandomNum(3, 0, this.faqList.size(), (String[])excludes);
        for (int i = 0; i < indexes.length; ++i) {
            Label label = (Label)this.getControl("labelap" + (i + 1));
            String text = this.faqList.get(indexes[i]);
            this.getView().getPageCache().put(label.getKey(), text);
            label.setText(text);
            excludes[i] = String.valueOf(indexes[i]);
        }
        this.getView().getPageCache().put("lastfill", String.join((CharSequence)",", excludes));
    }

    private int[] getRandomNum(int size, int min, int max, String[] excludes) {
        HashSet<Integer> uniqueNumbers = new HashSet<Integer>(16);
        while (uniqueNumbers.size() < size) {
            int n = (int)(Math.random() * (double)max + (double)min);
            for (String exclude : excludes) {
                if (!String.valueOf(n).equals(exclude)) continue;
            }
            uniqueNumbers.add(n);
        }
        int[] numArray = new int[size];
        int index = 0;
        Iterator iterator = uniqueNumbers.iterator();
        while (iterator.hasNext()) {
            int num = (Integer)iterator.next();
            numArray[index++] = num;
        }
        return numArray;
    }
}

