/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.recommend.impl;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.autoact.util.JsonUtil;
import kd.bos.gptas.openapi.OpenApiClient;
import kd.bos.gptas.qa.recommend.RecommendQAService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPTRecommendQA
implements RecommendQAService {
    private static final String RECOMMEND_QA_PROMPT_NUMBER = "bos_qa_2404108B7RECOM";
    private static final Logger log = LoggerFactory.getLogger(GPTRecommendQA.class);
    private static OpenApiClient openApiClient;

    @Override
    public List<String> generateRecoAnswer(Map<String, String> paramMap) {
        ArrayList<String> questions = new ArrayList<String>();
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("user_input", paramMap.get("question"));
        long promptId = 0L;
        String localEnable = SystemPropertyUtils.getProptyByTenant((String)"gpt.local.enable", (String)String.valueOf(Boolean.FALSE));
        if (String.valueOf(Boolean.TRUE).equals(localEnable)) {
            promptId = 1925304216750928896L;
        } else {
            Map promptObj = BusinessDataReader.loadFromCache((String)"gai_prompt", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)RECOMMEND_QA_PROMPT_NUMBER)});
            if (promptObj.size() != 1) {
                return questions;
            }
            Set fids = promptObj.keySet();
            for (Object fid : fids) {
                promptId = (Long)fid;
            }
        }
        String input = paramMap.get("answer");
        if (promptId != 0L && StringUtils.isNotBlank((CharSequence)input)) {
            String llmValue;
            Object[] params = new Object[]{promptId, input, variableMap};
            if (String.valueOf(Boolean.TRUE).equals(localEnable)) {
                llmValue = this.callOpenAPI(params);
            } else {
                boolean status;
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
                boolean bl = status = result.get("status") != null && (Boolean)result.get("status") != false;
                if (status) {
                    Map dataMap = (Map)result.get("data");
                    llmValue = (String)dataMap.get("llmValue");
                } else {
                    throw new RuntimeException((String)result.get("errMsg"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)llmValue)) {
                String[] quesStrs;
                for (String ques : quesStrs = llmValue.split("\n")) {
                    if (ques.length() <= 2) continue;
                    questions.add(ques.substring(2));
                }
            }
            log.info("GPTRecommendQA.generateRecoAnswer questions is" + llmValue);
        }
        return questions;
    }

    private String callOpenAPI(Object[] params) {
        if (openApiClient == null) {
            openApiClient = OpenApiClient.builder().build();
        }
        JsonObject jsonObject = openApiClient.requestPost("/kapi/v2/gai/prompt/syncCall", this.toRequestJsonString(params));
        return jsonObject.getAsJsonObject("data").get("llmValue").getAsString();
    }

    private String toRequestJsonString(Object[] params) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("stream", Boolean.FALSE);
        ret.put("promptNumber", RECOMMEND_QA_PROMPT_NUMBER);
        ret.put("input", params[1]);
        ret.put("varParams", params[2]);
        return JsonUtil.toJSONString(ret, (SerializerFeature[])new SerializerFeature[0]);
    }
}

