/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.recommend.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.gptas.qa.recommend.RecommendQAService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrievalRecommendQA
implements RecommendQAService {
    private static final String EXTRACT_QA_PROMPT_NUMBER = "bos_qa_240409EEXTRACT";
    private static final Logger log = LoggerFactory.getLogger(RetrievalRecommendQA.class);

    @Override
    public List<String> generateRecoAnswer(Map<String, String> params) {
        List<Chunk> result;
        ArrayList<String> questions = new ArrayList<String>();
        String answer = params.get("answer");
        String keyContent = this.extractContent(answer);
        String actionName = params.get("action");
        String[] actionParts = actionName.split("\\|");
        String number = "";
        if (actionParts.length > 2) {
            number = actionParts[1];
        }
        ArrayList<Long> repoIdList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            Collection dynamicObjects = result.values();
            for (DynamicObject dy : dynamicObjects) {
                long repoid = dy.getLong("repoid_id");
                if (repoid == 0L) continue;
                repoIdList.add(repoid);
            }
        }
        result = new ArrayList();
        try {
            log.info("RetrievalRecommendQA.generateRecoAnswer repoIdList is" + SerializationUtils.toJsonString(repoIdList) + "  keyContent is" + keyContent);
            result = MilvusDao.createByGaiRepo((Long)repoIdList.get(0)).search(repoIdList, keyContent);
            log.info("RetrievalRecommendQA.generateRecoAnswer search result is" + SerializationUtils.toJsonString(result) + " repoId is" + SerializationUtils.toJsonString(repoIdList));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        ArrayList<Long> fsegmentids = new ArrayList<Long>();
        if (result.size() > 0) {
            for (Chunk chunk : result) {
                fsegmentids.add(chunk.getId());
            }
        }
        if (fsegmentids.size() > 1) {
            log.info("search segmentid is " + SerializationUtils.toJsonString(fsegmentids));
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid from t_qa_knl ", new Object[0]).appendIn("where fsegmentid", fsegmentids);
            Set ids = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sql, rs -> {
                HashSet<Long> fids = new HashSet<Long>(16);
                while (rs.next()) {
                    fids.add(rs.getLong("fid"));
                }
                return fids;
            });
            Map searchQa = BusinessDataReader.loadFromCache((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_qarecord"));
            Set keys = searchQa.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String question = ((DynamicObject)searchQa.get(iterator.next())).getString("question");
                questions.add(question);
            }
        }
        return questions;
    }

    private String extractContent(String content) {
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.put("user_input", content);
        long promptId = 0L;
        Map promptObj = BusinessDataReader.loadFromCache((String)"gai_prompt", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)EXTRACT_QA_PROMPT_NUMBER)});
        if (promptObj.size() != 1) {
            return "";
        }
        Set fids = promptObj.keySet();
        for (Object fid : fids) {
            promptId = (Long)fid;
        }
        if (promptId != 0L && StringUtils.isNotBlank((CharSequence)content)) {
            Object[] params = new Object[]{promptId, content, variableMap};
            log.info("RetrievalRecommendQA.extractContent variableMap is" + SerializationUtils.toJsonString(variableMap));
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCall", (Object[])params);
            return SerializationUtils.toJsonString((Object)result);
        }
        return "";
    }
}

