/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.service;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.gptas.qa.QACache;
import kd.bos.gptas.qa.service.QACallBackService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class QACallBackServiceImpl
implements QACallBackService {
    private static final Log logger = LogFactory.getLog(QACallBackServiceImpl.class);

    @Override
    public void callBack(Map<String, Object> resp) {
        String taskId = QACallBackServiceImpl.getTaskId(resp);
        if (StringUtils.isBlank((CharSequence)taskId)) {
            logger.error("can't get taskid\u3002{}", (Object)SerializationUtils.toJsonString(resp));
            return;
        }
        QACache qaCache = QACache.getByTaskId(taskId);
        if (qaCache == null) {
            return;
        }
        resp.put("APIRequestId", qaCache.getReqId());
        String llmValue = SerializationUtils.toJsonString(resp);
        logger.info("putLLMData:{}", (Object)llmValue);
        qaCache.pushLLMData(llmValue);
    }

    private static String getTaskId(Map<String, Object> response) {
        Map dataMap;
        Object taskId;
        Object data = response.get("data");
        if (data != null && (taskId = (dataMap = (Map)data).get("taskId")) != null) {
            return taskId.toString();
        }
        return "";
    }

    private int getSeq(Map<String, Object> response) {
        Map dataMap;
        Object isEnd;
        Object data = response.get("data");
        if (data != null && (isEnd = (dataMap = (Map)data).get("seqNo")) != null) {
            return (Integer)isEnd;
        }
        return -1;
    }

    private static boolean isEnd(Map<String, Object> response) {
        Map dataMap;
        Object isEnd;
        Object data = response.get("data");
        if (data != null && (isEnd = (dataMap = (Map)data).get("isEnd")) != null) {
            return (Boolean)isEnd;
        }
        return false;
    }
}

