/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.qa.QACache;
import kd.bos.gptas.qa.QAUtil;
import kd.bos.gptas.qa.webapi.ReqQAModel;
import kd.bos.gptas.utils.QaUserTrackUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.ICustomApiServlet;
import org.apache.commons.io.IOUtils;

public class QAServlet
implements ICustomApiServlet {
    private static final Log logger = LogFactory.getLog(QAServlet.class);
    private static final long TASK_MAX_TIME = 60000L;

    public String getInputParameter() {
        return null;
    }

    public String getOutputParameter() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(HttpServletRequest req, HttpServletResponse resp) {
        QaUserTrackUtil.recordUserAction("QAServlet", 0, "", "");
        OutputStream out = null;
        ReqQAModel reqQAModel = new ReqQAModel();
        try (ServletInputStream in = req.getInputStream();){
            req.setCharacterEncoding(StandardCharsets.UTF_8.name());
            reqQAModel = (ReqQAModel)JSON.parseObject((byte[])IOUtils.toByteArray((InputStream)in), ReqQAModel.class, (Feature[])new Feature[0]);
            QACache qaCache = new QACache(reqQAModel.getRequestId()).save();
            String prompt = QAUtil.buildPrompt(reqQAModel.getQuestion(), reqQAModel.getNumber(), reqQAModel.getChatSessionId());
            String taskId = QAUtil.invokePromptServiceAsync("gptas-default", prompt);
            qaCache.setTaskId(taskId).save();
            resp.addHeader("Content-Type", "text/event-stream");
            out = resp.getOutputStream();
            long ts = System.currentTimeMillis();
            boolean dataNoSend = true;
            do {
                String llmData;
                if (!StringUtils.isBlank((CharSequence)(llmData = qaCache.popLLMData()))) {
                    Map mapData = (Map)SerializationUtils.fromJsonString((String)llmData, Map.class);
                    this.writeData(mapData, out);
                    dataNoSend = false;
                    if (!QAServlet.isEnd(mapData)) continue;
                    break;
                }
                Thread.sleep(300L);
            } while (System.currentTimeMillis() - ts <= 60000L);
            if (dataNoSend) {
                Map<String, Object> resultMap = QAServlet.buildErr(reqQAModel.getRequestId(), new ErrorCode("102", "call error"));
                this.writeData(resultMap, out);
            }
            qaCache.release();
        }
        catch (IOException ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_INTERNAL_ERROR, ex.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            ErrorCode errorCode;
            Map<String, Object> resultMap = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)e).getErrorCode()) ? QAServlet.buildErr(reqQAModel.getRequestId(), errorCode) : QAServlet.buildErr(reqQAModel.getRequestId(), new ErrorCode("101", e.getMessage()))) : QAServlet.buildErr(reqQAModel.getRequestId(), new ErrorCode("101", e.getMessage()));
            try {
                out = resp.getOutputStream();
                this.writeData(resultMap, out);
            }
            catch (IOException ex) {
                throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_INTERNAL_ERROR, ex.getMessage(), new Object[0]);
            }
            logger.error(String.format("\u3010GPT\u63d0\u793a-openAPI\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528-\u5f02\u5e38\uff0crequestId:%s,question\uff1a%s,errMsg\uff1a%s", reqQAModel.getRequestId(), reqQAModel.getQuestion(), JSON.toJSONString((Object)resp)), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean isEnd(Map<String, Object> response) {
        Map dataMap;
        Object isEnd;
        Object data = response.get("data");
        if (data != null && (isEnd = (dataMap = (Map)data).get("isEnd")) != null) {
            return (Boolean)isEnd;
        }
        return false;
    }

    private void writeData(Map<String, Object> resultMap, OutputStream out) {
        String data = JSON.toJSONString(resultMap);
        try {
            out.write((data + "\n").getBytes(StandardCharsets.UTF_8));
            out.flush();
            logger.info("write data {}", (Object)JSON.toJSONString(resultMap));
        }
        catch (IOException e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, e.getMessage(), new Object[0]);
        }
    }

    private static Map<String, Object> buildErr(String requestId, ErrorCode errorCode) {
        HashMap<String, Object> resp = new HashMap<String, Object>(4);
        resp.put("requestId", requestId);
        resp.put("errCode", errorCode.getCode());
        resp.put("errMsg", errorCode.getMessage());
        resp.put("status", false);
        return resp;
    }
}

