/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.api.BizAppService;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.service.ProductModelFilterUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.CtlSchemaInfo;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.metadata.form.control.CustomControlAp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.FormRoot;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppLangItemBuilder;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ControlSchemaServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DeployCustomerCtlHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class BizAppServiceImpl
implements BizAppService {
    private static final Log LOGGER = LogFactory.getLog((String)"BizAppServiceImpl");
    private static final String MENUS = "menus";
    private static final String APPID = "appId";
    private static final String FORMID = "formId";
    private static final String FAPPID = "FAPPID";
    private static final String BIZCLOUD = "bizcloud";
    private static final String T_META_APPRUNTIME = "T_META_APPRUNTIME";
    private static final String T_META_APPRUNTIME_L = "T_META_APPRUNTIME_L";
    private static final String ISYZJSPECIALVERSION = "isyzjspecialversion";
    private static final String FNAME = "FNAME";
    private static final String BIZAPPID = "bizappid";
    private static final String SEQUENCE = "sequence";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String FORMNAME = "formName";
    private static final String FORMNUMBER = "formNumber";
    private static final String SUBMENUS = "submenus";
    private static final String IMAGE = "image";
    private static final String BACKIMAGE = "backimage";
    private static final String IMAGESPATH = "images/pc/cardbackground/cloud_ pingtai.png";
    private static final String DESCRIPTION = "description";
    private static final String PORTAL = "portal";
    private static final String INDUSTRY = "industry";
    private static final String SIMPLENAME = "simplename";
    private static final String DEPLOYSTATUS = "deploystatus";
    private static final String BIZAPP = "bizapp";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String IDE_CONTROLSCHEMA = "ide_controlschema";
    private static final String SCHMAID = "schemaid";
    private static final String SEARCH_CONTEMT_REGEX = "^[a-zA-Z0-9_]+$";

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("AppMetadata", new DistributeCacheHAPolicy(true, true));
    }

    public Object searchAppAndMenu(String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(100000L));
        appParam.setActBookId(Long.valueOf(0L));
        boolean paramFlag = false;
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (paramMap != null && paramMap.get(ISYZJSPECIALVERSION) != null) {
            paramFlag = (Boolean)paramMap.get(ISYZJSPECIALVERSION);
        }
        Map<String, Set<String>> spellDict = BizAppServiceImpl.isChineseEnvironment() ? this.searchSpellDict(key) : new HashMap<String, Set<String>>();
        JSONArray apps = this.searchApp(key, paramFlag, spellDict.get("app"));
        JSONArray menus = this.searchMenu(key, paramFlag, spellDict.get("menu"));
        if (BizAppServiceImpl.isChineseEnvironment() && key.matches(".*[\\s'].*")) {
            String specialKey = key.replaceAll("[\\s']", "");
            Map<String, Set<String>> specialSpellDict = this.searchSpellDict(specialKey);
            JSONArray specialApps = this.searchApp(specialKey, paramFlag, specialSpellDict.get("app"));
            JSONArray specialMenus = this.searchMenu(specialKey, paramFlag, specialSpellDict.get("menu"));
            apps.addAll((Collection)specialApps);
            menus.addAll((Collection)specialMenus);
        }
        JSONObject result = new JSONObject();
        result.put("apps", (Object)apps);
        result.put(MENUS, (Object)menus);
        return result;
    }

    private static boolean isChineseEnvironment() {
        Lang lang = RequestContext.get().getLang();
        return lang.equals((Object)Lang.zh_CN) || lang.equals((Object)Lang.zh_TW);
    }

    private JSONArray searchApp(String key, Boolean paramFlag, Set<String> appIds) {
        StringBuilder selectSql = new StringBuilder();
        String cp = this.getCP();
        if (paramFlag.booleanValue()) {
            selectSql.append(String.format("SELECT app.FAPPID as FAPPID,app.FID as FID,appl.FNAME as FNAME,app.FCLOUDID as FCLOUDID,cloudl.FNAME as FCLOUDNAME FROM %s app LEFT JOIN %s appl ON app.FAPPID=appl.FAPPID AND appl.FLOCALEID='%s' LEFT JOIN %s cloudl ON app.FCLOUDID=cloudl.FID AND cloudl.FLOCALEID='%s' WHERE appl.FNAME %s ?", T_META_APPRUNTIME, T_META_APPRUNTIME_L, Lang.get().toString(), "T_META_BIZCLOUD_L", Lang.get().toString(), cp));
        } else {
            selectSql.append(String.format("SELECT app.FAPPID as FAPPID,app.FID as FID,appl.FNAME as FNAME,app.FCLOUDID as FCLOUDID,cloudl.FNAME as FCLOUDNAME FROM %s app LEFT JOIN %s appl ON app.FAPPID=appl.FAPPID AND appl.FLOCALEID='%s' LEFT JOIN %s cloudl ON app.FCLOUDID=cloudl.FID AND cloudl.FLOCALEID='%s' WHERE cloudl.FID <> '%s' AND appl.FNAME %s ?", T_META_APPRUNTIME, T_META_APPRUNTIME_L, Lang.get().toString(), "T_META_BIZCLOUD_L", Lang.get().toString(), "0B+E5YAC2OJF", cp));
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":appl.FNAME", 12, (Object)("%" + key + "%"))};
        ResultSetHandler<JSONArray> action = new ResultSetHandler<JSONArray>(){

            public JSONArray handle(ResultSet rs) throws Exception {
                JSONArray apps = new JSONArray();
                while (rs.next()) {
                    JSONObject app = new JSONObject();
                    app.put("id", (Object)rs.getString("FID"));
                    app.put("number", (Object)rs.getString(BizAppServiceImpl.FAPPID));
                    app.put("name", (Object)rs.getString(BizAppServiceImpl.FNAME));
                    app.put("cloudId", (Object)rs.getString("FCLOUDID"));
                    app.put("cloudName", (Object)rs.getString("FCLOUDNAME"));
                    apps.add((Object)app);
                }
                return apps;
            }
        };
        if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"use.spelldict", (Boolean)true).booleanValue() && appIds != null && appIds.size() > 0) {
            StringBuilder appenSql = new StringBuilder().append(" or app.FID in (");
            for (String appId : appIds) {
                appenSql.append("'").append(appId).append("'").append(",");
            }
            int index = appenSql.lastIndexOf(",");
            if (index != -1) {
                appenSql.deleteCharAt(index);
            }
            appenSql.append(")");
            selectSql.append((CharSequence)appenSql);
        }
        return (JSONArray)DB.query((DBRoute)DBRoute.meta, (String)selectSql.toString(), (Object[])params, (ResultSetHandler)action);
    }

    private String getCP() {
        String cp = "like";
        String tenantId = RequestContext.get().getTenantId();
        if (DB.getDBType((DBRoute)DBRoute.meta) == DBType.PostgreSQL && "true".equalsIgnoreCase(SystemPropertyUtils.getProptyByTenant((String)"orm.opt.pg.ignorecase", (String)tenantId))) {
            cp = "ilike";
        }
        return cp;
    }

    private JSONArray searchMenu(String key, Boolean paramFlag, Set<String> menuIds) {
        StringBuilder selectSql = new StringBuilder();
        String cp = this.getCP();
        if (paramFlag.booleanValue()) {
            selectSql.append(String.format("SELECT menu.FAPPID as FAPPID,menu.FID as FID,menu.FFORMID as FFORMID,menu.FPARAMS as FPARAMS,menul.FNAME as FNAME,appl.FNAME as FAPPNAME FROM %s menu LEFT JOIN %s menul ON menu.FID=menul.FID AND menul.FLOCALEID='%s' LEFT JOIN %s appl ON menu.FAPPID=appl.FAPPID AND appl.FLOCALEID='%s' WHERE menu.FFORMID <> ' ' AND menul.FNAME %s ?", "T_META_MENURUNTIME", "T_META_MENURUNTIME_L", Lang.get().toString(), T_META_APPRUNTIME_L, Lang.get().toString(), cp));
        } else {
            selectSql.append(String.format("SELECT menu.FAPPID as FAPPID,menu.FID as FID,menu.FFORMID as FFORMID,menu.FPARAMS as FPARAMS,menul.FNAME as FNAME,appl.FNAME as FAPPNAME FROM %s menu LEFT JOIN %s menul ON menu.FID=menul.FID AND menul.FLOCALEID='%s' LEFT JOIN %s appl ON menu.FAPPID=appl.FAPPID AND appl.FLOCALEID='%s' LEFT JOIN %s app ON app.FNUMBER = appl.FAPPID LEFT JOIN %s cloud on app.FBIZCLOUDID = cloud.FID WHERE menu.FFORMID <> ' ' AND cloud.FID <> '%s' AND menul.FNAME %s ?", "T_META_MENURUNTIME", "T_META_MENURUNTIME_L", Lang.get().toString(), T_META_APPRUNTIME_L, Lang.get().toString(), "T_META_BIZAPP", "T_META_BIZCLOUD", "0B+E5YAC2OJF", cp));
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":menul.FNAME", 12, (Object)("%" + key + "%"))};
        ResultSetHandler<JSONArray> action = new ResultSetHandler<JSONArray>(){

            public JSONArray handle(ResultSet rs) throws Exception {
                JSONArray menus = new JSONArray();
                while (rs.next()) {
                    JSONObject menu = new JSONObject();
                    menu.put("id", (Object)rs.getString("FID"));
                    menu.put("name", (Object)rs.getString(BizAppServiceImpl.FNAME));
                    menu.put(BizAppServiceImpl.FORMID, (Object)rs.getString("FFORMID"));
                    menu.put(BizAppServiceImpl.APPID, (Object)rs.getString(BizAppServiceImpl.FAPPID));
                    menu.put("appName", (Object)rs.getString("FAPPNAME"));
                    menus.add((Object)menu);
                }
                return menus;
            }
        };
        if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"use.spelldict", (Boolean)true).booleanValue() && menuIds != null && menuIds.size() > 0) {
            StringBuilder appenSql = new StringBuilder().append(" or (menu.FFORMID <> ' ' AND menu.FID in (");
            for (String menuId : menuIds) {
                appenSql.append("'").append(menuId).append("'").append(",");
            }
            int index = appenSql.lastIndexOf(",");
            if (index != -1) {
                appenSql.deleteCharAt(index);
            }
            appenSql.append("))");
            selectSql.append((CharSequence)appenSql);
        }
        return (JSONArray)DB.query((DBRoute)DBRoute.meta, (String)selectSql.toString(), (Object[])params, (ResultSetHandler)action);
    }

    private Map<String, Set<String>> searchSpellDict(String key) {
        HashMap<String, Set<String>> spellMap = new HashMap<String, Set<String>>();
        Pattern pattern = Pattern.compile(SEARCH_CONTEMT_REGEX);
        Matcher macher = pattern.matcher(key);
        if (macher.matches()) {
            Map selectDictResult = new HashMap();
            if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"use.spelldict", (Boolean)true).booleanValue()) {
                String lowerKey = key.toLowerCase();
                String selectDictSql = "SELECT FOBJID,FTYPE FROM T_META_DATASPELLDICT WHERE FFULLSPELL LIKE ? OR FFIRSTSPELL LIKE ?";
                Object[] selectDictParam = new SqlParameter[]{new SqlParameter(":FFULLSPELL", 12, (Object)("%" + lowerKey + "%")), new SqlParameter(":FFIRSTSPELL", 12, (Object)("%" + lowerKey + "%"))};
                ResultSetHandler<Object> resultSetHandler = new ResultSetHandler<Object>(){

                    public Object handle(ResultSet rs) throws Exception {
                        HashMap<String, String> ids = new HashMap<String, String>(16);
                        while (rs.next()) {
                            ids.put(rs.getString("FOBJID"), rs.getString("FTYPE"));
                        }
                        return ids;
                    }
                };
                selectDictResult = (Map)DB.query((DBRoute)DBRoute.meta, (String)selectDictSql, (Object[])selectDictParam, (ResultSetHandler)resultSetHandler);
            }
            if (selectDictResult.size() > 0) {
                Set entrySet = selectDictResult.entrySet();
                for (Map.Entry entry : entrySet) {
                    String type = (String)entry.getValue();
                    Set idSet = spellMap.computeIfAbsent(type, k -> new HashSet());
                    idSet.add(entry.getKey());
                }
            }
        }
        return spellMap;
    }

    public TreeNode getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime) {
        TreeNode root = AppUtils.getSubsysTree((String[])bizCloudIds, (String[])bizAppIds, (String)industryId, (String)leafType, (boolean)isRuntime);
        return root;
    }

    public TreeNode getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime, boolean onlyVisible, boolean onlyDeployed) {
        TreeNode root = AppUtils.getSubsysTree((String[])bizCloudIds, (String[])bizAppIds, (String)industryId, (String)leafType, (boolean)isRuntime, (boolean)onlyVisible, (boolean)onlyDeployed);
        return root;
    }

    public TreeNode getRuntimeSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType) {
        return this.getSubsysTree(bizCloudIds, bizAppIds, industryId, leafType, true);
    }

    public Map<String, Object> getAppListInfo(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int start, int limit) {
        return AppUtils.getAppListInfo((QFilter[])filters, (String)industryId, (boolean)isRuntime, (String)orderBy, (int)start, (int)limit);
    }

    public Map<String, Object> getFormListInfo(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int start, int limit) {
        return AppUtils.getFormListInfo((QFilter[])filters, (String)industryId, (boolean)isRuntime, (String)orderBy, (int)start, (int)limit);
    }

    public Map<String, Object> getRuntimeAppListInfo(QFilter[] filters, String industryId, String orderBy, int start, int limit) {
        return this.getAppListInfo(filters, industryId, true, orderBy, start, limit);
    }

    public Map<String, Object> getRuntimeFormListInfo(QFilter[] filters, String industryId, String orderBy, int start, int limit) {
        return this.getFormListInfo(filters, industryId, true, orderBy, start, limit);
    }

    public Object getCloudAndAppInfoByFormId(String formId) {
        String selectSql = String.format("SELECT cloud.FNUMBER AS FCLOUDNUMBER,app.FNUMBER AS FAPPNUMBER,app.FID AS FBIZAPPID FROM %s AS cloud JOIN %s AS app ON cloud.FID=app.FBIZCLOUDID JOIN %s AS form ON app.FID=form.FBIZAPPID WHERE form.FNUMBER=?", "t_meta_bizcloud", "t_meta_bizapp", "t_meta_formdesign");
        Object[] params = new SqlParameter[]{new SqlParameter(":form.FNUMBER", 12, (Object)formId)};
        ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                JSONObject obj = null;
                if (rs.next()) {
                    obj = new JSONObject();
                    obj.put("cloudnumber", (Object)rs.getString("FCLOUDNUMBER"));
                    obj.put(BizAppServiceImpl.BIZAPPID, (Object)rs.getString("FBIZAPPID"));
                    obj.put(BizAppServiceImpl.APPID, (Object)rs.getString("FAPPNUMBER"));
                }
                return obj;
            }
        };
        JSONObject sRet = (JSONObject)DB.query((DBRoute)DBRoute.meta, (String)selectSql, (Object[])params, (ResultSetHandler)action);
        return sRet;
    }

    public Map<String, Object> createExtAppMetadata(String bizAppId, String extAppId) {
        String currentIsv = this.getIsv();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String appNum = appMeta.getNumber();
        String bizCloudId = appMeta.getBizCloudID();
        String appType = appMeta.getDevType();
        String mainFormName = appMeta.getAppElement().getMainFormName();
        String dependency = appMeta.getAppElement().getDependency();
        if (StringUtils.isBlank((CharSequence)extAppId)) {
            extAppId = DBServiceHelper.genStringId();
        }
        String extAppNum = "";
        extAppNum = this.autoExtendedNumber(appNum);
        extAppNum = this.autoAppNumber(bizCloudId, extAppNum, "_ext");
        appMeta.setNumber(extAppNum);
        String appParentId = bizAppId;
        appMeta.setParentId(appParentId);
        String extAppMasterId = "";
        extAppMasterId = "2".equals(appType) ? appMeta.getMasterId() : bizAppId;
        appMeta.setId(extAppId);
        appMeta.setDevType("2");
        if (StringUtils.isBlank((CharSequence)mainFormName)) {
            appMeta.getAppElement().setMainFormID(" ");
            appMeta.getAppElement().setMainFormName(" ");
        }
        if (StringUtils.isBlank((CharSequence)dependency)) {
            appMeta.getAppElement().setDependencyID(" ");
            appMeta.getAppElement().setDependency(" ");
        }
        appMeta.setMasterId(extAppMasterId);
        appMeta.setIsv(currentIsv);
        String parentInheritPath = appMeta.getInheritPath();
        String inheritPath = "";
        inheritPath = StringUtils.isNotBlank((CharSequence)parentInheritPath) ? parentInheritPath + "," + appParentId : appParentId;
        if (inheritPath != null && inheritPath.trim().length() == 0) {
            inheritPath = "";
        }
        appMeta.setInheritPath(inheritPath);
        Map resultMap = AppMetaServiceHelper.save((AppMetadata)appMeta);
        resultMap.put("extappid", extAppId);
        resultMap.put("extappnum", extAppNum);
        return resultMap;
    }

    public String autoExtendedNumber(String number) {
        String isv = this.getIsv();
        number = number.toLowerCase(Locale.ENGLISH);
        if (!"kingdee".equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv) && !number.startsWith(isv.toLowerCase(Locale.ENGLISH) + "_")) {
            number = isv.toLowerCase(Locale.ENGLISH) + "_" + number;
        }
        return number + "_ext";
    }

    public String autoAppNumber(String bizCloudId, String appNumber, String tag) {
        if (appNumber.length() <= 25) {
            if (this.checkAppNumber(bizCloudId, appNumber)) {
                int i = 1;
                String number = appNumber + i;
                while (this.checkAppNumber(bizCloudId, number)) {
                    number = appNumber + ++i;
                }
                appNumber = number;
            }
        } else {
            int tag_len = tag.length();
            appNumber = appNumber.substring(0, 25 - tag_len) + tag;
            int i = 0;
            while (this.checkAppNumber(bizCloudId, appNumber)) {
                int i_len = String.valueOf(++i).length();
                appNumber = appNumber.substring(0, 25 - tag_len - i_len) + tag + i;
            }
        }
        return appNumber;
    }

    private boolean checkAppNumber(String bizCloudId, String appNumber) {
        QFilter q1 = new QFilter(BIZCLOUD, "=", (Object)bizCloudId);
        QFilter q2 = new QFilter("number", "=", (Object)appNumber);
        QFilter[] filters = new QFilter[]{q1, q2};
        boolean exists = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])filters);
        return exists;
    }

    public boolean isCustomForm(String formId) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        boolean rt = true;
        try {
            FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
            if (metadata != null) {
                String bizAppId;
                String formIsv = metadata.getIsv();
                if (StringUtils.isBlank((CharSequence)formIsv) && StringUtils.isNotBlank((CharSequence)(bizAppId = metadata.getBizappId()))) {
                    AppMetadata app = AppReader.loadMeta((String)bizAppId, (boolean)false);
                    formIsv = app.getIsv();
                }
                if (StringUtils.isNotBlank((CharSequence)formIsv) && formIsv.equals("kingdee")) {
                    rt = false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return rt;
    }

    public String getIsv() {
        return AppUtils.getDeveloperInfo();
    }

    public List<String> getFormsIdByAppId(String appId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)true);
        List functionElements = metadata.getAppFunctionPackets();
        ArrayList<String> fpIdList = new ArrayList<String>(functionElements.size());
        for (AppFunctionPacketElement fp : functionElements) {
            fpIdList.add(fp.getId());
        }
        QFilter[] filters = new QFilter[]{new QFilter("bizunit", "in", (Object)fpIdList.toArray())};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"form");
        filters = ProductModelFilterUtils.appendFormIdFilters("form", filters, appId);
        DynamicObject[] unitreForms = BusinessDataServiceHelper.load((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])filters);
        ArrayList<String> formIds = new ArrayList<String>(unitreForms.length);
        for (DynamicObject obj : unitreForms) {
            String formId = obj.getString("form");
            formIds.add(formId);
        }
        return formIds;
    }

    public List<Map<String, Object>> getFormsRuntimeInfoByAppId(String appId) {
        List<String> formIds = this.getFormsIdByAppId(appId);
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(formIds.size());
        for (String formId : formIds) {
            HashMap<String, String> formInfo = new HashMap<String, String>();
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            LocaleString caption = formConfig.getCaption();
            FormRoot root = FormMetadataCache.getRootControl((String)formId);
            formInfo.put("id", formId);
            formInfo.put("name", caption.getLocaleValue());
            formInfo.put("number", root.getKey());
            ret.add(formInfo);
        }
        return ret;
    }

    public List<String> getSysAppsId() {
        boolean buildEnable = Boolean.getBoolean("appmeta.runtimebuild.enable");
        if (!buildEnable) {
            Map appInfoMap = AppMetadataCache.getVisibleAndEnableAppInfos();
            ArrayList<String> appIds = new ArrayList<String>(16);
            for (AppInfo appInfo : appInfoMap.values()) {
                appIds.add(appInfo.getId());
            }
            return appIds;
        }
        ArrayList<String> appIds = new ArrayList();
        String selectSql = String.format("SELECT FAPPID,FID FROM %s", T_META_APPRUNTIME);
        String appBlacklist = RunModeServiceHelper.getAppNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)(appBlacklist = ProductModelFilterUtils.appendAppNumFilterStr(appBlacklist)))) {
            selectSql = String.format("SELECT FAPPID,FID FROM %s WHERE FAPPID NOT IN(%s)", T_META_APPRUNTIME, appBlacklist);
        }
        final ArrayList runtimeApps = new ArrayList();
        ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    runtimeApps.add(rs.getString("FID"));
                }
                return runtimeApps;
            }
        };
        appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)selectSql, null, (ResultSetHandler)action);
        return appIds;
    }

    public List<String> getSysAppsNumber() {
        boolean buildEnable = Boolean.getBoolean("appmeta.runtimebuild.enable");
        if (!buildEnable) {
            Map appInfoMap = AppMetadataCache.getVisibleAndEnableAppInfos();
            ArrayList<String> appIds = new ArrayList<String>(16);
            for (AppInfo appInfo : appInfoMap.values()) {
                appIds.add(appInfo.getAppId());
            }
            return appIds;
        }
        ArrayList<String> appNumbers = new ArrayList();
        String selectSql = String.format("SELECT FAPPID,FID FROM %s", T_META_APPRUNTIME);
        String appBlacklist = RunModeServiceHelper.getAppNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)(appBlacklist = ProductModelFilterUtils.appendAppNumFilterStr(appBlacklist)))) {
            selectSql = String.format("SELECT FAPPID,FID FROM %s WHERE FAPPID NOT IN(%s)", T_META_APPRUNTIME, appBlacklist);
        }
        final ArrayList runtimeApps = new ArrayList();
        ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    runtimeApps.add(rs.getString(BizAppServiceImpl.FAPPID));
                }
                return runtimeApps;
            }
        };
        appNumbers = (List)DB.query((DBRoute)DBRoute.meta, (String)selectSql, null, (ResultSetHandler)action);
        return appNumbers;
    }

    public List<String> getAppsIdByCloudId(String cloudId) {
        boolean buildEnable = Boolean.getBoolean("appmeta.runtimebuild.enable");
        if (!buildEnable) {
            Map appInfoMap = AppMetadataCache.getVisibleAndEnableAppInfos();
            ArrayList<String> appIds = new ArrayList<String>(16);
            for (AppInfo appInfo : appInfoMap.values()) {
                if (!appInfo.getCloudId().equals(cloudId)) continue;
                appIds.add(appInfo.getId());
            }
            return appIds;
        }
        ArrayList<String> appIds = new ArrayList();
        String selectSql = String.format("SELECT FAPPID,FID FROM %s WHERE FCLOUDID=?", T_META_APPRUNTIME);
        String appBlacklist = RunModeServiceHelper.getAppNumFromBlacklist();
        if (StringUtils.isNotEmpty((CharSequence)(appBlacklist = ProductModelFilterUtils.appendAppNumFilterStr(appBlacklist)))) {
            selectSql = String.format("SELECT FAPPID,FID FROM %s WHERE FCLOUDID=? AND FAPPID NOT IN(%s)", T_META_APPRUNTIME, appBlacklist);
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FCLOUDID", 12, (Object)cloudId)};
        final ArrayList runtimeApps = new ArrayList();
        ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    runtimeApps.add(rs.getString("FID"));
                }
                return runtimeApps;
            }
        };
        appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)selectSql, (Object[])params, (ResultSetHandler)action);
        return appIds;
    }

    private Map<String, String> getAppNumbersByCloudId(String cloudId, boolean onlyActive) {
        boolean buildEnable = Boolean.getBoolean("appmeta.runtimebuild.enable");
        if (!buildEnable) {
            Map appInfoMap = onlyActive ? AppMetadataCache.getVisibleAndEnableAppInfos() : AppMetadataCache.getAllAppInfo();
            HashMap<String, String> appIds = new HashMap<String, String>(16);
            for (AppInfo appInfo : appInfoMap.values()) {
                if (!appInfo.getCloudId().equals(cloudId) || !"2".equals(appInfo.getDeployStatus())) continue;
                appIds.put(appInfo.getId(), appInfo.getAppId());
            }
            return appIds;
        }
        HashMap<String, String> apps = new HashMap();
        QFilter[] filters = null;
        if (onlyActive) {
            String selectSql = String.format("SELECT FAPPID,FID FROM %s WHERE FCLOUDID=?", T_META_APPRUNTIME);
            String appNumBlackList = RunModeServiceHelper.getAppNumFromBlacklist();
            if (StringUtils.isNotEmpty((CharSequence)(appNumBlackList = ProductModelFilterUtils.appendAppNumFilterStr(appNumBlackList)))) {
                selectSql = String.format("SELECT FAPPID,FID FROM %s WHERE FCLOUDID=? AND FAPPID NOT IN (%s)", T_META_APPRUNTIME, appNumBlackList);
            }
            Object[] params = new SqlParameter[]{new SqlParameter(":FCLOUDID", 12, (Object)cloudId)};
            final HashMap runtimeApps = new HashMap();
            ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        runtimeApps.put(rs.getString("FID"), rs.getString(BizAppServiceImpl.FAPPID));
                    }
                    return runtimeApps;
                }
            };
            apps = (Map)DB.query((DBRoute)DBRoute.meta, (String)selectSql, (Object[])params, (ResultSetHandler)action);
        } else {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            QFilter f1 = new QFilter(BIZCLOUD, "=", (Object)cloudId);
            filterList.add(f1);
            QFilter f4 = new QFilter("type", "!=", (Object)"2");
            filterList.add(f4);
            filters = filterList.toArray(new QFilter[filterList.size()]);
            filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])filters, (String)"id");
            filters = ProductModelFilterUtils.appendAppIdQFilter(filters, "id");
            Map appMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id,number,sequence", (QFilter[])filters, (String)SEQUENCE);
            if (appMap == null || appMap.size() == 0) {
                return null;
            }
            for (DynamicObject app : appMap.values()) {
                apps.put(app.getString("id"), app.getString("number"));
            }
        }
        return apps;
    }

    public List<String> getSysRuntimeMainConsoleInfoGroupByCloud() {
        String selectFields = "id, sequence, number, name";
        ArrayList<String> info = new ArrayList<String>();
        Map cloudMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields, null, (String)SEQUENCE);
        if (cloudMap == null || cloudMap.size() == 0) {
            return null;
        }
        JSONObject cloudValue = new JSONObject();
        for (DynamicObject cloud : cloudMap.values()) {
            String cloudId = cloud.getString("id");
            List<String> appsInfo = this.getAppsRuntimeMainConsoleInfoByCloudId(cloudId);
            JSONObject cloudInfo = new JSONObject();
            if (appsInfo == null || appsInfo.size() <= 0) continue;
            Short sequence = (short)cloud.getInt(SEQUENCE);
            cloudInfo.put("id", (Object)cloudId);
            cloudInfo.put("number", (Object)cloud.getString("number"));
            cloudInfo.put("name", (Object)cloud.getLocaleString("name").getLocaleValue());
            cloudInfo.put(SEQUENCE, (Object)sequence);
            cloudValue.put("cloudinfo", (Object)cloudInfo);
            cloudValue.put("appsinfo", appsInfo);
            info.add(cloudValue.toJSONString());
            cloudInfo.clear();
        }
        return info;
    }

    public List<String> getAppsRuntimeMainConsoleInfoByCloudId(String cloudId) {
        Map<String, String> apps = this.getAppNumbersByCloudId(cloudId, true);
        if (apps == null || apps.size() == 0) {
            return null;
        }
        LOGGER.debug(cloudId + " : kd.bos.devportal.service.BizAppServiceImpl.getAppNumbersByCloudId : " + SerializationUtils.toJsonString(apps));
        ArrayList<String> ret = new ArrayList<String>(apps.size());
        JSONObject appInfo = new JSONObject();
        ArrayList<String> continueApps = new ArrayList<String>(10);
        for (String appNumber : apps.values()) {
            AppInfo app = null;
            List menusInfo = null;
            try {
                app = AppMetadataCache.getAppInfo((String)appNumber);
                menusInfo = AppMetadataCache.getAppMenusInfoByAppId((String)appNumber);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u5e94\u7528ID\u4e3a\uff1a%s \u7684\u5e94\u7528\u5143\u6570\u636e\u5f02\u5e38\u3002", (String)"BizAppServiceImpl_0", (String)"bos-mservice-devportal", (Object[])new Object[]{appNumber});
                LOGGER.error(msg, (Throwable)e);
            }
            if (app == null || !app.isRealRuntime()) {
                continueApps.add(appNumber);
                continue;
            }
            appInfo.put("id", (Object)app.getId());
            appInfo.put("number", (Object)app.getAppId());
            appInfo.put("name", (Object)(app.getName() == null ? ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"BizAppServiceImpl_1", (String)"bos-mservice-devportal", (Object[])new Object[0]) : app.getName().getLocaleValue()));
            if (menusInfo != null) {
                JSONArray menus = this.getFormatMenus(menusInfo);
                appInfo.put(MENUS, (Object)menus);
            }
            ret.add(appInfo.toJSONString());
            appInfo.clear();
        }
        LOGGER.debug(cloudId + " : app == null || !app.isRealRuntime() : " + SerializationUtils.toJsonString(continueApps));
        return ret;
    }

    private JSONArray getDesigntimeFormatMenus(List<AppMenuElement> menus, boolean onlyVisble) {
        JSONArray formatMenus = new JSONArray();
        if (menus != null && menus.size() > 0) {
            Collections.sort(menus, new Comparator<AppMenuElement>(){

                @Override
                public int compare(AppMenuElement o1, AppMenuElement o2) {
                    return o1.getSeq() - o2.getSeq();
                }
            });
            HashMap<String, JSONObject> mapMenu = new HashMap<String, JSONObject>();
            for (AppMenuElement menu : menus) {
                if (onlyVisble && ("false".equals(menu.getVisible()) || "0".equals(menu.getVisible()))) continue;
                JSONObject menuInfo = new JSONObject();
                String parentId = menu.getParentId();
                String menuId = menu.getId();
                if (StringUtils.isBlank((CharSequence)parentId)) {
                    if (StringUtils.isBlank(mapMenu.get(menuId))) {
                        menuInfo.put("id", (Object)menuId);
                    } else {
                        menuInfo = (JSONObject)mapMenu.get(menuId);
                    }
                    menuInfo.put("name", (Object)menu.getName());
                    String formId = menu.getFormId();
                    if (StringUtils.isNotBlank((CharSequence)formId)) {
                        menuInfo.put(FORMID, (Object)formId);
                        menuInfo.put(FORMNAME, (Object)menu.getFormName());
                        menuInfo.put(FORMNUMBER, (Object)menu.getFormNumber());
                    }
                    if (StringUtils.isBlank((Object)menuInfo.get((Object)SUBMENUS))) {
                        menuInfo.put(SUBMENUS, (Object)new JSONArray());
                    }
                    mapMenu.put(menuId, menuInfo);
                    continue;
                }
                JSONObject subMenuInfo = new JSONObject();
                subMenuInfo.put("id", (Object)menuId);
                subMenuInfo.put("name", (Object)menu.getName());
                String formId = menu.getFormId();
                if (StringUtils.isNotBlank((CharSequence)formId)) {
                    subMenuInfo.put(FORMID, (Object)formId);
                    subMenuInfo.put(FORMNAME, (Object)menu.getFormName());
                    subMenuInfo.put(FORMNUMBER, (Object)menu.getFormNumber());
                }
                JSONObject parentMenu = (JSONObject)mapMenu.get(parentId);
                JSONArray subMenus = new JSONArray();
                if (StringUtils.isBlank((Object)parentMenu)) {
                    menuInfo.put("id", (Object)parentId);
                    mapMenu.put(parentId, menuInfo);
                } else {
                    menuInfo = parentMenu;
                    subMenus = menuInfo.getJSONArray(SUBMENUS);
                }
                subMenus.add((Object)subMenuInfo);
                menuInfo.put(SUBMENUS, (Object)subMenus);
            }
            formatMenus.addAll(mapMenu.values());
        }
        return formatMenus;
    }

    private JSONArray getFormatMenus(List<AppMenuInfo> menus) {
        JSONArray formatMenus = new JSONArray();
        HashMap<String, JSONObject> mapMenu = new HashMap<String, JSONObject>();
        if (menus != null) {
            for (AppMenuInfo menu : menus) {
                JSONObject menuInfo = new JSONObject();
                String parentId = menu.getParentId();
                String menuId = menu.getId();
                LocaleString menuName = menu.getName();
                if (StringUtils.isBlank((CharSequence)parentId)) {
                    if (StringUtils.isBlank(mapMenu.get(menuId))) {
                        menuInfo.put("id", (Object)menuId);
                    } else {
                        menuInfo = (JSONObject)mapMenu.get(menuId);
                    }
                    String name = "";
                    if (StringUtils.isNotBlank((Object)menuName)) {
                        name = menuName.getLocaleValue();
                    }
                    menuInfo.put("name", (Object)name);
                    menuInfo.put(FORMNAME, (Object)menu.getFormName());
                    menuInfo.put(FORMNUMBER, (Object)menu.getFormId());
                    if (StringUtils.isBlank((Object)menuInfo.get((Object)SUBMENUS))) {
                        menuInfo.put(SUBMENUS, (Object)new JSONArray());
                    }
                    mapMenu.put(menuId, menuInfo);
                    continue;
                }
                JSONObject subMenuInfo = new JSONObject();
                subMenuInfo.put("id", (Object)menuId);
                String name = "";
                if (StringUtils.isNotBlank((Object)menuName)) {
                    name = menuName.getLocaleValue();
                }
                subMenuInfo.put("name", (Object)name);
                subMenuInfo.put(FORMNAME, (Object)menu.getFormName());
                subMenuInfo.put(FORMNUMBER, (Object)menu.getFormId());
                JSONObject parentMenu = (JSONObject)mapMenu.get(parentId);
                JSONArray subMenus = new JSONArray();
                if (StringUtils.isBlank((Object)parentMenu)) {
                    menuInfo.put("id", (Object)parentId);
                    mapMenu.put(parentId, menuInfo);
                } else {
                    menuInfo = parentMenu;
                    subMenus = menuInfo.getJSONArray(SUBMENUS);
                }
                subMenus.add((Object)subMenuInfo);
                menuInfo.put(SUBMENUS, (Object)subMenus);
            }
            formatMenus.addAll(mapMenu.values());
        }
        return formatMenus;
    }

    public List<String> getSysAppsRuntimeInfoGroupByCloud(boolean onlyActive) {
        String selectFields = "id, sequence, number, name, image, backimage";
        ArrayList<String> info = new ArrayList<String>();
        QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters(null, (String)"id");
        Map cloudMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields, (QFilter[])(filters = ProductModelFilterUtils.appendCloudIdQFilter(filters, "id")), (String)SEQUENCE);
        if (cloudMap == null || cloudMap.size() == 0) {
            return null;
        }
        JSONObject cloudValue = new JSONObject();
        for (DynamicObject cloud : cloudMap.values()) {
            String cloudId = cloud.getString("id");
            List<String> appsInfo = this.getAppsRuntimeInfoByCloudId(cloudId, onlyActive);
            if (appsInfo == null || appsInfo.size() <= 0) continue;
            JSONObject cloudInfo = new JSONObject();
            cloudInfo.put("id", (Object)cloudId);
            cloudInfo.put("number", (Object)cloud.getString("number"));
            cloudInfo.put("name", (Object)cloud.getLocaleString("name").getLocaleValue());
            cloudInfo.put("seq", (Object)cloud.getString(SEQUENCE));
            String image = cloud.getString(IMAGE);
            String bgImage = cloud.getString(BACKIMAGE);
            if (image == null || "".equals(image.trim())) {
                image = IMAGESPATH;
            }
            if (bgImage == null || "".equals(bgImage.trim())) {
                bgImage = IMAGESPATH;
            }
            cloudInfo.put(IMAGE, (Object)image);
            cloudInfo.put(BACKIMAGE, (Object)bgImage);
            cloudValue.put("cloudinfo", (Object)cloudInfo);
            cloudValue.put("appsinfo", appsInfo);
            info.add(cloudValue.toJSONString());
            cloudValue.clear();
        }
        return info;
    }

    public List<String> getSysAppsRuntimeInfoGroupByCloud() {
        return this.getSysAppsRuntimeInfoGroupByCloud(true);
    }

    public List<String> getAppsRuntimeInfoByCloudId(String cloudId) {
        return this.getAppsRuntimeInfoByCloudId(cloudId, true);
    }

    public String getAppRuntimeInfo(String appNumber) {
        String homeURL;
        String mainFormType;
        String orgFunc;
        String userType;
        boolean allUserApp;
        String openType;
        String homeNum;
        String homeId;
        String image;
        String dbRoute;
        String cloudId;
        Short seq;
        String bizAppId = this.getAppIdByAppNumber(appNumber);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId);
        JSONObject obj = new JSONObject();
        if (appMeta == null) {
            return null;
        }
        String appId = appMeta.getNumber();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            obj.put("number", (Object)appId);
            obj.put(APPID, (Object)appId);
        }
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            obj.put("id", (Object)bizAppId);
        }
        if (StringUtils.isNotBlank((Object)(seq = Short.valueOf(appMeta.getAppElement().getSeq())))) {
            obj.put("seq", (Object)seq);
        }
        if (StringUtils.isNotBlank((CharSequence)(cloudId = appMeta.getBizCloudID()))) {
            obj.put("cloudId", (Object)cloudId);
            String selectFields = "number";
            DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)cloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields);
            if (cloud != null) {
                obj.put("cloudNum", (Object)cloud.getString("number"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(dbRoute = appMeta.getAppElement().getDbRoute()))) {
            obj.put("dbRoute", (Object)dbRoute);
        }
        if (StringUtils.isNotBlank((CharSequence)(image = appMeta.getAppElement().getImage()))) {
            obj.put(IMAGE, (Object)image);
        }
        if (StringUtils.isNotBlank((CharSequence)(homeId = appMeta.getAppElement().getMainFormID()))) {
            obj.put("homeId", (Object)homeId);
        }
        if (StringUtils.isNotBlank((CharSequence)(homeNum = appMeta.getAppElement().getMainFormNumber()))) {
            obj.put("homeNum", (Object)homeNum);
        }
        if (StringUtils.isNotBlank((CharSequence)(openType = appMeta.getAppElement().getOpenType()))) {
            obj.put("openType", (Object)openType);
        }
        boolean bl = allUserApp = "1".equals(appMeta.getAppElement().getAllUserApp());
        if (StringUtils.isNotBlank((Object)allUserApp)) {
            obj.put("allUserApp", (Object)allUserApp);
        }
        if (!"1".equals(appMeta.getAppElement().getVisible()) || !"2".equals(appMeta.getAppElement().getDeployStatus())) {
            boolean realRuntime = false;
            obj.put("realRuntime", (Object)realRuntime);
        }
        if (StringUtils.isNotBlank((CharSequence)(userType = appMeta.getAppElement().getUserType()))) {
            obj.put("userType", (Object)userType);
        }
        if (StringUtils.isNotBlank((CharSequence)(orgFunc = appMeta.getAppElement().getOrgFunc()))) {
            obj.put("orgFunc", (Object)orgFunc);
        }
        if (StringUtils.isNotBlank((CharSequence)(mainFormType = appMeta.getAppElement().getMainFormType()))) {
            obj.put("mainFormType", (Object)mainFormType);
        }
        if (StringUtils.isNotBlank((CharSequence)(homeURL = appMeta.getAppElement().getHomeURL()))) {
            obj.put("homeURL", (Object)homeURL);
        }
        obj.put("name", (Object)appMeta.getAppElement().getName());
        obj.put(DESCRIPTION, (Object)appMeta.getAppElement().getDescription());
        return obj.toJSONString();
    }

    public String getAppRuntimeMenusInfo(String appNumber) {
        String bizAppId = this.getAppIdByAppNumber(appNumber);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId);
        String appId = appMeta.getNumber();
        JSONArray menus = new JSONArray();
        ArrayList<String> formIdList = new ArrayList<String>(appMeta.getAppMenus().size());
        for (AppMenuElement menu : appMeta.getAppMenus()) {
            String formId = menu.getFormId();
            if (!StringUtils.isNotBlank((CharSequence)formId)) continue;
            formIdList.add(formId);
        }
        Map<String, String> formEntityNumMap = BizAppServiceImpl.getEntityNumsByFormNums(formIdList);
        for (AppMenuElement menu : appMeta.getAppMenus()) {
            String shortcutIcon;
            String naviVector;
            String parentId;
            String permission;
            String menuOpenType;
            String parameters;
            String paramType;
            String formId;
            JSONObject objMenu = new JSONObject();
            String menuId = menu.getId();
            if (StringUtils.isNotBlank((CharSequence)menuId)) {
                objMenu.put("id", (Object)menuId);
            }
            objMenu.put(APPID, (Object)appId);
            Short menuSeq = menu.getSeq();
            if (StringUtils.isNotBlank((Object)menuSeq)) {
                objMenu.put("seq", (Object)menuSeq);
            }
            if (StringUtils.isNotBlank((CharSequence)(formId = menu.getFormId()))) {
                objMenu.put(FORMID, (Object)MetadataDao.getNumberById((String)formId));
                objMenu.put("entityNumber", (Object)formEntityNumMap.get(formId));
            }
            if (StringUtils.isNotBlank((CharSequence)(paramType = menu.getParameterType()))) {
                objMenu.put("paramType", (Object)paramType);
            }
            if (StringUtils.isNotBlank((CharSequence)(parameters = menu.getParameter()))) {
                objMenu.put("params", (Object)parameters);
            }
            if (StringUtils.isNotBlank((CharSequence)(menuOpenType = menu.getOpenType()))) {
                objMenu.put("openType", (Object)menuOpenType);
            }
            if (StringUtils.isNotBlank((CharSequence)(permission = menu.getPermission()))) {
                objMenu.put("permission", (Object)permission);
            }
            if (StringUtils.isNotBlank((CharSequence)(parentId = menu.getParentId()))) {
                objMenu.put("parentId", (Object)parentId);
            }
            if (StringUtils.isNotBlank((CharSequence)(naviVector = menu.getVectorImage()))) {
                objMenu.put("naviVector", (Object)naviVector);
            }
            if (StringUtils.isNotBlank((CharSequence)(shortcutIcon = menu.getIconShortcut()))) {
                objMenu.put("shortcutIcon", (Object)shortcutIcon);
            }
            objMenu.put("name", (Object)menu.getName());
            objMenu.put(DESCRIPTION, (Object)menu.getDescription());
            objMenu.put(FORMNAME, (Object)menu.getFormName());
            menus.add((Object)objMenu);
        }
        return menus.toString();
    }

    public List<String> getAppsRuntimeInfoByCloudId(String cloudId, boolean onlyActive) {
        Map<String, String> apps = this.getAppNumbersByCloudId(cloudId, onlyActive);
        if (apps == null || apps.size() == 0) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (onlyActive) {
            for (String appNumber : apps.values()) {
                DynamicObject obj;
                if (PORTAL.equals(appNumber)) continue;
                AppInfo app = null;
                try {
                    app = AppMetadataCache.getAppInfo((String)appNumber);
                }
                catch (Exception e) {
                    String msg = ResManager.loadKDString((String)"\u5e94\u7528ID\u4e3a\uff1a%s \u7684\u5e94\u7528\u5143\u6570\u636e\u5f02\u5e38\u3002", (String)"BizAppServiceImpl_0", (String)"bos-mservice-devportal", (Object[])new Object[]{appNumber});
                    LOGGER.error(msg, (Throwable)e);
                }
                if (app == null || !app.isRealRuntime() || (obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)INDUSTRY, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appNumber)})) == null) continue;
                JSONObject appInfo = this.getAppInfo(app.getId(), app.getNumber(), (ILocaleString)app.getName(), (int)app.getSeq().shortValue(), app.getImage(), (ILocaleString)app.getDescription(), "2");
                DynamicObject industry = (DynamicObject)obj.get(INDUSTRY);
                if (industry != null) {
                    appInfo.put(INDUSTRY, (Object)industry.getLocaleString(SIMPLENAME));
                }
                ret.add(appInfo.toJSONString());
            }
        } else {
            for (Map.Entry<String, String> appEntry : apps.entrySet()) {
                AppMetadata metadata = null;
                String appId = appEntry.getKey();
                try {
                    metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)true);
                }
                catch (Exception e) {
                    String msg = ResManager.loadKDString((String)"\u5e94\u7528ID\u4e3a\uff1a%s \u7684\u5e94\u7528\u5143\u6570\u636e\u5f02\u5e38\u3002", (String)"BizAppServiceImpl_0", (String)"bos-mservice-devportal", (Object[])new Object[]{appEntry.getValue()});
                    LOGGER.error(msg, (Throwable)e);
                }
                if (metadata == null || "0".equals(metadata.getAppElement().getVisible()) || PORTAL.equals(metadata.getNumber())) continue;
                JSONObject appInfo = this.getAppInfo(appId, metadata.getNumber(), (ILocaleString)metadata.getName(), (int)metadata.getAppElement().getSeq(), metadata.getAppElement().getImage(), (ILocaleString)metadata.getAppElement().getDescription(), metadata.getAppElement().getDeployStatus());
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)INDUSTRY, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)appId)});
                if (obj != null && obj.get(INDUSTRY) != null) {
                    DynamicObject industry = (DynamicObject)obj.get(INDUSTRY);
                    appInfo.put(INDUSTRY, (Object)industry.getLocaleString(SIMPLENAME));
                }
                ret.add(appInfo.toJSONString());
            }
        }
        return ret;
    }

    private JSONObject getAppInfo(String id, String number, LocaleString name, int seq, String image, String description, String deploystatus) {
        JSONObject appInfo = new JSONObject();
        appInfo.put("id", (Object)id);
        appInfo.put("number", (Object)number);
        appInfo.put("name", (Object)name.getLocaleValue());
        appInfo.put("seq", (Object)seq);
        appInfo.put(IMAGE, (Object)image);
        appInfo.put(DESCRIPTION, (Object)description);
        appInfo.put(DEPLOYSTATUS, (Object)deploystatus);
        return appInfo;
    }

    private JSONObject getAppInfo(String id, String number, ILocaleString name, int seq, String image, ILocaleString description, String deploystatus) {
        JSONObject appInfo = this.getAppInfo(id, number, name, seq, image, description, deploystatus, "", "");
        return appInfo;
    }

    private JSONObject getAppInfo(String id, String number, ILocaleString name, int seq, String image, ILocaleString description, String deploystatus, String isv, String type) {
        JSONObject appInfo = new JSONObject();
        appInfo.put("id", (Object)id);
        appInfo.put("number", (Object)number);
        appInfo.put("name", (Object)name);
        appInfo.put("seq", (Object)seq);
        appInfo.put(IMAGE, (Object)image);
        appInfo.put(DESCRIPTION, (Object)description);
        appInfo.put(DEPLOYSTATUS, (Object)deploystatus);
        if (StringUtils.isNotBlank((CharSequence)isv)) {
            appInfo.put("isv", (Object)isv);
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            appInfo.put("type", (Object)type);
        }
        return appInfo;
    }

    private JSONObject getCloudInfo(String id, String number, ILocaleString name, int seq, String image, ILocaleString description) {
        JSONObject cloudInfo = new JSONObject();
        cloudInfo.put("id", (Object)id);
        cloudInfo.put("number", (Object)number);
        cloudInfo.put("name", (Object)name);
        cloudInfo.put("seq", (Object)seq);
        cloudInfo.put(IMAGE, (Object)image);
        cloudInfo.put(DESCRIPTION, (Object)description);
        return cloudInfo;
    }

    @Deprecated
    public String getAppRuntimeMetaById(String appId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)true);
        JSONObject ret = this.getAppInfo(appId, metadata.getNumber(), metadata.getName(), (int)metadata.getAppElement().getSeq(), metadata.getAppElement().getImage(), metadata.getAppElement().getDescription().getLocaleValue(), metadata.getAppElement().getDeployStatus());
        List<String> menus = this.getAppMenusRuntimeInfo(metadata);
        ret.put(MENUS, menus);
        List<String> funcs = this.getAppFuncsRuntimeInfo(metadata);
        ret.put("funcs", funcs);
        return null;
    }

    @Deprecated
    private List<String> getAppMenusRuntimeInfo(AppMetadata metadata) {
        List menus = metadata.getAppMenus();
        Collections.sort(menus, new Comparator<AppMenuElement>(){

            @Override
            public int compare(AppMenuElement o1, AppMenuElement o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        ArrayList<String> ret = new ArrayList<String>(menus.size());
        JSONObject menuInfo = new JSONObject();
        for (AppMenuElement menu : menus) {
            menuInfo.put("id", (Object)menu.getId());
            menuInfo.put("number", (Object)menu.getNumber());
            menuInfo.put("name", (Object)menu.getName().getLocaleValue());
            menuInfo.put("parentid", (Object)menu.getParentId());
            menuInfo.put("seq", (Object)menu.getSeq());
            ret.add(menuInfo.toJSONString());
            menuInfo.clear();
        }
        return ret;
    }

    @Deprecated
    public List<String> getAppMenusRuntimeInfoById(String appId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)true);
        return this.getAppMenusRuntimeInfo(metadata);
    }

    @Deprecated
    private List<String> getAppFuncsRuntimeInfo(AppMetadata metadata) {
        List funcs = metadata.getAppFunctionPackets();
        Collections.sort(funcs, new Comparator<AppFunctionPacketElement>(){

            @Override
            public int compare(AppFunctionPacketElement o1, AppFunctionPacketElement o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        ArrayList<String> ret = new ArrayList<String>(funcs.size());
        JSONObject funcInfo = new JSONObject();
        for (AppFunctionPacketElement func : funcs) {
            funcInfo.put("id", (Object)func.getId());
            funcInfo.put("number", (Object)func.getNumber());
            funcInfo.put("name", (Object)func.getName().getLocaleValue());
            funcInfo.put("parentid", (Object)func.getParentId());
            funcInfo.put("seq", (Object)func.getSeq());
            ret.add(funcInfo.toJSONString());
            funcInfo.clear();
        }
        return ret;
    }

    public List<String> getAppFuncsRuntimeInfoById(String appId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)true);
        return this.getAppFuncsRuntimeInfo(metadata);
    }

    @Deprecated
    public DynamicObject getBizAppByID(String appID) {
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingle((Object)appID, (String)"bos_devportal_bizapp");
        return bizApp;
    }

    @Deprecated
    public String getAppMetadataByID(String appID) {
        AppMetadata appMetadataById = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appID, (boolean)true);
        String appMetadata = AppMetaServiceHelper.serializeToJSONString((AppMetadata)appMetadataById, null);
        return appMetadata;
    }

    public String getAllAppInfo() {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(100000L));
        appParam.setActBookId(Long.valueOf(0L));
        boolean paramFlag = false;
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (paramMap != null && paramMap.get(ISYZJSPECIALVERSION) != null) {
            paramFlag = (Boolean)paramMap.get(ISYZJSPECIALVERSION);
        }
        String paramFlagCache = BizAppServiceImpl.getIsyzjspecialversionCache();
        String portalAppInfo = MetadataDao.getAllPortalAppCache();
        if (StringUtils.isBlank((CharSequence)portalAppInfo) || !String.valueOf(paramFlag).equals(paramFlagCache)) {
            BizAppServiceImpl.putIsyzjspecialversionCache(paramFlag);
            String selectFields = "id, sequence, number, name, image, backimage, industry";
            QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters(null, (String)"id");
            filters = ProductModelFilterUtils.appendCloudIdQFilter(filters, "id");
            Map cloudMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields, (QFilter[])filters, (String)SEQUENCE);
            if (cloudMap == null || cloudMap.size() == 0) {
                return null;
            }
            LinkedHashMap<String, JSONArray> cloudJsonMap = new LinkedHashMap<String, JSONArray>((int)((double)cloudMap.size() / 0.75 + 1.0));
            for (Object cloudObject : cloudMap.values()) {
                String cloudId = cloudObject.getString("id");
                if ("2HGKCE94QELW".equalsIgnoreCase(cloudId)) continue;
                JSONObject cloudJson = new JSONObject();
                String image = cloudObject.getString(IMAGE);
                String bgImage = cloudObject.getString(BACKIMAGE);
                if (image == null || "".equals(image.trim())) {
                    image = IMAGESPATH;
                }
                if (bgImage == null || "".equals(bgImage.trim())) {
                    bgImage = IMAGESPATH;
                }
                cloudJson.put("id", (Object)cloudId);
                cloudJson.put("name", (Object)cloudObject.getLocaleString("name"));
                cloudJson.put("seq", (Object)cloudObject.getInt(SEQUENCE));
                cloudJson.put("pgimage", (Object)image);
                cloudJson.put("bgimage", (Object)bgImage);
                cloudJson.put("iscloud", (Object)Boolean.TRUE);
                DynamicObject industry = cloudObject.getDynamicObject(INDUSTRY);
                if (industry != null) {
                    cloudJson.put(INDUSTRY, (Object)industry.getLocaleString(SIMPLENAME));
                }
                JSONArray cloudArray = new JSONArray();
                cloudArray.add((Object)cloudJson);
                cloudJsonMap.put(cloudId, cloudArray);
            }
            Map<String, AppInfo> apps = this.getAllAppRuntimeInfo();
            if (AppGroupUtils.isGrayGroup()) {
                apps.putAll(this.getAllAppRuntimeInfo(AppGroupUtils.getCurrentAppGroup()));
            }
            for (AppInfo app : apps.values()) {
                String cloudId;
                JSONArray cloudAndAppArray;
                String appNum = app.getAppId();
                if (PORTAL.equals(appNum) || (cloudAndAppArray = (JSONArray)cloudJsonMap.get(cloudId = app.getCloudId())) == null) continue;
                cloudAndAppArray.add((Object)this.getAppJson(app));
            }
            JSONArray allAppsInSystem = new JSONArray();
            for (Map.Entry cloud : cloudJsonMap.entrySet()) {
                JSONArray array = (JSONArray)cloud.getValue();
                allAppsInSystem.add((Object)array);
            }
            portalAppInfo = SerializationUtils.toJsonString((Object)allAppsInSystem);
            MetadataDao.putAllPortalAppCache((String)portalAppInfo);
        }
        return portalAppInfo;
    }

    public String getAppGroupAllAppInfo(String appGroup) {
        Map<String, AppInfo> apps = this.getAllAppRuntimeInfo(appGroup);
        JSONArray cloudAppJson = new JSONArray();
        for (AppInfo app : apps.values()) {
            String appNum = app.getAppId();
            if (PORTAL.equals(appNum)) continue;
            cloudAppJson.add((Object)this.getAppJson(app));
        }
        return SerializationUtils.toJsonString((Object)cloudAppJson);
    }

    private JSONObject getAppJson(AppInfo app) {
        String appNum = app.getAppId();
        String cloudId = app.getCloudId();
        String appImage = app.getImage();
        LocaleString name = app.getName();
        String alluserapp = app.isAllUserApp() ? "1" : "0";
        String usertype = app.getUserType();
        LocaleString description = app.getDescription();
        short seq = app.getSeq();
        String id = app.getId();
        String homeNum = app.getHomeNum();
        String openType = app.getOpenType();
        String mainFormType = app.getMainFormType();
        String homeURL = app.getHomeURL();
        String isv = app.getIsv();
        JSONObject appJson = new JSONObject();
        if (StringUtils.isBlank((CharSequence)appImage)) {
            appImage = "icons/pc/application/gongyingxietong_48_48.png";
        }
        appJson.put("cloudid", (Object)cloudId);
        appJson.put("id", (Object)id);
        appJson.put("number", (Object)appNum);
        appJson.put(IMAGE, (Object)appImage);
        appJson.put("name", (Object)name);
        appJson.put("alluserapp", (Object)alluserapp);
        appJson.put("usertype", (Object)usertype);
        appJson.put(DESCRIPTION, (Object)description);
        appJson.put("seq", (Object)seq);
        appJson.put("opentype", (Object)openType);
        appJson.put("homenum", (Object)homeNum);
        appJson.put("mainformtype", (Object)mainFormType);
        appJson.put("homeURL", (Object)homeURL);
        appJson.put("isv", (Object)isv);
        return appJson;
    }

    private String getAppBlacklistSql() {
        StringBuilder sqlSB = new StringBuilder();
        String appNumberBlackList = RunModeServiceHelper.getAppNumFromBlacklist();
        appNumberBlackList = ProductModelFilterUtils.appendAppNumFilterStr(appNumberBlackList);
        String cloudIdBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        cloudIdBlacklist = ProductModelFilterUtils.appendCloudIdFilterStr(cloudIdBlacklist);
        if (StringUtils.isNotEmpty((CharSequence)appNumberBlackList)) {
            sqlSB.append(" FAPPID NOT IN (").append(appNumberBlackList).append(") ");
        }
        if (StringUtils.isNotEmpty((CharSequence)cloudIdBlacklist)) {
            String andSqlStr = StringUtils.isEmpty((CharSequence)appNumberBlackList) ? " FCLOUDID NOT IN (" : " AND FCLOUDID NOT IN (";
            sqlSB.append(andSqlStr).append(cloudIdBlacklist).append(") ");
        }
        return sqlSB.toString();
    }

    private Map<String, AppInfo> getAllAppRuntimeInfo() {
        return this.getAllAppRuntimeInfo("defaultGroup");
    }

    private Map<String, AppInfo> getAllAppRuntimeInfo(String appGroup) {
        boolean buildEnable = Boolean.getBoolean("appmeta.runtimebuild.enable");
        if (!buildEnable) {
            return AppMetadataCache.getVisibleAndEnableAppInfos();
        }
        String selectFields = "FAPPID,FID,FSEQ,FCLOUDID,FCLOUDNUM,FDBROUTE,FIMAGE,FHOMEID,FHOMENUM,FOPENTYPE,FALLUSERAPP,FUSERTYPE,FORGFUNC,FDATA";
        String sql = String.format("SELECT %s FROM %s ORDER BY FCLOUDID,FSEQ", selectFields, this.getTableName(appGroup, T_META_APPRUNTIME));
        String appBlacklistSql = this.getAppBlacklistSql();
        if (StringUtils.isNotEmpty((CharSequence)appBlacklistSql)) {
            sql = String.format("SELECT %s FROM %s WHERE %s ORDER BY FCLOUDID,FSEQ", selectFields, this.getTableName(appGroup, T_META_APPRUNTIME), appBlacklistSql);
        }
        LinkedHashMap<String, AppInfo> runtimeApps = new LinkedHashMap<String, AppInfo>();
        ResultSetHandler callBackHanlder = rs -> {
            AppInfo app = null;
            try {
                while (rs.next()) {
                    String orgFunc;
                    String userType;
                    boolean allUserApp;
                    String openType;
                    String homeNum;
                    String homeId;
                    String image;
                    String dbRoute;
                    String cloudId;
                    String id;
                    app = new AppInfo();
                    String appId = rs.getString(FAPPID);
                    if (StringUtils.isNotBlank((CharSequence)appId)) {
                        app.setAppId(appId);
                        app.setNumber(appId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(id = rs.getString("FID")))) {
                        app.setId(id);
                    }
                    if ("2HGKTA7HH43C".equalsIgnoreCase(id)) continue;
                    Short seq = rs.getShort("FSEQ");
                    if (StringUtils.isNotBlank((Object)seq)) {
                        app.setSeq(seq);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(cloudId = rs.getString("FCLOUDID")))) {
                        app.setCloudId(cloudId);
                    }
                    if ("2HGKCE94QELW".equalsIgnoreCase(cloudId)) continue;
                    String cloudNum = rs.getString("FCLOUDNUM");
                    if (StringUtils.isNotBlank((CharSequence)cloudNum)) {
                        app.setCloudNum(cloudNum);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(dbRoute = rs.getString("FDBROUTE")))) {
                        app.setDbRoute(dbRoute);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(image = rs.getString("FIMAGE")))) {
                        app.setImage(image);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(homeId = rs.getString("FHOMEID")))) {
                        app.setHomeId(homeId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(homeNum = rs.getString("FHOMENUM")))) {
                        app.setHomeNum(homeNum);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(openType = rs.getString("FOPENTYPE")))) {
                        app.setOpenType(openType);
                    }
                    if (StringUtils.isNotBlank((Object)(allUserApp = rs.getBoolean("FALLUSERAPP")))) {
                        app.setAllUserApp(allUserApp);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(userType = rs.getString("FUSERTYPE")))) {
                        app.setUserType(userType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(orgFunc = rs.getString("FORGFUNC")))) {
                        app.setOrgFunc(orgFunc);
                    }
                    String data = rs.getString("FDATA");
                    app.setData(data);
                    runtimeApps.put(appId, app);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return null;
        };
        DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)callBackHanlder);
        if (runtimeApps.size() > 0) {
            StringBuilder ids = new StringBuilder();
            for (String id : runtimeApps.keySet()) {
                String idVal = "'" + id + "',";
                ids.append(idVal);
            }
            String langSql = String.format("SELECT FAPPID,FLOCALEID,FNAME,FDESCRIPTION FROM %s WHERE FAPPID in (%s)", this.getTableName(appGroup, T_META_APPRUNTIME_L), ids.substring(0, ids.length() - 1));
            ResultSetHandler callBackLangHanlder = rs -> {
                try {
                    while (rs.next()) {
                        String description;
                        String localeId = rs.getString("FLOCALEID");
                        String appId = rs.getString(FAPPID);
                        if (!StringUtils.isNotBlank((CharSequence)localeId) || !StringUtils.isNotBlank((CharSequence)appId)) continue;
                        AppInfo app = (AppInfo)runtimeApps.get(appId);
                        String name = rs.getString(FNAME);
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            LocaleString langName = app.getName();
                            if (langName != null) {
                                langName.setItem(localeId, (Object)name);
                            } else {
                                langName = new LocaleString(localeId, name);
                                app.setName(langName);
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)(description = rs.getString("FDESCRIPTION")))) continue;
                        LocaleString langDesc = app.getDescription();
                        if (langDesc != null) {
                            langDesc.setItem(localeId, (Object)description);
                            continue;
                        }
                        langDesc = new LocaleString(localeId, description);
                        app.setDescription(langDesc);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return null;
            };
            DB.query((DBRoute)DBRoute.meta, (String)langSql, null, (ResultSetHandler)callBackLangHanlder);
        }
        return runtimeApps;
    }

    public DynamicObject getAppFpRelByFormId(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)BIZAPP, (QFilter[])filters);
        return unitRelForm;
    }

    public DynamicObject getBizAppByFormID(String formID) {
        DynamicObject unitRelForm = this.getAppFpRelByFormId(formID);
        if (unitRelForm != null && unitRelForm.get(BIZAPP) != null) {
            String bizAppId = unitRelForm.getString(BIZAPP);
            return this.getBizAppByID(bizAppId);
        }
        return null;
    }

    public List<String> getDesigntimeAllFormIdsByAppId(String appId) {
        DynamicObject appObj = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp", (String)"inheritpath");
        ArrayList<String> appIds = new ArrayList<String>();
        String inheritpath = appObj.getString("inheritpath");
        if (StringUtils.isNotBlank((CharSequence)inheritpath)) {
            String[] pathArray = inheritpath.split(",");
            appIds.addAll(Arrays.asList(pathArray));
        }
        appIds.add(appId);
        QFilter[] filters = new QFilter[]{new QFilter(BIZAPPID, "in", (Object)appIds.toArray(new String[appIds.size()]))};
        String appNum = AppMetadataCache.getAppNumberById((String)appId);
        filters = RunModeServiceHelper.getEntityNumBlacklistFilters((String)appNum, (QFilter[])filters, (String)"number");
        filters = ProductModelFilterUtils.appendFormNumFilters("number", filters, appId);
        Map formMap = BusinessDataServiceHelper.loadFromCache((String)BOS_FORMMETA, (String)"number", (QFilter[])filters);
        ArrayList<String> formIds = new ArrayList<String>(formMap.size());
        for (DynamicObject form : formMap.values()) {
            String formId = form.getString("number");
            formIds.add(formId);
        }
        return formIds;
    }

    public List<Object> getAppsDesigntimeInfo(String cloudId, boolean onlyOriginal, boolean onlyVisible, boolean onlyActive) {
        QFilter f;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)cloudId)) {
            f = new QFilter(BIZCLOUD, "=", (Object)cloudId);
            filterList.add(f);
        }
        if (onlyOriginal) {
            f = new QFilter("type", "!=", (Object)"2");
            filterList.add(f);
        }
        if (onlyActive) {
            QFilter f1 = new QFilter("visible", "=", (Object)"1");
            QFilter f2 = new QFilter(DEPLOYSTATUS, "=", (Object)"2");
            filterList.add(f1);
            filterList.add(f2);
        } else if (onlyVisible) {
            f = new QFilter("visible", "=", (Object)"1");
            filterList.add(f);
        }
        Object[] filters = filterList.toArray(new QFilter[filterList.size()]);
        filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])filters, (String)"id");
        filters = ProductModelFilterUtils.appendAppIdQFilter((QFilter[])filters, "id");
        filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("id", "!=", (Object)"2HGKTA7HH43C"));
        DynamicObject[] bizApps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,bizcloud,deploystatus,isv,type", (QFilter[])filters);
        ArrayList<Object> ret = new ArrayList<Object>(bizApps.length);
        for (DynamicObject bizApp : bizApps) {
            JSONObject appInfo = this.getAppInfo(bizApp.getString("id"), bizApp.getString("number"), bizApp.getLocaleString("name"), bizApp.getInt(SEQUENCE), bizApp.getString(IMAGE), bizApp.getLocaleString(DESCRIPTION), bizApp.getString(DEPLOYSTATUS), bizApp.getString("isv"), bizApp.getString("type"));
            ret.add(appInfo);
        }
        return ret;
    }

    public List<Object> getAppMenusDesigntimeInfoByAppId(String appId, boolean onlyVisible) {
        AppMetadata meta;
        List<Object> ret = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)appId) && (meta = AppReader.loadMeta((String)appId, (boolean)false)) != null) {
            List menus = meta.getAppMenus();
            JSONArray menusInfo = this.getDesigntimeFormatMenus(menus, onlyVisible);
            ret = JSONArray.parseArray((String)menusInfo.toJSONString(), Object.class);
        }
        return ret;
    }

    public List<Object> getAppMenusDesigntimeInfoByAppId(String appId) {
        return this.getAppMenusDesigntimeInfoByAppId(appId, false);
    }

    public Object getAppMultiLangDataByAppId(String appId) {
        AppMetadata meta;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap app = new HashMap();
        HashMap appFuncs = new HashMap();
        HashMap appMenus = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)appId) && (meta = AppReader.loadMeta((String)appId, (boolean)false)) != null) {
            Date modifyDate = meta.getModifyDate();
            ret.put("modifyDate", modifyDate != null ? String.valueOf(modifyDate.getTime()) : "20210428194256235");
            DomainModelType domainModel = DomainModelType.getDomainModelType((String)meta.getModelType(), (boolean)false);
            AppLangItemBuilder builder = new AppLangItemBuilder((DcBinder)new DomainModelBinder(domainModel));
            builder.build(appId);
            builder.buildAppItemsEx();
            Map result = builder.splitReuslts();
            ret.put("app", result.get("app"));
            ret.put("appmenus", result.get(MENUS));
            ret.put("appfuncs", result.get("funcs"));
            return ret;
        }
        ret.put("app", app);
        ret.put("appmenus", appMenus);
        ret.put("appfuncs", appFuncs);
        return ret;
    }

    public List<Object> getCloudsInfo() {
        String selectFields = "id, sequence, number, name, image, backimage,description";
        QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters(null, (String)"id");
        filters = ProductModelFilterUtils.appendCloudIdQFilter(filters, "id");
        DynamicObject[] clouds = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields, (QFilter[])filters, (String)SEQUENCE);
        ArrayList<Object> ret = new ArrayList<Object>(clouds.length);
        for (DynamicObject cloud : clouds) {
            String cloudId = cloud.getString("id");
            if ("2HGKCE94QELW".equalsIgnoreCase(cloudId)) continue;
            JSONObject cloudInfo = this.getCloudInfo(cloud.getString("id"), cloud.getString("number"), cloud.getLocaleString("name"), cloud.getInt(SEQUENCE), cloud.getString(IMAGE), cloud.getLocaleString(DESCRIPTION));
            ret.add(cloudInfo);
        }
        return ret;
    }

    public String getCloudInfoById(String cloudId) {
        String selectFields = "id, sequence, number, name, image, backimage,description";
        DynamicObject cloud = BusinessDataServiceHelper.loadSingleFromCache((Object)cloudId, (String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields);
        JSONObject cloudInfo = this.getCloudInfo(cloud.getString("id"), cloud.getString("number"), cloud.getLocaleString("name"), cloud.getInt(SEQUENCE), cloud.getString(IMAGE), cloud.getLocaleString(DESCRIPTION));
        return cloudInfo.toJSONString();
    }

    public DynamicObjectCollection getAllBizApps() {
        QFilter[] filters = RunModeServiceHelper.getAppIdBlacklistFilters(null, (String)"id");
        filters = ProductModelFilterUtils.appendAppIdQFilter(filters, "id");
        DynamicObjectCollection bizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filters);
        return bizApps;
    }

    public DynamicObjectCollection getAllBizAppsByCloudID(String cloudID) {
        Object[] filters = new QFilter[]{new QFilter(BIZCLOUD, "=", (Object)cloudID)};
        filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])filters, (String)"id");
        filters = ProductModelFilterUtils.appendAppIdQFilter((QFilter[])filters, "id");
        filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)new QFilter("id", "!=", (Object)"2HGKTA7HH43C"));
        DynamicObjectCollection bizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filters);
        return bizApps;
    }

    public DynamicObjectCollection getAllBizAppsByCloudID(List<String> cloudIDs) {
        QFilter[] filters = new QFilter[]{new QFilter(BIZCLOUD, "in", cloudIDs)};
        filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])filters, (String)"id");
        filters = ProductModelFilterUtils.appendAppIdQFilter(filters, "id");
        DynamicObjectCollection bizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filters);
        return bizApps;
    }

    public List<String> getAllBizAppIds() {
        QFilter[] filters = RunModeServiceHelper.getAppIdBlacklistFilters(null, (String)"id");
        filters = ProductModelFilterUtils.appendAppIdQFilter(filters, "id");
        DynamicObjectCollection bizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])filters);
        ArrayList<String> appIds = new ArrayList<String>(bizApps.size());
        for (int i = 0; i < bizApps.size(); ++i) {
            DynamicObject bizApp = (DynamicObject)bizApps.get(i);
            appIds.add(bizApp.getString("id"));
        }
        return appIds;
    }

    public List<String> getAllBizAppIdsByCloudID(String cloudID) {
        QFilter[] filters = new QFilter[]{new QFilter(BIZCLOUD, "=", (Object)cloudID)};
        filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])filters, (String)"id");
        filters = ProductModelFilterUtils.appendAppIdQFilter(filters, "id");
        DynamicObjectCollection bizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])filters);
        ArrayList<String> appIds = new ArrayList<String>(bizApps.size());
        for (int i = 0; i < bizApps.size(); ++i) {
            DynamicObject bizApp = (DynamicObject)bizApps.get(i);
            appIds.add(bizApp.getString("id"));
        }
        return appIds;
    }

    @Deprecated
    public DynamicObjectCollection getAllFormsByAppID(String appID) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appID, (boolean)true);
        List functionElements = metadata.getAppFunctionPackets();
        ArrayList<String> fpIdList = new ArrayList<String>(functionElements.size());
        for (AppFunctionPacketElement fp : functionElements) {
            fpIdList.add(fp.getId());
        }
        QFilter[] filters = new QFilter[]{new QFilter("bizunit", "in", (Object)fpIdList.toArray())};
        DynamicObject[] unitrelforms = BusinessDataServiceHelper.load((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])filters);
        if (unitrelforms == null || unitrelforms.length == 0) {
            return null;
        }
        int count = unitrelforms.length;
        Object[] formIds = new Object[count];
        for (int i = 0; i < count; ++i) {
            formIds[i] = unitrelforms[i].get("form");
        }
        QFilter[] formFilters = ProductModelFilterUtils.appendFormIdFilters("id", new QFilter[]{new QFilter("id", "in", (Object)formIds), new QFilter("type", "=", (Object)"0")}, appID);
        DynamicObjectCollection forms = QueryServiceHelper.query((String)BOS_FORMMETA, (String)"id,number,name,basedatafield,parentid,masterid,bizappid,type,inheritpath,modeltype", (QFilter[])formFilters);
        return forms;
    }

    public String getSVNPathByAppId(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter(BIZAPPID, "=", (Object)appId)};
        DynamicObject svnManage = BusinessDataServiceHelper.loadSingle((String)"svnmanage", (String)"id,svnserver,svnurl", (QFilter[])filters);
        if (svnManage != null) {
            String svnServer = svnManage.getString("svnserver");
            if ("customserver".equals(svnServer)) {
                return svnManage.getString("svnurl");
            }
            if ("nextserver".equals(svnServer)) {
                String svnUrl = AppMetaServiceHelper.getSvnUrl();
                String path = svnManage.getString("svnurl");
                if (StringUtils.isNotBlank((CharSequence)svnUrl) && StringUtils.isNotBlank((CharSequence)path)) {
                    return svnUrl + path;
                }
            }
        }
        return null;
    }

    public String getSVNPathByAppNumber(String appNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)appNumber)};
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"id", (QFilter[])filters);
        String bizAppId = bizApp.getString("id");
        return this.getSVNPathByAppId(bizAppId);
    }

    public String getAppNumberByAppId(String appId) {
        return AppReader.getAppNumberById((String)appId);
    }

    public String getAppIdByFormId(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)BIZAPP, (QFilter[])filters);
        String bizAppId = unitRelForm.getString(BIZAPP);
        return bizAppId;
    }

    public String getAppIdByAppNumber(String appNumber) {
        String bizAppId = AppReader.getAppIdByNumber((String)appNumber);
        return bizAppId;
    }

    public String getAppIdByFormNum(String formNum) {
        QFilter[] qFilter;
        DynamicObject bizApp;
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)formNum)};
        DynamicObject form = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_FORMMETA, (String)"id,bizappid", (QFilter[])filters);
        if (form == null) {
            return null;
        }
        String formId = form.getString("id");
        String bizAppId = form.getString(BIZAPPID);
        if (StringUtils.isBlank((CharSequence)bizAppId) && (bizAppId = (bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_unitrelform", (String)BIZAPP, (QFilter[])(qFilter = new QFilter[]{new QFilter("form", "=", (Object)formId)}))).getString(BIZAPP)) == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)bizAppId)};
        DynamicObject devportalBizapp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"id, type, masterid", (QFilter[])qFilters);
        if (devportalBizapp == null) {
            return bizAppId;
        }
        String strID = devportalBizapp.getString("id");
        String strType = devportalBizapp.getString("type");
        String strMasterId = devportalBizapp.getString("masterid");
        bizAppId = "2".equals(strType) ? strMasterId : strID;
        return bizAppId;
    }

    public List<Map<String, Object>> getCustomerCtlResourcesBySchemaId(String formId) {
        AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (abstractMetadata instanceof FormMetadata) {
            FormMetadata metadata = (FormMetadata)abstractMetadata;
            String KEY_BILL_ID = IDE_CONTROLSCHEMA;
            String KEY_SCHEMA_ID = SCHMAID;
            List items = metadata.getItems();
            if (items != null) {
                HashMap<String, CtlSchemaInfo> schemaIdMap = new HashMap<String, CtlSchemaInfo>();
                items.forEach(ctlap -> {
                    CustomControlAp customControl;
                    CtlSchemaInfo schemaInfo;
                    String type = (String)ctlap.createControl().get("type");
                    if ("customcontrol".equals(type) && (schemaInfo = (customControl = (CustomControlAp)ctlap).getCtlSchemaInfo()) != null) {
                        schemaIdMap.put(ctlap.getKey(), schemaInfo);
                    }
                });
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(schemaIdMap.size());
                schemaIdMap.forEach((ctlId, schemaInfo) -> {
                    DynamicObject pkId = BusinessDataServiceHelper.loadSingle((String)KEY_BILL_ID, (String)"id", (QFilter[])new QFilter[]{new QFilter(KEY_SCHEMA_ID, "=", (Object)schemaInfo.getSchemaId())});
                    if (pkId != null) {
                        List attInfoFromFileServer = ControlSchemaServiceHelper.getAttachments((String)KEY_BILL_ID, (Object)pkId.getString("id"), (String)"attachmentpanelap");
                        HashMap<String, Object> data = new HashMap<String, Object>(3);
                        data.put("ctlId", ctlId);
                        data.put(SCHMAID, schemaInfo.getSchemaId());
                        data.put("isvId", schemaInfo.getIsvId());
                        data.put("schemaName", schemaInfo.getSchemaName());
                        data.put("fileInfo", attInfoFromFileServer);
                        list.add(data);
                    }
                });
                return list;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean deployCustomerCtlSchema(String schemaId, String fileName, InputStream in) {
        String KEY_BILL_ID = IDE_CONTROLSCHEMA;
        String KEY_SCHEMA_ID = SCHMAID;
        if (StringUtils.isBlank((CharSequence)schemaId) || StringUtils.isBlank((CharSequence)fileName) || in == null) {
            return false;
        }
        QFilter filter = new QFilter(KEY_SCHEMA_ID, "=", (Object)schemaId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)KEY_BILL_ID, (String)"id,schemaid", (QFilter[])new QFilter[]{filter});
        if (dy == null) {
            dy = BusinessDataServiceHelper.newDynamicObject((String)KEY_BILL_ID);
            dy.set(KEY_SCHEMA_ID, (Object)schemaId);
            dy.set("schemaname", (Object)schemaId);
            dy.set("version", (Object)1);
            DynamicObject[] results = (DynamicObject[])BusinessDataServiceHelper.save((IDataEntityType)dy.getDataEntityType(), (Object[])new DynamicObject[]{dy});
            if (results != null && results.length > 0) {
                DynamicObject result = results[0];
                String pkId = result.getString("id");
                String appId = MetadataDao.getAppIdByFormId((String)MetadataDao.getIdByNumber((String)KEY_BILL_ID, (MetaCategory)MetaCategory.Form));
                return DeployCustomerCtlHelper.deploy((String)appId, (String)pkId, (String)fileName, (InputStream)in);
            }
        }
        return true;
    }

    public List<Map<String, Object>> getCustomerCtlResourcesByAppId(String appId) {
        QFilter[] formFilters = new QFilter[]{new QFilter(BIZAPP, "=", (Object)appId)};
        DynamicObject[] unitreForms = BusinessDataServiceHelper.load((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])formFilters);
        ArrayList<String> lstFormIds = new ArrayList<String>(unitreForms.length);
        for (DynamicObject obj : unitreForms) {
            String formId = obj.getString("form");
            lstFormIds.add(formId);
        }
        ArrayList<Map<String, Object>> lstRet = new ArrayList<Map<String, Object>>();
        String KEY_BILL_ID = IDE_CONTROLSCHEMA;
        String KEY_SCHEMA_ID = SCHMAID;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", lstFormIds)};
        DynamicObject[] enableResult = BusinessDataServiceHelper.load((String)BOS_FORMMETA, (String)"id", (QFilter[])filters);
        if (enableResult != null) {
            for (DynamicObject dynamicObject : enableResult) {
                FormMetadata metadata;
                List items;
                String formid = dynamicObject.getString("id");
                AbstractMetadata abstractMetadata = MetadataDao.readMeta((String)formid, (MetaCategory)MetaCategory.Form);
                if (!(abstractMetadata instanceof FormMetadata) || (items = (metadata = (FormMetadata)abstractMetadata).getItems()) == null) continue;
                HashMap<String, CtlSchemaInfo> schemaIdMap = new HashMap<String, CtlSchemaInfo>();
                items.forEach(ctlap -> {
                    CustomControlAp customControl;
                    CtlSchemaInfo schemaInfo;
                    String type = (String)ctlap.createControl().get("type");
                    if ("customcontrol".equals(type) && (schemaInfo = (customControl = (CustomControlAp)ctlap).getCtlSchemaInfo()) != null) {
                        schemaIdMap.put(ctlap.getKey(), schemaInfo);
                    }
                });
                ArrayList list = new ArrayList(schemaIdMap.size());
                schemaIdMap.forEach((ctlId, schemaInfo) -> {
                    DynamicObject pkId = BusinessDataServiceHelper.loadSingle((String)KEY_BILL_ID, (String)"id", (QFilter[])new QFilter[]{new QFilter(KEY_SCHEMA_ID, "=", (Object)schemaInfo.getSchemaId())});
                    if (pkId != null) {
                        List attInfoFromFileServer = ControlSchemaServiceHelper.getAttachments((String)KEY_BILL_ID, (Object)pkId.getString("id"), (String)"attachmentpanelap");
                        HashMap<String, Object> data = new HashMap<String, Object>(3);
                        data.put("ctlId", ctlId);
                        data.put(SCHMAID, schemaInfo.getSchemaId());
                        data.put("isvId", schemaInfo.getIsvId());
                        data.put("moduleId", schemaInfo.getModuleId());
                        data.put("schemaName", schemaInfo.getSchemaName());
                        data.put("fileInfo", attInfoFromFileServer);
                        list.add(data);
                    }
                });
                lstRet.addAll(list);
            }
        }
        return lstRet;
    }

    public static String getIsyzjspecialversionCache() {
        DistributeSessionlessCache cache = BizAppServiceImpl.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = "Runtime-AppMetadata-" + accountId + "-portalapp";
        return (String)cache.get("AppMetadata-" + accountId, key + ISYZJSPECIALVERSION);
    }

    public static void putIsyzjspecialversionCache(Boolean paramFlag) {
        DistributeSessionlessCache cache = BizAppServiceImpl.getCache();
        String accountId = CacheKeyUtil.getAcctId();
        String key = "Runtime-AppMetadata-" + accountId + "-portalapp";
        cache.put("AppMetadata-" + accountId, key + ISYZJSPECIALVERSION, (Object)String.valueOf(paramFlag));
    }

    public boolean isAllUserApp(String appID) {
        try {
            if (StringUtils.isBlank((CharSequence)appID)) {
                return false;
            }
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appID);
            return appInfo == null ? false : appInfo.isAllUserApp();
        }
        catch (KDException e) {
            if ("bos.appMetaDataNotExist".equals(e.getErrorCode().getCode())) {
                return false;
            }
            throw e;
        }
    }

    private static Map<String, String> getEntityNumsByFormNums(List<String> formNums) {
        HashMap<String, String> results = new HashMap(16);
        StringBuilder sb = new StringBuilder().append(" select t1.fnumber formnum, t2.fnumber entnum from t_meta_formdesign t1 ").append(" inner join  t_meta_formdesign t2 on (t1.fentityid = t2.fid) ");
        if (!CollectionUtils.isEmpty(formNums)) {
            int size = formNums.size();
            sb.append(" where t1.fnumber in (");
            for (int i = 0; i < size; ++i) {
                sb.append('\'').append(formNums.get(i)).append('\'');
                if (i == size - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        results = (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(100);
                while (rs.next()) {
                    map.put(rs.getString("formnum"), rs.getString("entnum"));
                }
                return map;
            }
        });
        return results;
    }

    private String getMasterId(String appID) {
        String sql = String.format("select FType, FMasterId from %s where FId = ? ", "T_META_BIZAPP");
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)appID)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String devType = rs.getString(1);
                    if (StringUtils.equals((CharSequence)devType, (CharSequence)"2")) {
                        return rs.getString(2);
                    }
                    return null;
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private String getTableName(String appGroup, String tableName) {
        if (StringUtils.isBlank((CharSequence)appGroup) || "defaultGroup".equals(appGroup)) {
            return tableName;
        }
        return String.format("%s_%s", tableName, appGroup);
    }
}

