/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.devportal.api.BizCloudService;
import kd.bos.devportal.service.ProductModelFilterUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.SAXReaderUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class BizCloudServiceImpl
implements BizCloudService {
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String BIZCLOUD = "bizcloud";
    private static final String BIZAPP = "bizapp";
    private static final String CLOUDID = "cloudid";
    private static final String DESCRIPTION = "description";
    private static final String DDE = "Deserialize.DocumentException";

    public DynamicObject getBizCloudByID(String cloudID) {
        DynamicObject bizCloud = BusinessDataServiceHelper.loadSingle((Object)cloudID, (String)BOS_DEVPORTAL_BIZCLOUD);
        return bizCloud;
    }

    public DynamicObject getBizCloudByAppID(String appID) {
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingle((Object)appID, (String)"bos_devportal_bizapp", (String)BIZCLOUD);
        if (bizApp != null && bizApp.get(BIZCLOUD) != null) {
            String bizCloudId = bizApp.getDynamicObject(BIZCLOUD).getString("id");
            return this.getBizCloudByID(bizCloudId);
        }
        return null;
    }

    public DynamicObject getBizCloudByFormID(String formID) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formID)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)BIZAPP, (QFilter[])filters);
        if (unitRelForm != null && unitRelForm.get(BIZAPP) != null) {
            String bizAppId = unitRelForm.getString(BIZAPP);
            return this.getBizCloudByAppID(bizAppId);
        }
        return null;
    }

    public DynamicObjectCollection getAllBizClouds() {
        String selectFields = "id, sequence, number, name, image, backimage, ismodel";
        QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters(null, (String)"id");
        filters = ProductModelFilterUtils.appendCloudIdQFilter(filters, "id");
        DynamicObjectCollection bizClouds = QueryServiceHelper.query((String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields, (QFilter[])filters, (String)"sequence asc");
        return bizClouds;
    }

    public List<Map<String, Object>> getCloudMultiLangData() {
        String selectFields = "id, number,version, name, sequence,baseapp,industry,description, image, backimage";
        DynamicObject[] dynamicObjectArr = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZCLOUD, (String)selectFields, null);
        ArrayList<Map<String, Object>> cloudMultiList = new ArrayList<Map<String, Object>>(dynamicObjectArr.length);
        for (DynamicObject dynObject : dynamicObjectArr) {
            HashMap<String, Object> cloudMulti = new HashMap<String, Object>();
            String cloudId = dynObject.getString("id");
            String baseAppId = dynObject.getString("baseapp_id");
            cloudMulti.put(CLOUDID, cloudId);
            cloudMulti.put("baseappid", baseAppId);
            IDataEntityType cloudDataEntitytype = dynObject.getDataEntityType();
            IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)cloudDataEntitytype);
            Object cloudObj = dataManager.read((Object)cloudId);
            for (IDataEntityProperty p : cloudDataEntitytype.getProperties()) {
                Object cloudVal = p.getValue(cloudObj);
                if (!(p instanceof ISimpleProperty) || !(cloudVal instanceof ILocaleValue) || ((ILocaleValue)cloudVal).size() <= 0) continue;
                String propertyId = p.getName();
                cloudMulti.put(propertyId, cloudVal);
            }
            cloudMultiList.add(cloudMulti);
        }
        return cloudMultiList;
    }

    public void updateCloudMultiLangData(Map<String, Object> cloudMultiMeta) {
        List cloudList = (List)cloudMultiMeta.get("data");
        for (Map cloudMap : cloudList) {
            String cloudId = (String)cloudMap.get(CLOUDID);
            String cloudLang = (String)cloudMap.get("lang");
            String cloudName = (String)cloudMap.get("name");
            String cloudDescription = (String)cloudMap.get(DESCRIPTION);
            DynamicObject cloudObject = BusinessDataServiceHelper.loadSingle((Object)cloudId, (String)BOS_DEVPORTAL_BIZCLOUD);
            OrmLocaleValue localNameValue = (OrmLocaleValue)cloudObject.get("name");
            OrmLocaleValue localDescriptionValue = (OrmLocaleValue)cloudObject.get(DESCRIPTION);
            localNameValue.setItem(cloudLang, cloudName);
            localDescriptionValue.setItem(cloudLang, cloudDescription);
            cloudObject.set("name", (Object)localNameValue);
            cloudObject.set(DESCRIPTION, (Object)localDescriptionValue);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cloudObject});
            MetadataDao.cleanAllPortalAppCache();
        }
    }

    public List<Map<String, Object>> getCloudMetaInfo(Map<String, Object> cloudMultiMeta) {
        List cloudList = (List)cloudMultiMeta.get("data");
        ArrayList<Map<String, Object>> updateCloudList = new ArrayList<Map<String, Object>>(cloudList.size());
        for (Map cloudMap : cloudList) {
            HashMap<String, String> cloudMapInfo = new HashMap<String, String>();
            String cloudId = (String)cloudMap.get(CLOUDID);
            String cloudLang = (String)cloudMap.get("lang");
            String cloudFormat = cloudLang + ".cldx";
            boolean cloudMetaLangExist = false;
            String cloudName = (String)cloudMap.get("name");
            String cloudDescription = (String)cloudMap.get(DESCRIPTION);
            List deploy = MetadataDao.getCloudDeployFile((String)cloudId);
            String zh_CNContent = "";
            for (DeployFile deployFile : deploy) {
                Document document;
                String deployContent;
                String deployName = deployFile.getFileName();
                if (deployName.endsWith(".cld")) {
                    deployContent = deployFile.getFileContent();
                    try {
                        document = SAXReaderUtil.parseText((String)deployContent);
                        String baseappId = document.selectSingleNode("/DeployMetadata/DesignMetas/DesignCloudMeta/BaseAppId").getText();
                        cloudMapInfo.put("baseappid", baseappId);
                    }
                    catch (DocumentException ex) {
                        throw new OrmException(DDE, ex.getMessage());
                    }
                }
                if (deployName.endsWith(cloudFormat)) {
                    cloudMetaLangExist = true;
                    deployContent = deployFile.getFileContent();
                    try {
                        document = SAXReaderUtil.parseText((String)deployContent);
                        document.selectSingleNode("/DeployMetadata/DesignMetas/DesignCloudMetaL/Name").setText(cloudName);
                        document.selectSingleNode("/DeployMetadata/DesignMetas/DesignCloudMetaL/Description").setText(cloudDescription);
                        String newContent = document.asXML();
                        cloudMapInfo.put(CLOUDID, cloudId);
                        cloudMapInfo.put("lang", cloudLang);
                        cloudMapInfo.put("cloudname", deployName);
                        cloudMapInfo.put("cloudcontent", newContent);
                    }
                    catch (DocumentException ex) {
                        throw new OrmException(DDE, ex.getMessage());
                    }
                }
                if (!deployName.endsWith("zh_CN.cldx")) continue;
                zh_CNContent = deployFile.getFileContent();
            }
            if (!cloudMetaLangExist) {
                String uuid = UUID.randomUUID().toString().replace("-", "");
                String pkid = uuid.substring(0, 16);
                try {
                    Document document = SAXReaderUtil.parseText((String)zh_CNContent);
                    document.selectSingleNode("/DeployMetadata/DesignMetas/DesignCloudMetaL/PkId").setText(pkid);
                    document.selectSingleNode("/DeployMetadata/DesignMetas/DesignCloudMetaL/Name").setText(cloudName);
                    document.selectSingleNode("/DeployMetadata/DesignMetas/DesignCloudMetaL/Description").setText(cloudDescription);
                    document.selectSingleNode("/DeployMetadata/DesignMetas/DesignCloudMetaL/LocaleId").setText(cloudLang);
                    String newContent = document.asXML();
                    cloudMapInfo.put(CLOUDID, cloudId);
                    cloudMapInfo.put("lang", cloudLang);
                    DynamicObject cloudObject = BusinessDataServiceHelper.loadSingleFromCache((Object)cloudId, (String)BOS_DEVPORTAL_BIZCLOUD);
                    cloudMapInfo.put("cloudname", cloudObject.getString("number").toLowerCase() + "." + cloudFormat);
                    cloudMapInfo.put("cloudcontent", newContent);
                }
                catch (DocumentException ex) {
                    throw new OrmException(DDE, ex.getMessage());
                }
            }
            updateCloudList.add(cloudMapInfo);
        }
        return updateCloudList;
    }
}

