/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.service;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.devportal.api.IDevService;
import kd.bos.devportal.business.LockVerify;
import kd.bos.devportal.business.PermissionVerify;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.devportal.common.DevportalCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DevServiceImpl
implements IDevService {
    private static Log log = LogFactory.getLog(DevServiceImpl.class);
    private static final String BOS_APP_ISOLATION = "bos_app_isolation";
    private static final String ISOLATION = "isolationapp";
    private static final String BOS_APP_LOCKING = "bos_app_locking";
    private static final String FORMNUMBER = "formnumber";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String ENV_REGION_KEY = "envRegion";
    private static final String OEM = "OEM";

    public Set<String> getPermissionAppByUser(Long userId) {
        Set userPermissionApps;
        Set permissionApps;
        String mode = (String)DevportalVerify.getParameter((String)"dev_governance_mode");
        if (mode == null) {
            return new HashSet<String>(16);
        }
        String allApps = DevportalCache.getPermission((Long)userId, (String)mode);
        String userApps = DevportalCache.getPermissionUser((Long)userId);
        if (allApps != null) {
            permissionApps = (Set)SerializationUtils.fromJsonString((String)allApps, Set.class);
        } else {
            permissionApps = this.getPermissionApps(userId);
            allApps = SerializationUtils.toJsonString((Object)permissionApps);
            DevportalCache.putPermission((String)allApps, (Long)userId, (String)mode);
        }
        if (userApps != null) {
            userPermissionApps = (Set)SerializationUtils.fromJsonString((String)userApps, Set.class);
        } else {
            userPermissionApps = this.getUserApps(userId);
            userApps = SerializationUtils.toJsonString((Object)userPermissionApps);
            DevportalCache.putPermissionByUser((String)userApps, (Long)userId);
        }
        log.debug("permissionApps: " + permissionApps + " userPermissionApps: " + userPermissionApps);
        permissionApps.addAll(userPermissionApps);
        return permissionApps;
    }

    public Set<String> getPermissionApps(Long userId) {
        QFilter[] qFilters;
        DynamicObject[] apps;
        HashSet<String> permissionApps = new HashSet<String>(16);
        QFilter q1 = new QFilter("account", "=", (Object)userId);
        if (!DevportalVerify.isApart()) {
            QFilter q2 = new QFilter("admin", "=", (Object)true);
            q1.and(q2);
        }
        if ((apps = BusinessDataServiceHelper.load((String)BOS_APP_ISOLATION, (String)ISOLATION, (QFilter[])(qFilters = new QFilter[]{q1}))).length > 0) {
            for (DynamicObject object : apps) {
                DynamicObjectCollection isolations = (DynamicObjectCollection)object.get(ISOLATION);
                for (DynamicObject isolation : isolations) {
                    DynamicObject app = (DynamicObject)isolation.get("fbasedataid");
                    if (app == null) continue;
                    String bizAppId = (String)app.get("id");
                    permissionApps.add(bizAppId);
                }
            }
        }
        log.debug("method: getPermissionApps()  permissionApps: " + permissionApps);
        return permissionApps;
    }

    public Set<String> getUserApps(Long userId) {
        HashSet<String> userApps = new HashSet<String>(16);
        String field = "id";
        QFilter filter = new QFilter("creater", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{filter};
        Map apps = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)field, (QFilter[])filters);
        for (Map.Entry entry : apps.entrySet()) {
            DynamicObject app = (DynamicObject)entry.getValue();
            if (app == null) continue;
            String id = (String)app.get("id");
            userApps.add(id);
        }
        log.debug("method: getUserApps() userApps: " + userApps);
        return userApps;
    }

    public boolean isLockFormByNumber(String formNumber) {
        return this.getLockInfo(formNumber) != null;
    }

    public Set<String> getAllLockForm() {
        HashSet<String> lockForms = new HashSet<String>(16);
        String lockForm = DevportalCache.getLock((boolean)true);
        if (lockForm != null) {
            return (Set)SerializationUtils.fromJsonString((String)lockForm, Set.class);
        }
        Map lockCache = BusinessDataServiceHelper.loadFromCache((String)BOS_APP_LOCKING, (String)FORMNUMBER, null);
        for (Map.Entry lockInfo : lockCache.entrySet()) {
            DynamicObject value = (DynamicObject)lockInfo.getValue();
            String formNumber = value.getString(FORMNUMBER);
            lockForms.add(formNumber);
        }
        if (!lockForms.isEmpty()) {
            DevportalCache.putLock((String)SerializationUtils.toJsonString(lockForms));
        }
        log.debug("method: getAllLockForm() lockForms: " + lockForms);
        return lockForms;
    }

    public String getLockInfo(String formNumber) {
        String userName = DevportalCache.getLock((String)formNumber, (boolean)false);
        if (userName != null) {
            return userName;
        }
        String field = "account, accounttype";
        QFilter qFilter = new QFilter(FORMNUMBER, "=", (Object)formNumber);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_APP_LOCKING, (String)field, (QFilter[])qFilters);
        if (appInfo == null) {
            return null;
        }
        userName = appInfo.getString("account");
        DevportalCache.putLock((String)formNumber, (String)userName);
        log.info("method: getLockInfo() userName: " + userName);
        return userName;
    }

    public void deleteLock(String formNumber) {
        LockVerify verify = new LockVerify();
        verify.deleteLock(formNumber);
    }

    public boolean verifyPermission(String item, String bizAppId) {
        Long userId = RequestContext.get().getCurrUserId();
        Set<String> userApp = this.getPermissionAppByUser(userId);
        PermissionVerify permissionVerify = new PermissionVerify(userApp, item, bizAppId);
        return permissionVerify.verify();
    }

    public Map<String, Object> verifyLock(String item, String bizNumber) {
        boolean isLock = this.isLockFormByNumber(bizNumber);
        String userName = this.getLockInfo(bizNumber);
        LockVerify lockVerify = new LockVerify(userName, isLock);
        return lockVerify.verify(item);
    }

    public boolean isOEMEnv() {
        try {
            String envRegion = DevportalCache.getEnvRegion();
            if (envRegion != null) {
                return StringUtils.equals((CharSequence)envRegion, (CharSequence)OEM);
            }
            String sql = "SELECT FPARAM_VALUE FROM T_BAS_DEFAULT_PARAMS WHERE FPARAM_KEY = ?";
            Object[] parameters = new SqlParameter[1];
            String encodeString = Base64.getEncoder().encodeToString(ENV_REGION_KEY.getBytes(StandardCharsets.UTF_8));
            StringBuilder keyBuilder = new StringBuilder(encodeString);
            String reverse = keyBuilder.reverse().toString();
            parameters[0] = new SqlParameter(":FPARAM_KEY", 12, (Object)reverse);
            String encodeValue = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])parameters, rs -> {
                if (rs.next()) {
                    return rs.getString("FPARAM_VALUE");
                }
                return null;
            });
            boolean isOEMEnv = false;
            envRegion = "standard";
            if (StringUtils.isNotBlank((CharSequence)encodeValue)) {
                StringBuilder valueBuilder = new StringBuilder(encodeValue);
                String reverseValue = valueBuilder.reverse().toString();
                envRegion = new String(Base64.getDecoder().decode(reverseValue));
                isOEMEnv = StringUtils.equals((CharSequence)envRegion, (CharSequence)OEM);
            }
            DevportalCache.cacheEnvRegion((String)envRegion);
            return isOEMEnv;
        }
        catch (Exception e) {
            log.error("DevService isOEM error", (Throwable)e);
            return false;
        }
    }
}

