/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.service.CollectData;
import kd.bos.devportal.service.DeMeta;
import kd.bos.devportal.service.DevportalModelTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.portal.datalog.service.IDataCollectService;

public class DevportalDataCollectServiceImpl
implements IDataCollectService {
    private static Log logger = LogFactory.getLog(DevportalDataCollectServiceImpl.class);
    private static final String KINGDEE = "kingdee";
    protected static final String ENTITYOBJECT = "entityObject";
    protected static final String DYNAMICFORM = "dynamicForm";
    protected static final String REPORT = "report";
    private static final String SCENSE = "devportal_datacollect";
    private static final String DEPARTMENT = "kddm";
    private static final String SPAN_TYPE_NAME = "DevportalDataCollectServiceImpl";
    private static List<String> excludeIsv = new ArrayList<String>(3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> collectData() {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"DevportalDataCollectServiceImpl.collectData");){
            List<CollectData> metaCollectData;
            HashMap<String, Object> cusData = new HashMap<String, Object>(16);
            span.addTag("env.type", EnvTypeHelper.getCurrentEnvType().getValue());
            if (!EnvTypeHelper.isProductEnv()) {
                HashMap<String, Object> hashMap = cusData;
                return hashMap;
            }
            span.addTag("scence", SCENSE);
            ArrayList<CollectData> collectDataList = new ArrayList<CollectData>(10);
            List<CollectData> appCollectData = this.getAppCollectData();
            if (appCollectData != null) {
                collectDataList.addAll(appCollectData);
            }
            if ((metaCollectData = this.getMetaCollectData()) != null) {
                collectDataList.addAll(metaCollectData);
            }
            cusData.put("department", DEPARTMENT);
            cusData.put("table_name", "t_meta_formdesign");
            cusData.put("form_id", "bos_formmeta");
            cusData.put("business_scene", SCENSE);
            this.buildData(cusData, collectDataList);
            span.addTag("data", SerializationUtils.toJsonString(cusData));
            HashMap<String, Object> hashMap = cusData;
            return hashMap;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    public List<Map<String, Object>> collectBatchData() {
        return null;
    }

    private void buildData(Map<String, Object> cusData, List<CollectData> dataList) {
        if (dataList != null && !dataList.isEmpty()) {
            for (CollectData data : dataList) {
                cusData.put(data.getKey(), data.getCount());
            }
        }
    }

    private List<CollectData> getAppCollectData() {
        ArrayList<CollectData> collectDataList = new ArrayList<CollectData>(10);
        collectDataList.add(new CollectData("t_meta_bizapp", "bos_devportal_bizapp", "devportal_app_new", "numExt10", this.getAppCount('0')));
        collectDataList.add(new CollectData("t_meta_bizapp", "bos_devportal_bizapp", "devportal_app_ext", "numExt14", this.getAppCount('2')));
        return collectDataList;
    }

    private List<CollectData> getMetaCollectData() {
        ArrayList<CollectData> collectDataList = new ArrayList<CollectData>(10);
        List<DeMeta> deMetaList = this.getDeMeta();
        int entityNew = 0;
        int entityExt = 0;
        int dynamicFormNew = 0;
        int dynamicFormExt = 0;
        int reportNew = 0;
        int reportExt = 0;
        if (deMetaList != null && !deMetaList.isEmpty()) {
            List<String> entityList = DevportalModelTypes.getModelType(ENTITYOBJECT);
            List<String> dynamicFormList = DevportalModelTypes.getModelType(DYNAMICFORM);
            List<String> reportList = DevportalModelTypes.getModelType(REPORT);
            for (DeMeta meta : deMetaList) {
                String type = meta.getType();
                String modelType = meta.getModelType();
                int count = meta.getCount();
                if ("2".equals(type)) {
                    if (entityList.contains(modelType)) {
                        entityExt += count;
                    }
                    if (dynamicFormList.contains(modelType)) {
                        dynamicFormExt += count;
                    }
                    if (!reportList.contains(modelType)) continue;
                    reportExt += count;
                    continue;
                }
                if (entityList.contains(modelType)) {
                    entityNew += count;
                }
                if (dynamicFormList.contains(modelType)) {
                    dynamicFormNew += count;
                }
                if (!reportList.contains(modelType)) continue;
                reportNew += count;
            }
        }
        collectDataList.add(new CollectData("t_meta_entitydesign", "bos_entitymeta", "devportal_entityobject_new", "numExt11", entityNew));
        collectDataList.add(new CollectData("t_meta_formdesign", "bos_formmeta", "devportal_dynamicform_new", "numExt12", dynamicFormNew));
        collectDataList.add(new CollectData("t_meta_formdesign", "bos_formmeta", "devportal_report_new", "numExt13", reportNew));
        collectDataList.add(new CollectData("t_meta_entitydesign", "bos_entitymeta", "devportal_entityobject_ext", "numExt15", entityExt));
        collectDataList.add(new CollectData("t_meta_formdesign", "bos_formmeta", "devportal_dynamicform_ext", "numExt16", dynamicFormExt));
        collectDataList.add(new CollectData("t_meta_formdesign", "bos_formmeta", "devportal_report_ext", "numExt17", reportExt));
        return collectDataList;
    }

    protected List<DeMeta> getDeMeta() {
        StringBuilder sql = new StringBuilder();
        sql.append("select ftype, fmodeltype, count(fmodeltype) from t_meta_formdesign where fisv not in (");
        int i = 0;
        for (String s : excludeIsv) {
            if (i == 0) {
                sql.append("?");
            } else {
                sql.append(",?");
            }
            ++i;
        }
        sql.append(") group by fmodeltype ,ftype");
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])excludeIsv.toArray(), (ResultSetHandler)new ResultSetHandler<List<DeMeta>>(){

            public List<DeMeta> handle(ResultSet rs) throws Exception {
                ArrayList<DeMeta> deMetaList = new ArrayList<DeMeta>(10);
                while (rs.next()) {
                    String type = rs.getString(1);
                    String modelType = rs.getString(2);
                    int count = rs.getInt(3);
                    deMetaList.add(new DeMeta("", type, modelType, count));
                }
                return deMetaList;
            }
        });
    }

    protected int getAppCount(char type) {
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("select count(1) from t_meta_bizapp where ftype = '%s' and fisv not in (", Character.valueOf(type)));
        int i = 0;
        for (String s : excludeIsv) {
            if (i == 0) {
                sql.append("?");
            } else {
                sql.append(",?");
            }
            ++i;
        }
        sql.append(")");
        return (Integer)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])excludeIsv.toArray(), (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
        });
    }

    static {
        excludeIsv.add(KINGDEE);
        excludeIsv.add("kdxk");
        excludeIsv.add(" ");
    }
}

