/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;

class ProductModelFilterUtils {
    ProductModelFilterUtils() {
    }

    protected static QFilter[] appendFormIdFilters(String fileName, QFilter[] filters, String appId) {
        List proBlackFormIds = ProductModelFilterUtils.getProductSettingService().getFormIdBlackListByAppId(appId);
        if (!proBlackFormIds.isEmpty()) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
            filterList.add(new QFilter(fileName, "not in", (Object)proBlackFormIds.toArray()));
            return filterList.toArray(new QFilter[filterList.size()]);
        }
        return filters;
    }

    protected static QFilter[] appendFormNumFilters(String fileName, QFilter[] filters, String appId) {
        List problackform = ProductModelFilterUtils.getProductSettingService().getFormBlackListByAppId(appId);
        if (!problackform.isEmpty()) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(Arrays.asList(filters));
            qFilterList.add(new QFilter(fileName, "not in", (Object)problackform.toArray()));
            return qFilterList.toArray(new QFilter[qFilterList.size()]);
        }
        return filters;
    }

    private static ProductSettingService getProductSettingService() {
        ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        return productService;
    }

    protected static QFilter[] appendAppIdQFilter(QFilter[] appIdFilter, String fieldName) {
        ProductSettingService productService = ProductModelFilterUtils.getProductSettingService();
        List appids = productService.getAppIdBlackList();
        if (!appids.isEmpty()) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            if (appIdFilter != null) {
                list.addAll(Arrays.asList(appIdFilter));
            }
            list.add(new QFilter(fieldName, "not in", (Object)appids.toArray()));
            return list.toArray(new QFilter[list.size()]);
        }
        return appIdFilter;
    }

    protected static QFilter[] appendCloudIdQFilter(QFilter[] oldCloudIdFilter, String fieldName) {
        ProductSettingService productService = ProductModelFilterUtils.getProductSettingService();
        List cloudIds = productService.getCloudIdBlackList();
        if (!cloudIds.isEmpty()) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter(fieldName, "not in", (Object)cloudIds.toArray()));
            if (oldCloudIdFilter != null) {
                list.addAll(Arrays.asList(oldCloudIdFilter));
            }
            return list.toArray(new QFilter[list.size()]);
        }
        return oldCloudIdFilter;
    }

    protected static String appendCloudIdFilterStr(String cloudIdlist) {
        List cloudIds = ProductModelFilterUtils.getProductSettingService().getCloudIdBlackList();
        if (!cloudIds.isEmpty()) {
            cloudIdlist = StringUtils.isNotEmpty((CharSequence)cloudIdlist) ? cloudIdlist + "," + ProductModelFilterUtils.changeSetToSqlStr(cloudIds) : ProductModelFilterUtils.changeSetToSqlStr(cloudIds);
        }
        return cloudIdlist;
    }

    protected static String appendAppNumFilterStr(String appBlacklist) {
        ProductSettingService productService = ProductModelFilterUtils.getProductSettingService();
        List appNums = productService.getAppNumBlackList();
        if (!appNums.isEmpty()) {
            appBlacklist = StringUtils.isNotEmpty((CharSequence)appBlacklist) ? appBlacklist + "," + ProductModelFilterUtils.changeSetToSqlStr(appNums) : ProductModelFilterUtils.changeSetToSqlStr(appNums);
        }
        return appBlacklist;
    }

    private static String changeSetToSqlStr(List<String> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : set) {
            if (item == null) continue;
            String val = null;
            if (item instanceof String) {
                val = item.toString();
            } else if (item instanceof Map.Entry) {
                Object tVal = ((Map.Entry)((Object)item)).getValue();
                String string = val = tVal == null ? null : tVal.toString();
            }
            if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
            sb.append('\'').append(val).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }
}

