/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.operate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.ai.cvp.entity.ResultData;
import kd.bos.ext.ai.cvp.entity.distinguish.AlgoData;
import kd.bos.ext.ai.cvp.operate.CommonOperate;
import kd.bos.ext.ai.cvp.utils.AiLicenseUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OcrEntityOperate
extends FormOperate
implements ICloseCallBack {
    private static Log logger = LogFactory.getLog(OcrEntityOperate.class);
    private static final String FORM_ID = "cvp_distinguish";
    private static final String BUSINESSO_BJECT = "businessobject";
    private static final String PAGE_ID = "pageId";
    private static final String ACTION_ID = "ocrDistinguish";

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (!AiLicenseUtils.validLicenseNew(this.getView())) {
            return false;
        }
        if (!this.validPlan(this.getView())) {
            return false;
        }
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId(FORM_ID);
        formShow.setCustomParam(BUSINESSO_BJECT, (Object)this.getEntityId());
        formShow.setCustomParam(PAGE_ID, (Object)this.getView().getPageId());
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_ID));
        this.getView().showForm(formShow);
        return false;
    }

    private boolean validPlan(IFormView view) {
        DynamicObject plan = this.getObjByPlanBusinessObject(this.getEntityId());
        if (plan == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u914d\u7f6e\u8bc6\u522b\u5173\u8054\u8bbe\u7f6e,\u8bf7\u5148\u914d\u7f6e\u3002", (String)"OcrUploadPlugin_0", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject getObjByPlanBusinessObject(String entityId) {
        QFilter filter = new QFilter(BUSINESSO_BJECT, "=", (Object)entityId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,description,templateconfig,createdate,modifydate,templatenumber";
        return QueryServiceHelper.queryOne((String)"cvp_plan", (String)selectFields, (QFilter[])filters);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        IFormView view = evt.getView();
        try {
            Object returnData;
            if (ACTION_ID.equals(actionId) && (returnData = evt.getReturnData()) != null) {
                logger.info("\u8fdb\u5165\u56de\u586b\u4f4d\u7f6e\uff0c\u5f00\u59cb\u51c6\u5907\u56de\u586b\u3002");
                BillModel model = (BillModel)view.getModel();
                this.createBillObj(model, returnData);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u8bc6\u522b\u6210\u529f,\u5e76\u5bfc\u5165\u6570\u636e", (String)"OcrEntityOperate_0", (String)"bos-ext-ai", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            view.showTipNotification("OCR Exception ");
            logger.error("OCR,\u667a\u80fd\u8bc6\u522b\u5f02\u5e38,\u64cd\u4f5c\u5f02\u5e38: ", (Throwable)e);
        }
    }

    private DynamicObject createBillObj(BillModel model, Object returnData) throws IOException {
        logger.info("\u5f00\u59cb\u56de\u586b\u5355\u636e\u3002");
        DynamicObject billObj = model.getDataEntity(true);
        ResultData info = (ResultData)SerializationUtils.fromJsonString((String)String.valueOf(returnData), ResultData.class);
        AlgoData data = info.getData();
        Map<String, String> textOcr = data.getTextOcr();
        DataEntityPropertyCollection entryType = billObj.getDataEntityType().getProperties();
        Set<Map.Entry<String, String>> map = textOcr.entrySet();
        ArrayList<String> existEntry = new ArrayList<String>();
        HashMap<String, Object> insertMap = new HashMap<String, Object>();
        CommonOperate.ordinaryTextInsert(entryType, billObj, model, map, existEntry, insertMap);
        CommonOperate.tableInsert((IDataModel)model, entryType, data.getTablesOcr(), existEntry, insertMap);
        return billObj;
    }
}

