/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.operate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.ai.cvp.entity.ResultData;
import kd.bos.ext.ai.cvp.entity.distinguish.AlgoData;
import kd.bos.ext.ai.cvp.operate.CommonOperate;
import kd.bos.ext.ai.cvp.utils.AiLicenseUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TieEntityOperate
extends FormOperate
implements ICloseCallBack {
    private static Log logger = LogFactory.getLog(TieEntityOperate.class);
    private static final String MOULD_FORM_ID = "cvp_ie_mouldplan";
    private static final String TIE_RELATECONFIG_ENTITY = "cvp_ie_relateconfig";
    private static final String FORM_ID = "cvp_ie_info";
    private static final String ACTION_TYPE = "ie_operate_type";
    private static final String ACTION_TYPE_VALUE = "ie_create_task";
    private static final String BILL_ID = "billid";
    private static final String BILL_Name = "billName";
    private static final String BILL_Number = "billNumber";
    private static final String BUSINESS_OBJECT = "businessobject";
    private static final String PAGE_ID = "pageId";
    private static final String MOULD_ID = "mouldId";
    private static final String ACTION_ID = "infoExtract";
    private static final String KEY_RELATECONFIG_BUSOBJ = "businessobj";

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (!AiLicenseUtils.validLicenseNew(this.getView())) {
            return false;
        }
        boolean isSaved = this.isSaved();
        if (!isSaved) {
            logger.error("\u672a\u4fdd\u5b58\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5f00\u59cb\u63d0\u53d6\u3002");
            return false;
        }
        String entityId = this.getEntityId();
        DynamicObject mouldObj = this.queryMould();
        if (mouldObj == null) {
            return false;
        }
        boolean relateConfigFlag = this.validRelationConfig(entityId);
        if (!relateConfigFlag) {
            return false;
        }
        String billName = this.getBillName(this.getView().getModel());
        Object billNumber = this.getBillNumber(this.getView().getModel());
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId(FORM_ID);
        formShow.setCustomParam(ACTION_TYPE, (Object)ACTION_TYPE_VALUE);
        formShow.setCustomParam(BILL_ID, this.getView().getModel().getDataEntity().getPkValue());
        formShow.setCustomParam(BILL_Name, (Object)billName);
        formShow.setCustomParam(BILL_Number, billNumber);
        formShow.setCustomParam(BUSINESS_OBJECT, (Object)entityId);
        formShow.setCustomParam(PAGE_ID, (Object)this.getView().getPageId());
        formShow.setCustomParam(MOULD_ID, mouldObj.getPkValue());
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("90%");
        styleCss.setHeight("90%");
        formShow.getOpenStyle().setInlineStyleCss(styleCss);
        formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_ID));
        this.getView().showForm(formShow);
        return false;
    }

    private boolean validRelationConfig(String entityKey) {
        QFilter filter = new QFilter(KEY_RELATECONFIG_BUSOBJ, "=", (Object)entityKey);
        boolean relateConfigExist = QueryServiceHelper.exists((String)TIE_RELATECONFIG_ENTITY, (QFilter[])new QFilter[]{filter});
        if (!relateConfigExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u672a\u505a\u63d0\u53d6\u5173\u8054\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"TieEntityOperate_2", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Object getBillNumber(IDataModel model) {
        String number;
        try {
            number = String.valueOf(model.getValue("number"));
        }
        catch (Exception e) {
            number = "";
            logger.info("\u8be5\u5355\u636e\u65e0\u7f16\u7801number\u5c5e\u6027");
        }
        return number;
    }

    private String getBillName(IDataModel model) {
        String billName;
        try {
            Object billNameLocal = model.getValue("name");
            billName = billNameLocal instanceof OrmLocaleValue ? ((OrmLocaleValue)billNameLocal).getLocaleValue() : String.valueOf(billNameLocal);
        }
        catch (Exception e) {
            billName = "";
            logger.info("\u8be5\u5355\u636e\u65e0\u540d\u79f0name\u5c5e\u6027");
        }
        return billName;
    }

    private DynamicObject queryMould() {
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)true)};
        DynamicObject[] mouldObj = BusinessDataServiceHelper.load((String)MOULD_FORM_ID, (String)"id,number", (QFilter[])qFilters);
        if (mouldObj == null || mouldObj.length < 1) {
            this.getView().showTipNotification("\u4e0d\u5b58\u5728\u4efb\u4f55\u53ef\u7528\u4fe1\u606f\u63d0\u53d6\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            return null;
        }
        logger.info("\u8fd4\u56de\u6a21\u677f\u7684id:{}", mouldObj[0].getPkValue());
        return mouldObj[0];
    }

    private boolean isSaved() {
        Object billId = this.getView().getModel().getDataEntity().getPkValue();
        String entityKey = this.getEntityId();
        boolean billExist = QueryServiceHelper.exists((String)entityKey, (Object)billId);
        if (!billExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58", (String)"TieEntityOperate_1", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        IFormView view = evt.getView();
        try {
            Object returnData;
            if (ACTION_ID.equals(actionId) && (returnData = evt.getReturnData()) != null) {
                BillModel model = (BillModel)view.getModel();
                this.rewriteBill(model, returnData);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u53d6\u6210\u529f,\u5e76\u5bfc\u5165\u6570\u636e", (String)"TieEntityOperate_0", (String)"bos-ext-ai", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            view.showTipNotification("Tie Exception ");
            logger.error("TIE,\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u5f02\u5e38,\u64cd\u4f5c\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
        }
    }

    private void rewriteBill(BillModel model, Object returnData) throws IOException {
        DynamicObject billObj = model.getDataEntity(true);
        ResultData info = (ResultData)SerializationUtils.fromJsonString((String)String.valueOf(returnData), ResultData.class);
        AlgoData data = info.getData();
        Map<String, String> textOcr = data.getTextOcr();
        Map<String, List<Map<String, String>>> tablesOcr = data.getTablesOcr();
        DataEntityPropertyCollection entryType = billObj.getDataEntityType().getProperties();
        Set<Map.Entry<String, String>> map = textOcr.entrySet();
        ArrayList<String> existEntry = new ArrayList<String>();
        HashMap<String, Object> insertMap = new HashMap<String, Object>();
        CommonOperate.ordinaryTextInsert(entryType, billObj, model, map, existEntry, insertMap);
        CommonOperate.tableInsert((IDataModel)model, entryType, tablesOcr, existEntry, insertMap);
    }
}

