/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class AiLicenseUtils {
    private static Log logger = LogFactory.getLog(AiLicenseUtils.class);
    private static String PROCVPRN = "PROCVPRN";
    private static String PROCVPR = "PROCVPR";
    private static String PROCVPD = "PROCVPD";

    private AiLicenseUtils() {
    }

    public static boolean checkHasRDLicense() {
        boolean cvprLicense = LicenseServiceHelper.checkPerformGroup((String)PROCVPR).getHasLicense();
        boolean cvpdLicense = LicenseServiceHelper.checkPerformGroup((String)PROCVPD).getHasLicense();
        String productVersion = LicenseServiceHelper.getProductVersion();
        String pubTenantType = LicenseServiceHelper.getPubTenantType();
        boolean envStatus = Boolean.parseBoolean(pubTenantType);
        logger.info(String.format("\u8bb8\u53ef\u72b6\u6001\uff1acvpr:%s,cvpd:%s,productVersion:%s", cvprLicense, cvpdLicense, productVersion));
        return "1.0".equalsIgnoreCase(productVersion) || envStatus && cvpdLicense || !envStatus && cvprLicense;
    }

    public static boolean validLicenseNew(IFormView view) {
        boolean cvprnLicense;
        boolean hasRDLicense = AiLicenseUtils.checkHasRDLicense();
        if (!hasRDLicense && !(cvprnLicense = LicenseServiceHelper.checkPerformGroup((String)PROCVPRN).getHasLicense().booleanValue())) {
            String message = ResManager.loadKDString((String)"\u672a\u83b7\u5f97\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u3002", (String)"LicenseUtils_0", (String)"ai-cvp-common", (Object[])new Object[0]);
            view.showTipNotification(message);
            return false;
        }
        return true;
    }
}

