/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.ai.cvp.utils.DateUtils;
import kd.bos.ext.ai.cvp.utils.es.OcrEsUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class DataConversionUtils {
    private static Log logger = LogFactory.getLog(DataConversionUtils.class);
    private static final String ERROR_CORRECTION_FILED = "name";

    public static Object getPropValueToType(DataEntityPropertyCollection ps, String k, String v) throws IOException {
        DateFormat dateFormat;
        String[] propsStr = k.split("\\.");
        String entityName = propsStr[0];
        IDataEntityProperty p = (IDataEntityProperty)ps.get((Object)entityName);
        if (p instanceof EntryProp) {
            DataEntityPropertyCollection entryType = ((EntryType)((EntryProp)p).getItemType()).getProperties();
            p = (IDataEntityProperty)entryType.get((Object)propsStr[1]);
        }
        if (p instanceof DecimalProp) {
            v = v.replaceAll(",", "");
            try {
                return new BigDecimal(StringUtils.isEmpty((String)v) ? "0.00" : v);
            }
            catch (Exception e) {
                logger.error("BigDecimal\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38,\u56de\u586b\u9ed8\u8ba4\u503c0", (Throwable)e);
                return new BigDecimal("0.00");
            }
        }
        if (p instanceof IntegerProp) {
            v = v.replaceAll(",", "");
            try {
                return Integer.valueOf(StringUtils.isEmpty((String)v) ? "0" : v);
            }
            catch (Exception e) {
                logger.error("int\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38,\u56de\u586b\u9ed8\u8ba4\u503c0", (Throwable)e);
                return Integer.valueOf("0");
            }
        }
        if (p instanceof LongProp) {
            v = v.replaceAll(",", "");
            try {
                return Long.valueOf(StringUtils.isEmpty((String)v) ? "0" : v);
            }
            catch (Exception e) {
                logger.error("Long\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38,\u56de\u586b\u9ed8\u8ba4\u503c0", (Throwable)e);
                return Long.valueOf("0");
            }
        }
        if (p instanceof TextProp) {
            return v;
        }
        if (p instanceof BasedataProp) {
            DynamicObject bd = null;
            BasedataProp basedataProp = (BasedataProp)p;
            String basedataName = basedataProp.getComplexType().getName();
            logger.info("OCR \u56de\u586b\u57fa\u7840\u8d44\u6599\u4fe1\u606f start \u5355\u636e\u6807\u8bc6 : " + basedataName);
            try {
                String property = propsStr[propsStr.length - 1];
                boolean enable = DtsAccountPower.isAccountDtsEnable();
                if (enable && property.equals(ERROR_CORRECTION_FILED)) {
                    Long pkId = null;
                    try {
                        pkId = OcrEsUtils.errorCorrectionOnlyEntiytyPkId(basedataName, v);
                    }
                    catch (KDBizException ex) {
                        logger.warn("DTS \u914d\u7f6e\u8b66\u544a: CVP\u5e94\u7528 MC\u672a\u914d\u7f6e DTS \u53c2\u6570,\u5c06\u65e0\u6cd5\u4f7f\u7528NLP\u7ea0\u9519\u529f\u80fd:" + ex.getMessage(), (Throwable)ex);
                    }
                    catch (KDException ex) {
                        String message = ResManager.loadKDString((String)("DTS \u53c2\u6570\u914d\u7f6e\u6709\u8bef:" + ex.getMessage()), (String)"OcrPlanPlugin_8", (String)"ai-cvp-plugin", (Object[])new Object[0]);
                        logger.warn(message, (Throwable)ex);
                    }
                    catch (Exception ex) {
                        logger.warn("DTS \u65b0\u589e\u914d\u7f6e\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
                    }
                    logger.info("OCR \u7ea0\u9519\u5904\u7406\u83b7\u5f97\u5230\u7684\u57fa\u7840\u8d44\u6599\u4fe1\u606f PKID : " + pkId);
                    if (pkId != null) {
                        try {
                            bd = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)basedataName);
                        }
                        catch (Exception e) {
                            throw new KDBizException("OCR \u7ea0\u9519\u5904\u7406\u83b7\u5f97\u5230\u7684\u57fa\u7840\u8d44\u6599\u4fe1\u606f PKID : " + pkId);
                        }
                    } else {
                        QFilter filter = new QFilter(property, "=", (Object)v);
                        bd = BusinessDataServiceHelper.loadSingleFromCache((String)basedataName, (QFilter[])new QFilter[]{filter});
                    }
                } else {
                    QFilter filter = new QFilter(property, "=", (Object)v);
                    bd = BusinessDataServiceHelper.loadSingleFromCache((String)basedataName, (QFilter[])new QFilter[]{filter});
                }
                if (bd == null) {
                    bd = BusinessDataServiceHelper.newDynamicObject((String)basedataName);
                }
            }
            catch (Exception e) {
                bd = BusinessDataServiceHelper.newDynamicObject((String)basedataName);
                logger.error("OCR \u57fa\u7840\u8d44\u6599\u4fe1\u606f \u4fe1\u606f\u5bfc\u5165\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            }
            return bd;
        }
        if (p instanceof TimeProp) {
            dateFormat = ((TimeProp)p).getDateFormat();
            return DataConversionUtils.valueToDateType(dateFormat, v);
        }
        if (p instanceof DateProp) {
            dateFormat = ((DateProp)p).getDateFormat();
            return DataConversionUtils.valueToDateType(dateFormat, v);
        }
        return null;
    }

    public static Date valueToDateType(DateFormat dateFormat, String v) {
        try {
            if (StringUtils.isNotEmpty((String)v)) {
                Date date = DateUtils.parseFormatedDate(v);
                String dateStr = dateFormat.format(date);
                return dateFormat.parse(dateStr);
            }
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38,\u56de\u586b\u9ed8\u8ba4\u503c null", (Throwable)e);
            return null;
        }
        return null;
    }
}

