/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils;

import java.math.BigDecimal;
import kd.bos.ext.ai.cvp.utils.ChineseNumberUtil;

class NumberParser {
    NumberParser() {
    }

    private static String c2n(String str) {
        if (str == null) {
            return "";
        }
        if (str.isEmpty()) {
            return "0";
        }
        return ChineseNumberUtil.chineseNumberString2Digit(str);
    }

    private static String getStringBefore(String s, String afterString) {
        int index = s.indexOf(afterString);
        if (index < 0) {
            return "";
        }
        return s.substring(0, index);
    }

    private static String getGeweiValue(String str) {
        String[] borders;
        for (String s : borders = new String[]{"\u5341", "\u767e\u96f6", "\u767e", "\u5343\u96f6", "\u5343", "\u4e07\u96f6", "\u4e07"}) {
            if (!"\u5341".equals(s) && s.equals(str)) {
                return null;
            }
            int index = str.indexOf(s);
            if (index < 0) continue;
            return NumberParser.c2n(str.substring(index + s.length()));
        }
        return NumberParser.c2n(str);
    }

    private static String getShiweiValue(String str) {
        String[] borders;
        int index = str.indexOf("\u767e\u96f6");
        if (index >= 0) {
            return "0";
        }
        for (String s : borders = new String[]{"\u767e", "\u5343\u96f6", "\u5343", "\u4e07\u96f6", "\u4e07"}) {
            index = str.indexOf(s);
            if (index < 0) continue;
            String s1 = str.substring(index + s.length());
            return NumberParser.c2n(NumberParser.getStringBefore(s1, "\u5341"));
        }
        index = str.indexOf("\u5341");
        if (index >= 0) {
            String v = str.substring(0, index);
            if (v.isEmpty()) {
                return "1";
            }
            return NumberParser.c2n(v);
        }
        return "";
    }

    private static String getBaiweiValue(String str) {
        String[] borders;
        int index = str.indexOf("\u5343\u96f6");
        if (index >= 0) {
            return "0";
        }
        for (String s : borders = new String[]{"\u5343", "\u4e07\u96f6", "\u4e07"}) {
            index = str.indexOf(s);
            if (index < 0) continue;
            String s1 = str.substring(index + s.length());
            return NumberParser.c2n(NumberParser.getStringBefore(s1, "\u767e"));
        }
        index = str.indexOf("\u767e");
        if (index >= 0) {
            return NumberParser.c2n(str.substring(0, index));
        }
        return "";
    }

    private static String getQianweiValue(String str) {
        int index = str.indexOf("\u4e07\u96f6");
        if (index >= 0) {
            return "0";
        }
        index = str.indexOf("\u4e07");
        if (index >= 0) {
            String s1 = str.substring(index + "\u4e07".length());
            return NumberParser.c2n(NumberParser.getStringBefore(s1, "\u5343"));
        }
        index = str.indexOf("\u5343");
        if (index >= 0) {
            return NumberParser.c2n(str.substring(0, index));
        }
        return "";
    }

    private static String convertQianPart(String str) {
        String gewei = NumberParser.getGeweiValue(str);
        if (gewei == null) {
            return null;
        }
        String shiwei = NumberParser.getShiweiValue(str);
        if (shiwei == null) {
            return null;
        }
        String baiwei = NumberParser.getBaiweiValue(str);
        if (baiwei == null) {
            return null;
        }
        String qianwei = NumberParser.getQianweiValue(str);
        if (qianwei == null) {
            return null;
        }
        str = qianwei + baiwei + shiwei + gewei;
        return str;
    }

    private static boolean isNotHaveUnit(String str) {
        String units = "\u5341\u767e\u5343\u4e07\u4ebf\u534a";
        for (int i = 0; i < units.length(); ++i) {
            if (!str.contains(String.valueOf(units.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private static String convertYi(String str) {
        String right;
        String result = "";
        int flag = 0;
        int index = str.indexOf("\u4e07");
        if (index >= 0) {
            String leftS = str.substring(0, index);
            String rightS = str.substring(index + "\u4e07".length());
            String left = NumberParser.convertQianPart(leftS);
            if (rightS.isEmpty()) {
                return left + "0000";
            }
            result = left;
            flag = 4;
            str = rightS;
        }
        if ((right = NumberParser.convertQianPart(str)) == null) {
            return null;
        }
        return result + NumberParser.paddingZero(flag - right.length()) + right;
    }

    private static String convertIntegerPart(String str, int leftShiftCount) {
        int index = str.lastIndexOf("\u4ebf");
        if (index >= 0) {
            String right;
            int flag = 8;
            String leftS = str.substring(0, index);
            String rightS = str.substring(index + "\u4ebf".length());
            String string = right = rightS.isEmpty() ? NumberParser.paddingZero(flag) : NumberParser.convertYi(rightS);
            if (right == null) {
                return null;
            }
            String left = NumberParser.convertIntegerPart(leftS, leftShiftCount + flag);
            if (left == null) {
                return null;
            }
            String result = left + NumberParser.paddingZero(flag - right.length()) + right;
            return result;
        }
        String right = NumberParser.convertYi(str);
        return right;
    }

    private static String paddingZero(int zeroCount) {
        if (zeroCount < 1) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < zeroCount; ++i) {
            text.append('0');
        }
        return text.toString();
    }

    public static String convertIntegerPart(String str) {
        return NumberParser.convertIntegerPart(str, 0);
    }

    public static String convertAll(String str) {
        if (NumberParser.isNotHaveUnit(str)) {
            return NumberParser.c2n(str);
        }
        String floatPart = "";
        int index = str.indexOf("\u70b9");
        if (index >= 0) {
            String i = str.substring(index + "\u70b9".length());
            str = str.substring(0, index);
            floatPart = "." + NumberParser.c2n(i);
        } else {
            index = str.indexOf("\u534a");
            if (index >= 0) {
                str = str.substring(0, index);
                floatPart = ".5";
            }
        }
        String yi = NumberParser.convertIntegerPart(str);
        if (yi == null) {
            return null;
        }
        return yi + floatPart;
    }

    private static int indexOfYuan(String str, int fromIndex) {
        int i = str.indexOf(20803, fromIndex);
        if (i >= 0) {
            return i;
        }
        i = str.indexOf(22278, fromIndex);
        if (i >= 0) {
            return i;
        }
        i = str.indexOf(22359, fromIndex);
        if (i >= 0) {
            return i;
        }
        return -1;
    }

    private static int indexOfJiao(String str, int fromIndex) {
        int i = str.indexOf(35282, fromIndex);
        if (i >= 0) {
            return i;
        }
        i = str.indexOf(27611, fromIndex);
        if (i >= 0) {
            return i;
        }
        return -1;
    }

    private static int indexOfFen(String str, int fromIndex) {
        return str.indexOf(20998, fromIndex);
    }

    public static String chineseNum2Digit(String str) {
        BigDecimal sum;
        String intPart;
        String intPart2;
        str = str.replace(",", "");
        int indexOfYuan = NumberParser.indexOfYuan(str, 0);
        int indexOfJiao = NumberParser.indexOfJiao(str, indexOfYuan);
        int indexOfFen = NumberParser.indexOfFen(str, indexOfJiao);
        if (indexOfYuan == -1 && indexOfJiao == -1 && indexOfFen == -1) {
            return NumberParser.convertAll(str);
        }
        String sYuanPart = null;
        String sJiaoPart = null;
        String sFenPart = null;
        if (indexOfYuan != -1 && !(intPart2 = str.substring(0, indexOfYuan)).isEmpty()) {
            sYuanPart = NumberParser.convertAll(intPart2);
        }
        if (indexOfJiao != -1) {
            int startIndex = indexOfYuan;
            startIndex = startIndex < 0 ? 0 : ++startIndex;
            intPart = str.substring(startIndex, indexOfJiao);
            if (!intPart.isEmpty()) {
                sJiaoPart = NumberParser.convertAll(intPart);
            }
        }
        if (indexOfFen != -1) {
            int startIndex = indexOfJiao;
            startIndex = startIndex < 0 && (startIndex = indexOfYuan) < 0 ? 0 : ++startIndex;
            intPart = str.substring(startIndex, indexOfFen);
            if (!intPart.isEmpty()) {
                sFenPart = NumberParser.convertAll(intPart);
            }
        }
        if ((sum = NumberParser.sumMoney(sYuanPart, sJiaoPart, sFenPart)) == null) {
            return null;
        }
        return sum.toString();
    }

    private static BigDecimal sumMoney(String sYuanPart, String sJiaoPart, String sFenPart) {
        if (sYuanPart == null && sJiaoPart == null && sFenPart == null) {
            return null;
        }
        BigDecimal sum = new BigDecimal("0");
        if (sFenPart != null) {
            sum = sum.add(new BigDecimal(sFenPart).divide(BigDecimal.TEN).divide(BigDecimal.TEN));
        }
        if (sJiaoPart != null) {
            sum = sum.add(new BigDecimal(sJiaoPart).divide(BigDecimal.TEN));
        }
        if (sYuanPart != null) {
            sum = sum.add(new BigDecimal(sYuanPart));
        }
        return sum;
    }
}

