/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ext.ai.cvp.entity.es.OcrESFilterEntity;
import kd.bos.ext.ai.cvp.entity.es.OcrESQueryParam;
import kd.bos.ext.ai.cvp.factory.OcrEsFactory;
import kd.bos.ext.ai.cvp.utils.es.OcrStringSimilarityUitls;
import kd.bos.ext.ai.cvp.utils.es.OcrStringUtils;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class OcrEsUtils {
    private static final String DEFAULT_ES_SORT = "_score";
    private static final int DEFAULT_TOP_NUMBER = 5;
    private static Log log = LogFactory.getLog(OcrEsUtils.class);

    public static List<Map<String, Object>> queryDataTopFive(OcrESQueryParam ocrESQueryParam) throws IOException {
        return OcrEsUtils.queryDataTop(ocrESQueryParam, 5);
    }

    public static List<Map<String, Object>> queryDataTop(OcrESQueryParam queryParams, int top) throws IOException {
        SearchRequest request = OcrEsUtils.createSearchRequest(queryParams, top);
        List<Map<String, Object>> result = OcrEsUtils.search(request);
        return result;
    }

    public static SearchRequest createSearchRequest(OcrESQueryParam queryParams, int top) {
        SearchRequest request = new SearchRequest(new String[]{OcrEsUtils.getEsIndex()});
        SearchSourceBuilder searchSourceBuilder = OcrEsUtils.createSearchSourceBuilder(queryParams, top);
        request.types(new String[]{"t_data"});
        request.source(searchSourceBuilder);
        return request;
    }

    public static SearchSourceBuilder createSearchSourceBuilder(OcrESQueryParam queryParams, int top) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = OcrEsUtils.createBoolQueryBuilder(queryParams);
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)DEFAULT_ES_SORT).order(SortOrder.DESC);
        String[] returnFields = queryParams.getReturnFields();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).fetchSource(returnFields, null).sort((SortBuilder)sortBuilder).size(top);
        return searchSourceBuilder;
    }

    public static BoolQueryBuilder createBoolQueryBuilder(OcrESQueryParam queryParams) {
        List<OcrESFilterEntity> paramsFilters = queryParams.getFilters();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (OcrESFilterEntity e : paramsFilters) {
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)e.getFilterKey(), (Object)e.getFilterValue());
            boolQueryBuilder.should((QueryBuilder)matchQueryBuilder);
        }
        return boolQueryBuilder;
    }

    public static List<Map<String, Object>> search(SearchRequest search) throws IOException {
        log.info(String.format("CVP ES search \u8bf7\u6c42\u5934: %s", search.toString()));
        RestHighLevelClient esClient = OcrEsFactory.getEsClient("cvpsearch");
        SearchResponse resp = esClient.search(search, RequestOptions.DEFAULT);
        SearchHits hits = resp.getHits();
        log.info(String.format("CVP ES search \u7ed3\u679c: %s", resp.toString()));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(hits.getHits().length);
        for (SearchHit hit : hits) {
            Map sourceAsMap = hit.getSourceAsMap();
            result.add(sourceAsMap);
        }
        return result;
    }

    public static Map<String, String> getDefaultEsServiceConfig() {
        return OcrEsUtils.fullTextGetServerConfig("cvpsearch");
    }

    private static Map<String, String> fullTextGetServerConfig(String region) {
        return OcrEsFactory.getServerConfig(region);
    }

    public static String getEsIndex() {
        StringBuilder index = new StringBuilder();
        String indexNamePrefix = CommonUtil.getIndexNamePrefix((String)"cvpsearch");
        index.append(indexNamePrefix).append("_data");
        return index.toString();
    }

    public static OcrESQueryParam setErrorCorrectionEsParam(String entityname, String fileterValue) {
        ArrayList<OcrESFilterEntity> list = new ArrayList<OcrESFilterEntity>();
        String nameKey = String.format("name_%s_string", RequestContext.get().getLang().name().toLowerCase());
        String nameKeyKeyword = String.format("name_%s_string.keyword", RequestContext.get().getLang().name().toLowerCase());
        list.add(new OcrESFilterEntity("entityname", entityname));
        list.add(new OcrESFilterEntity(nameKey, fileterValue));
        list.add(new OcrESFilterEntity(nameKeyKeyword, fileterValue));
        return new OcrESQueryParam(list, new String[]{"pkid", nameKey});
    }

    public static Long errorCorrectionOnlyEntiytyPkId(String entityName, String fileterValue) throws IOException {
        try {
            OcrEsUtils.getDefaultEsServiceConfig();
        }
        catch (Exception ex) {
            log.warn("DTS \u914d\u7f6e\u6709\u8bef,\u65e0\u6cd5\u4f7f\u7528\u7ea0\u9519\u529f\u80fd \u5f02\u5e38\u4fe1\u606f:" + ex.getMessage(), (Throwable)ex);
            return null;
        }
        OcrESQueryParam ocrESQueryParam = OcrEsUtils.setErrorCorrectionEsParam(entityName, fileterValue);
        List<Map<String, Object>> maps = OcrEsUtils.queryDataTopFive(ocrESQueryParam);
        String[] returnFields = ocrESQueryParam.getReturnFields();
        OcrStringSimilarityUitls instance = OcrStringSimilarityUitls.getInstance();
        double maxSimilarity = 0.0;
        Long maxPkId = null;
        for (Map<String, Object> map : maps) {
            String targeValueEncode;
            String originValueEncode;
            double similarityEncode;
            Long pkid = Long.valueOf(String.valueOf(map.get(returnFields[0])));
            String nameValue = String.valueOf(map.get(returnFields[1]));
            double similarity = instance.similarity(fileterValue, nameValue);
            double currenValue = Math.max(similarity, similarityEncode = instance.similarity(originValueEncode = OcrStringUtils.strConversion(fileterValue), targeValueEncode = OcrStringUtils.strConversion(nameValue)));
            if (currenValue == 1.0) {
                return pkid;
            }
            boolean status = currenValue > maxSimilarity;
            if (!status) continue;
            maxSimilarity = currenValue;
            maxPkId = pkid;
        }
        return maxPkId;
    }
}

