/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils.es;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OcrSimilarityDictUtils {
    private static final String KEY_CACHE = "ai_cvp_cache";
    private static Log logger = LogFactory.getLog(OcrSimilarityDictUtils.class);
    private static DistributeSessionlessCache chineseDictCache;
    private static final String dictPath = "/dict/char_meta.txt";

    public static String getDictValue(String key) throws IOException {
        return (String)OcrSimilarityDictUtils.getDict().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DistributeSessionlessCache getDict() throws IOException {
        if (chineseDictCache != null) return chineseDictCache;
        Class<OcrSimilarityDictUtils> clazz = OcrSimilarityDictUtils.class;
        synchronized (OcrSimilarityDictUtils.class) {
            if (chineseDictCache != null) return chineseDictCache;
            chineseDictCache = OcrSimilarityDictUtils.initDictCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return chineseDictCache;
        }
    }

    private static DistributeSessionlessCache initDictCache() throws IOException {
        String line;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(KEY_CACHE);
        InputStream in = OcrSimilarityDictUtils.class.getResourceAsStream(dictPath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            String[] dicts = line.split("\\t");
            cache.put(dicts[1], (Object)dicts[3], -1);
        }
        return cache;
    }

    static {
        try {
            chineseDictCache = OcrSimilarityDictUtils.initDictCache();
        }
        catch (IOException e) {
            logger.error("\u4e2d\u6587\u7ea0\u9519\u5b57\u5178\u521d\u521d\u59cb\u5316\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            throw new KDBizException("cvp chinese dict init error");
        }
    }
}

