/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils.es;

import kd.bos.exception.KDBizException;
import kd.bos.ext.ai.cvp.utils.es.Levenshtein;

public class OcrStringSimilarityUitls {
    private final Levenshtein l = new Levenshtein();
    private static OcrStringSimilarityUitls stringSimilarity;

    private OcrStringSimilarityUitls() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OcrStringSimilarityUitls getInstance() {
        if (stringSimilarity != null) return stringSimilarity;
        Class<OcrStringSimilarityUitls> clazz = OcrStringSimilarityUitls.class;
        synchronized (OcrStringSimilarityUitls.class) {
            if (stringSimilarity != null) return stringSimilarity;
            stringSimilarity = new OcrStringSimilarityUitls();
            // ** MonitorExit[var0] (shouldn't be in output)
            return stringSimilarity;
        }
    }

    public final double distance(String origin, String target) {
        if (origin == null) {
            throw new KDBizException("origin must not be null");
        }
        if (target == null) {
            throw new KDBizException("target must not be null");
        }
        if (origin.equals(target)) {
            return 0.0;
        }
        int m_len = Math.max(origin.length(), target.length());
        if (m_len == 0) {
            return 0.0;
        }
        return this.l.distance(origin, target) / (double)m_len;
    }

    public final double similarity(String origin, String target) {
        return 1.0 - this.distance(origin, target);
    }
}

