/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.api.IExtSysService;
import kd.bos.sysint.cache.SysIntegCacheMrg;

public class DataMappingComparePlugin
extends AbstractFormPlugin {
    private static final String DATATYPE = "datatype";
    private static final String BOS_ORG = "bos_org";
    private static final String NUMBER = "number";
    private static final String BOS_USER = "bos_user";
    private static final String ISBASEEXTDATA = "isbaseextdata";
    private static final String EXTDATAID = "extdataid";
    private static final String MAPPINGID = "mappingid";
    private static final String EXTNUMBER = "extnumber";
    private static final String MAPPINGNUMBER = "mappingnumber";
    private static final String MAPPINGNAME = "mappingname";
    private static final String EXTNAME = "extname";
    private static final String DATAMAPPINGID = "datamappingid";
    private static final String BOS_SYSINTEG_FORMPLUGIN = "bos-sysinteg-formplugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (paramMap != null) {
            Object pId;
            Object datatype = paramMap.get(DATATYPE);
            this.getModel().setValue(DATATYPE, datatype);
            DynamicObject datatypeObj = (DynamicObject)this.getModel().getValue(DATATYPE);
            if (datatypeObj != null) {
                QFilter filter;
                BasedataEdit datatypeEdit;
                if (BOS_ORG.equals(datatypeObj.getString(NUMBER))) {
                    datatypeEdit = (BasedataEdit)this.getControl(DATATYPE);
                    filter = new QFilter(NUMBER, "in", (Object)new String[]{BOS_ORG, "bos_costcenter"});
                    datatypeEdit.setQFilter(filter);
                } else if (BOS_USER.equals(datatypeObj.getString(NUMBER))) {
                    datatypeEdit = (BasedataEdit)this.getControl(DATATYPE);
                    filter = new QFilter(NUMBER, "in", (Object)new String[]{BOS_USER, "bos_person"});
                    datatypeEdit.setQFilter(filter);
                }
            }
            if (StringUtils.isNotBlank(pId = paramMap.get("id"))) {
                long id = Long.parseLong(pId.toString());
                this.getModel().setValue("id", (Object)id);
                Object dataType = this.getModel().getValue(DATATYPE);
                if (StringUtils.isBlank((Object)dataType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b", (String)"DataMappingComparePlugin_0", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                DynamicObject dataTypeObj = (DynamicObject)dataType;
                this.initEasData(dataTypeObj, id);
                this.initMappingData(dataTypeObj, id);
                this.showDiffrenceTips();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if (DATATYPE.equals(proName)) {
            Object idObj = this.getModel().getValue("id");
            if (StringUtils.isBlank((Object)idObj)) {
                return;
            }
            Object dataType = this.getModel().getValue(DATATYPE);
            if (StringUtils.isBlank((Object)dataType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b", (String)"DataMappingComparePlugin_0", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.dataTypeChange(idObj, dataType);
        } else if (ISBASEEXTDATA.equals(proName)) {
            this.isBaseExtDataChange();
        }
    }

    private void isBaseExtDataChange() {
        IDataModel model = this.getModel();
        if (((Boolean)model.getValue(ISBASEEXTDATA)).booleanValue()) {
            Object extdataid = model.getValue(EXTDATAID);
            if (StringUtils.isBlank((Object)extdataid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u6620\u5c04\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u5f55\u5165\u6620\u5c04\u5173\u7cfb\u3002", (String)"DataMappingComparePlugin_1", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
                model.setValue(ISBASEEXTDATA, (Object)Boolean.FALSE);
                return;
            }
            model.setValue(MAPPINGID, extdataid);
            model.setValue(MAPPINGNUMBER, model.getValue(EXTNUMBER));
            model.setValue(MAPPINGNAME, model.getValue(EXTNAME));
        } else {
            if (StringUtils.isBlank((Object)model.getValue(MAPPINGNUMBER))) {
                model.setValue(MAPPINGNUMBER, model.getValue(NUMBER));
            }
            if (StringUtils.isBlank((Object)model.getValue(MAPPINGNAME))) {
                model.setValue(MAPPINGNAME, model.getValue("name"));
            }
        }
    }

    private void dataTypeChange(Object idObj, Object dataType) {
        DynamicObject dataTypeObj = (DynamicObject)dataType;
        long id = Long.parseLong(idObj.toString());
        this.initEasData(dataTypeObj, id);
        this.initMappingData(dataTypeObj, id);
        this.showDiffrenceTips();
        if (!((Boolean)this.getModel().getValue(ISBASEEXTDATA)).booleanValue()) {
            this.getModel().setValue(ISBASEEXTDATA, (Object)Boolean.TRUE);
        }
    }

    private void showDiffrenceTips() {
        this.showFieldTips(EXTNAME, MAPPINGNAME);
        this.showFieldTips(EXTNUMBER, MAPPINGNUMBER);
        this.showFieldTips(EXTDATAID, MAPPINGID);
    }

    private void showFieldTips(String extProName, String sysProName) {
        String tips = "";
        if (!String.valueOf(this.getModel().getValue(extProName)).trim().equals(String.valueOf(this.getModel().getValue(sysProName)).trim())) {
            tips = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u4e00\u81f4", (String)"DataMappingComparePlugin_2", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]);
        }
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(sysProName);
        LocaleString ls = new LocaleString(tips);
        fieldTip.setTip(ls.getLocaleValue());
        this.getView().showFieldTip(fieldTip);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String itemkey = c.getKey().toLowerCase();
        if (!"btnok".equals(itemkey)) {
            return;
        }
        Object extdataid = this.getModel().getValue(EXTDATAID);
        if (StringUtils.isBlank((Object)extdataid) && ((Boolean)this.getModel().getValue(ISBASEEXTDATA)).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u6620\u5c04\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u5f55\u5165\u6620\u5c04\u5173\u7cfb\u3002", (String)"DataMappingComparePlugin_1", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.saveDataMapping();
        this.showDiffrenceTips();
    }

    private void saveDataMapping() {
        Object datamappingid = this.getModel().getValue(DATAMAPPINGID);
        DynamicObject dataObj = BusinessDataServiceHelper.newDynamicObject((String)"bas_datamapping");
        DynamicObject[] dataObjArr = null;
        if (StringUtils.isBlank((Object)datamappingid) || "0".equals(datamappingid.toString())) {
            dataObjArr = new DynamicObject[]{dataObj};
        } else {
            dataObjArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])new Object[]{datamappingid}, (IDataEntityType)dataObj.getDataEntityType());
            if (dataObjArr == null || dataObjArr.length == 0) {
                dataObjArr = new DynamicObject[]{dataObj};
            }
        }
        this.getDataMapping(dataObjArr);
        SaveServiceHelper.save((DynamicObject[])dataObjArr);
        Object dataType = this.getModel().getValue(DATATYPE);
        if (StringUtils.isNotBlank((Object)dataType)) {
            DynamicObject dataTypeObj = (DynamicObject)dataType;
            SysIntegCacheMrg.clearCache((String)dataTypeObj.getString(NUMBER));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u6620\u5c04\u66f4\u65b0\u6210\u529f", (String)"DataMappingComparePlugin_3", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void getDataMapping(DynamicObject[] dataObjArr) {
        for (DynamicObject dataObj : dataObjArr) {
            dataObj.set(DATATYPE, this.getModel().getValue(DATATYPE));
            dataObj.set("dataid", this.getModel().getValue("id"));
            dataObj.set(NUMBER, this.getModel().getValue(NUMBER));
            dataObj.set("name", this.getModel().getValue("name"));
            dataObj.set(EXTDATAID, this.getModel().getValue(MAPPINGID));
            dataObj.set(EXTNUMBER, this.getModel().getValue(MAPPINGNUMBER));
            dataObj.set(EXTNAME, this.getModel().getValue(MAPPINGNAME));
        }
    }

    private void initEasData(DynamicObject dataTypeObj, long id) {
        IDataModel model = this.getModel();
        model.setValue("extdata", (Object)"");
        model.setValue(EXTDATAID, (Object)"");
        model.setValue(EXTNUMBER, (Object)"");
        model.setValue(EXTNAME, (Object)"");
        String selectFields = "id,number,name";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        String entryName = dataTypeObj.getString(NUMBER);
        int type = 0;
        if (BOS_ORG.equals(entryName)) {
            type = 1;
            selectFields = selectFields + ",fyzjorgid yzjid";
        } else if ("bos_costcenter".equals(entryName)) {
            type = 2;
            entryName = BOS_ORG;
            selectFields = selectFields + ",fyzjorgid yzjid";
        } else if (BOS_USER.equals(entryName)) {
            type = 3;
            selectFields = selectFields + ",phone,useropenid yzjid";
        } else if ("bos_person".equals(entryName)) {
            type = 4;
            selectFields = selectFields + ",phone,useropenid yzjid";
            entryName = BOS_USER;
        }
        DynamicObjectCollection dataObjCol = QueryServiceHelper.query((String)entryName, (String)selectFields, (QFilter[])filters);
        if (dataObjCol == null || dataObjCol.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u524d\u7cfb\u7edf\u6570\u636e\u5931\u8d25", (String)"DataMappingComparePlugin_4", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.setValueByParam(dataTypeObj, model, type, dataObjCol);
    }

    private void setValueByParam(DynamicObject dataTypeObj, IDataModel model, int type, DynamicObjectCollection dataObjCol) {
        IExtSysService service = (IExtSysService)TypesContainer.createInstance((String)"kd.bos.sysint.api.EASExtSysService");
        long externalsysId = ((DynamicObject)dataTypeObj.get("externalsys")).getLong("id");
        service.init(Long.valueOf(externalsysId));
        for (DynamicObject dataObj : dataObjCol) {
            String number = dataObj.getString(NUMBER);
            model.setValue(NUMBER, (Object)number);
            String name = dataObj.getString("name");
            model.setValue("name", (Object)name);
            String yzjId = dataObj.getString("yzjid");
            model.setValue("yzjid", (Object)yzjId);
            Map easDataMap = null;
            switch (type) {
                case 1: {
                    easDataMap = service.getExternalOrg(number, name);
                    break;
                }
                case 2: {
                    easDataMap = service.getExternalCostCenter(number, name);
                    break;
                }
                case 3: {
                    easDataMap = service.getExternalUser(yzjId, name);
                    break;
                }
                case 4: {
                    easDataMap = service.getExternalPerson(yzjId, name);
                    break;
                }
            }
            if (easDataMap == null) {
                this.getModel().setValue(ISBASEEXTDATA, (Object)Boolean.FALSE);
                break;
            }
            model.setValue("extdata", (Object)easDataMap);
            model.setValue(EXTDATAID, easDataMap.get("id"));
            model.setValue(EXTNUMBER, easDataMap.get(NUMBER));
            model.setValue(EXTNAME, easDataMap.get("name"));
        }
    }

    private void initMappingData(DynamicObject dataTypeObj, long id) {
        IDataModel model = this.getModel();
        model.setValue(DATAMAPPINGID, (Object)"");
        model.setValue(MAPPINGID, (Object)"");
        model.setValue(MAPPINGNUMBER, (Object)"");
        model.setValue(MAPPINGNAME, (Object)"");
        String selectFields = "id,extdataid,extnumber,extname";
        QFilter datatypeFilter = new QFilter(DATATYPE, "=", dataTypeObj.getPkValue());
        QFilter idFilter = new QFilter("dataid", "=", (Object)id);
        QFilter[] filters = new QFilter[]{datatypeFilter, idFilter};
        DynamicObjectCollection dataObj = QueryServiceHelper.query((String)"bas_datamapping", (String)selectFields, (QFilter[])filters);
        if (dataObj == null || dataObj.isEmpty()) {
            return;
        }
        for (DynamicObject data : dataObj) {
            model.setValue(DATAMAPPINGID, data.get("id"));
            model.setValue(MAPPINGID, data.get(EXTDATAID));
            model.setValue(MAPPINGNUMBER, data.get(EXTNUMBER));
            model.setValue(MAPPINGNAME, data.get(EXTNAME));
        }
    }
}

