/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DataMappingSearchPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final String SEARCH_FIELD_NAME = "fieldName";
    private static final String SEARCH_FILED_VALUE = "value";
    private static final String PERCENT_LABEL = "%";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DATATYPE = "datatype";
    private static final String NUMBER = "number";

    public void initialize() {
        EntryGrid entry;
        super.initialize();
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if ((entry = (EntryGrid)this.getControl(ENTRYENTITY)) != null) {
            entry.addRowClickListener((RowClickEventListener)this);
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        this.showCompareForm(evt.getRowIndex());
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.showCompareForm(evt.getRow());
    }

    private void showCompareForm(int rowIndex) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
        Object dataType = this.getModel().getValue(DATATYPE);
        if (StringUtils.isBlank((Object)dataType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b", (String)"DataMappingSearchPlugin_0", (String)"bos-sysinteg-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataTypeObj = (DynamicObject)dataType;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bas_datamapping_compare");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(DATATYPE, dataTypeObj.getPkValue());
        formShowParameter.setCustomParam("id", (Object)rowObj.getLong("id"));
        this.getView().showForm(formShowParameter);
    }

    public void search(SearchEnterEvent arg0) {
        this.getModel().getDataEntity(true);
        IDataModel model = this.getModel();
        this.clearSearchResult(model);
        Object dataType = model.getValue(DATATYPE);
        if (StringUtils.isBlank((Object)dataType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b", (String)"DataMappingSearchPlugin_0", (String)"bos-sysinteg-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataTypeObj = (DynamicObject)dataType;
        long dataTypeId = Long.parseLong(dataTypeObj.getPkValue().toString());
        QFilter searchFilters = this.getSearchFilter(arg0);
        if (searchFilters == null) {
            return;
        }
        Object[] dataTypeArr = this.getDataType(dataTypeId);
        if (dataTypeArr == null) {
            return;
        }
        String entityId = dataTypeArr[1].toString();
        try {
            EntityMetadataCache.getDataEntityType((String)entityId);
        }
        catch (Exception e) {
            return;
        }
        String selectFields = "id,number,name";
        QFilter[] filters = new QFilter[]{searchFilters};
        DynamicObjectCollection dataObjCol = QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])filters);
        if (dataObjCol == null || dataObjCol.isEmpty()) {
            return;
        }
        int index = 0;
        for (DynamicObject dataObj : dataObjCol) {
            model.createNewEntryRow(ENTRYENTITY);
            model.setValue("id", dataObj.get("id"), index);
            model.setValue(NUMBER, dataObj.get(NUMBER), index);
            model.setValue("name", dataObj.get("name"), index);
            ++index;
        }
    }

    private void clearSearchResult(IDataModel model) {
        int rowCount = model.getEntryRowCount(ENTRYENTITY);
        for (int i = rowCount - 1; i >= 0; --i) {
            model.deleteEntryRow(ENTRYENTITY, i);
        }
    }

    private QFilter getSearchFilter(SearchEnterEvent arg0) {
        List paramList = arg0.getSearchFields();
        if (paramList == null || paramList.isEmpty()) {
            return null;
        }
        QFilter searchFilters = null;
        for (Map param : paramList) {
            List files = (List)param.get(SEARCH_FIELD_NAME);
            if (files == null || files.size() == 0) continue;
            for (String field : files) {
                List values = (List)param.get(SEARCH_FILED_VALUE);
                if (values == null || values.size() == 0) continue;
                this.multiSearchRelation(searchFilters, field, values);
            }
        }
        return searchFilters;
    }

    private void multiSearchRelation(QFilter searchFilters, String field, List<String> values) {
        for (String value : values) {
            if (StringUtils.isBlank((CharSequence)value)) continue;
            if (null == searchFilters) {
                searchFilters = new QFilter(field, "like", (Object)(PERCENT_LABEL + value + PERCENT_LABEL));
                continue;
            }
            searchFilters = searchFilters.or(new QFilter(field, "like", (Object)(PERCENT_LABEL + value + PERCENT_LABEL)));
        }
    }

    private Object[] getDataType(long dataTypeId) {
        String selectFields = "id,number,externalsys.id externalsys";
        QFilter idFilter = new QFilter("id", "=", (Object)dataTypeId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection dataTypeCol = QueryServiceHelper.query((String)"bas_datatype", (String)selectFields, (QFilter[])filters);
        if (dataTypeCol == null || dataTypeCol.isEmpty()) {
            return null;
        }
        DynamicObject dataTypeObj = (DynamicObject)dataTypeCol.get(0);
        return new Object[]{dataTypeObj.getLong("externalsys"), dataTypeObj.getString(NUMBER)};
    }
}

