/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.sysint.api.DataMappingService;
import kd.bos.util.StringUtils;

public class DataTypeListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(DataTypeListPlugin.class);
    public static final String ENTITYID_EXTERNALSYS = "bas_externalsys";
    public static final String ENTITYID_EASCONFIG = "bas_easconfig";
    public static final String ENTITYID_BAS_DATAMAPPING = "bas_datamapping";
    public static final String ENTITYID_BAS_DATATYPE = "bas_datatype";
    private static final String BOS_SYSINTEG_FORMPLUGIN = "bos-sysinteg-formplugin";

    public void initialize() {
        super.initialize();
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "createmapping": {
                this.createMapping();
                break;
            }
            case "datamappinglist": {
                this.datamappinglist();
                break;
            }
            case "datamappingsearch": {
                this.showSearchForm();
                break;
            }
        }
    }

    private void showSearchForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bas_datamapping_search");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void createMapping() {
        BillList grid = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = grid.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u6570\u636e\u7c7b\u578b\uff01", (String)"DataTypeListPlugin_0", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Long dataTypeID = (Long)selectedRows.get(0).getPrimaryKeyValue();
        DataMappingService DataMappingService2 = new DataMappingService();
        try {
            DataMappingService2.createMapping(dataTypeID);
        }
        catch (KDException e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u6570\u636e\u6620\u5c04\u5931\u8d25\uff0c%s", (String)"DataTypeListPlugin_4", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6570\u636e\u6620\u5c04\u5931\u8d25", (Throwable)e);
            this.getView().showMessage(ResManager.loadKDString((String)"\u521b\u5efa\u6570\u636e\u6620\u5c04\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"DataTypeListPlugin_2", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void datamappinglist() {
        BillList grid = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = grid.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u6570\u636e\u7c7b\u578b\uff01", (String)"DataTypeListPlugin_0", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Long dataTypeID = (Long)selectedRows.get(0).getPrimaryKeyValue();
        ORM orm = ORM.create();
        DynamicObject dataType = orm.getById(ENTITYID_BAS_DATATYPE, (Object)dataTypeID);
        String dataMapEntityId = dataType.getString("datamapentityid");
        if (StringUtils.isEmpty((String)dataMapEntityId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6253\u5f00\u6570\u636e\u6620\u5c04\u5217\u8868\u5931\u8d25\uff0c\u6570\u636e\u6620\u5c04\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u6dfb\u52a0", (String)"DataTypeListPlugin_3", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(dataMapEntityId);
        parameter.setCustomParam("dataTypeID", (Object)dataTypeID);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

