/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import java.sql.Timestamp;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ImageConfigListPlugin
extends AbstractListPlugin
implements ClickListener,
IConfirmCallBack {
    private static final String BAS_IMAGECONFIG = "bas_imageconfig";
    private static final String ENABLE = "enable";
    private static final String BOS_SYSINTEG_FORMPLUGIN = "bos-sysinteg-formplugin";

    public void initialize() {
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("modifytime desc");
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        if ("tblenable".equals(itemKey)) {
            this.enableImageSystem();
        }
    }

    private void enableImageSystem() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        ORM orm = ORM.create();
        DynamicObjectCollection imageSystems = orm.getByFilter(BAS_IMAGECONFIG, null);
        if (imageSystems.size() == 1) {
            for (DynamicObject imageSysInfo : imageSystems) {
                imageSysInfo.set(ENABLE, (Object)"A");
                orm.update(imageSysInfo);
            }
            this.getView().updateView();
        }
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u9879", (String)"ImageConfigListPlugin_0", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"ImageConfigListPlugin_1", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() == 1) {
            ListSelectedRow selectedRow = selectedRows.get(0);
            long id = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject imageSysInfo = this.getImageSysInfoById(id);
            if (imageSysInfo == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5f71\u50cf\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25\uff01\u5f71\u50cf\u7cfb\u7edf\uff1a%s", (String)"ImageConfigListPlugin_5", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]), id));
                return;
            }
            String enableValue = (String)imageSysInfo.get(ENABLE);
            if ("A".equals(enableValue)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f71\u50cf\u7cfb\u7edf\u5df2\u542f\u7528", (String)"ImageConfigListPlugin_3", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.setAllDisable();
            this.setSelectedEnable(id);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8be5\u5f71\u50cf\u7cfb\u7edf\u542f\u7528\u6210\u529f", (String)"ImageConfigListPlugin_4", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().updateView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        int result;
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        long selectRowId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        if (e.getCallBackId().equals("callBackId") && (result = e.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.setAllDisable();
            this.setSelectedEnable(selectRowId);
            this.getView().updateView();
        }
    }

    private DynamicObject getImageSysInfoByWork() {
        DynamicObject ImageSysInfo = null;
        QFilter qFilter = new QFilter(ENABLE, "=", (Object)"A");
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BAS_IMAGECONFIG, (String)"number,work", (QFilter[])qFilters);
        if (dynamicObjects.size() > 0) {
            ImageSysInfo = (DynamicObject)dynamicObjects.get(0);
        }
        return ImageSysInfo;
    }

    private DynamicObject getImageSysInfoById(long id) {
        DynamicObject ImageSysInfo = null;
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BAS_IMAGECONFIG, (String)"number,enable", (QFilter[])qFilters);
        if (dynamicObjects.size() > 0) {
            ImageSysInfo = (DynamicObject)dynamicObjects.get(0);
        }
        return ImageSysInfo;
    }

    private void setAllDisable() {
        ORM orm = ORM.create();
        DynamicObjectCollection imageSystems = orm.getByFilter(BAS_IMAGECONFIG, null);
        for (DynamicObject imageSysInfo : imageSystems) {
            imageSysInfo.set(ENABLE, (Object)"B");
            orm.update(imageSysInfo);
        }
    }

    private void setSelectedEnable(long id) {
        ORM orm = ORM.create();
        DynamicObject imageSysInfo = orm.getById(BAS_IMAGECONFIG, (Object)id);
        Timestamp modifyTime = new Timestamp(System.currentTimeMillis());
        imageSysInfo.set(ENABLE, (Object)"A");
        imageSysInfo.set("modifytime", (Object)modifyTime);
        orm.update(imageSysInfo);
    }
}

