/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.form.control.events;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.events.NameSegEnum;
import kd.bos.ext.metadata.NameSegField;
import kd.bos.ext.metadata.entity.NameCombineEntity;
import kd.bos.ext.metadata.entity.businessfield.NameSegBasedataField;
import kd.bos.ext.metadata.entity.businessfield.NameSegComboField;
import kd.bos.ext.metadata.entity.businessfield.NameSegTextField;
import kd.bos.ext.metadata.form.container.NameCombinePanelAp;
import kd.bos.ext.metadata.form.control.NameSegFieldAp;
import kd.bos.ext.utils.NameControlUtil;
import kd.bos.form.IFormView;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.CreateUIByTypeEvent;
import kd.bos.form.control.events.CreateUIElemntListener;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;

public class NameCombineCreateUIElemntListener
implements CreateUIElemntListener {
    private static final Log LOGGER = LogFactory.getLog(NameCombineCreateUIElemntListener.class);
    private static final String TYPE = "type";
    private IFormView view;

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public NameCombineCreateUIElemntListener(IFormView view) {
        this.view = view;
    }

    public void createUIByType(CreateUIByTypeEvent e) {
        Map elementType = e.getElementType();
        if (NameCombineEntity.class.getSimpleName().equals(elementType.get(TYPE))) {
            this.handleNameCombine(e);
        }
    }

    private void handleNameCombine(CreateUIByTypeEvent e) {
        String entityId = ID.genStringId();
        String containerId = Optional.ofNullable(e.getContainer()).map(container -> container.get("Id")).map(Object::toString).orElse("");
        String containerParentIdObj = Optional.ofNullable(e.getContainer()).map(container -> container.get("ParentId")).map(Object::toString).orElse("");
        String containerType = Optional.ofNullable(e.getContainer()).map(container -> container.get("_Type_")).map(Object::toString).orElse("");
        if (StringUtils.isEmpty((String)containerParentIdObj) || "FlexPanelAp".equals(containerType)) {
            containerParentIdObj = containerId;
        }
        if (StringUtils.isEmpty((String)containerId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u8282\u70b9\uff0c\u7136\u540e\u70b9\u51fb\u8be5\u63a7\u4ef6\u8fdb\u884c\u521b\u5efa\u3002", (String)"NameCombineCreateUIElemntListener_0", (String)"bos-ext-controls", (Object[])new Object[0]));
            return;
        }
        NameCombineEntity nameCombineEntity = this.createNameCombineEntity(entityId, containerParentIdObj);
        NameCombinePanelAp nameCombinePanelAp = this.createNameCombinePanelAp(entityId, containerParentIdObj);
        nameCombinePanelAp.setEntityId(nameCombineEntity.getId());
        FormDesigner designer = (FormDesigner)e.getSource();
        this.fillNameCombine(nameCombinePanelAp, nameCombineEntity, entityId);
        List nameSegFieldList = nameCombineEntity.getItems();
        this.handEntityInvoke(designer, containerParentIdObj, (EntityItem<?>)nameCombineEntity);
        nameSegFieldList.forEach(nameSegField -> this.handEntityInvoke(designer, nameCombineEntity.getId(), (EntityItem<?>)nameSegField));
        List nameSegFieldApList = nameCombinePanelAp.getItems();
        StringJoiner idJoiner = new StringJoiner(",");
        nameSegFieldApList.forEach(nameSegFieldAp -> idJoiner.add(nameSegFieldAp.getId()));
        nameCombinePanelAp.setRelatedChildrenIds(idJoiner.toString());
        this.handElementUIInvoke(designer, (ControlAp<?>)nameCombinePanelAp, e.getContainer());
        nameSegFieldApList.forEach(nameSegFieldAp -> {
            Map<String, Object> nameCombinePanelApMap = NameControlUtil.controlApToMap("DynamicFormModel", nameCombinePanelAp);
            String type = NameSegEnum.NS_POST_TITLE.getKey().equals(nameSegFieldAp.getKey()) || NameSegEnum.NS_TITLE.getKey().equals(nameSegFieldAp.getKey()) ? NameSegComboField.class.getSimpleName() : (NameSegEnum.NS_COUNTRY.getKey().equals(nameSegFieldAp.getKey()) || NameSegEnum.NS_NAME_STYLE.getKey().equals(nameSegFieldAp.getKey()) ? NameSegBasedataField.class.getSimpleName() : NameSegTextField.class.getSimpleName());
            FieldAp fieldAp = (FieldAp)nameSegFieldAp;
            this.handElementUIInvoke(designer, (ControlAp<?>)fieldAp, nameCombinePanelApMap, type);
        });
    }

    private NameCombinePanelAp createNameCombinePanelAp(String entityId, String containerId) {
        NameCombinePanelAp nameCombinePanelAp = new NameCombinePanelAp();
        nameCombinePanelAp.setId(entityId);
        nameCombinePanelAp.setKey(NameSegEnum.NC_COMBINE_PANEL.getKey());
        nameCombinePanelAp.setName(NameSegEnum.NC_COMBINE_PANEL.getName());
        nameCombinePanelAp.setParentId(containerId);
        return nameCombinePanelAp;
    }

    private NameCombineEntity createNameCombineEntity(String entityId, String containerId) {
        NameCombineEntity nameCombineEntity = new NameCombineEntity();
        nameCombineEntity.setId(entityId);
        nameCombineEntity.setName(NameSegEnum.NC_COMBINE_ENTITY.getName());
        nameCombineEntity.setKey(NameSegEnum.NC_COMBINE_ENTITY.getKey());
        nameCombineEntity.setParentId(containerId);
        return nameCombineEntity;
    }

    private void handElementUIInvoke(FormDesigner designer, ControlAp<?> controlAp, Map<String, Object> containerMap) {
        this.handElementUIInvoke(designer, controlAp, containerMap, NameSegEnum.NC_COMBINE_ENTITY.getType());
    }

    private void handElementUIInvoke(FormDesigner designer, ControlAp<?> controlAp, Map<String, Object> containerMap, String type) {
        Map<String, Object> elementAp = NameControlUtil.controlApToMap("DynamicFormModel", controlAp);
        if (StringUtils.isNotEmpty((String)type)) {
            elementAp.put("Type", type);
        }
        if (type.equals(NameSegEnum.NC_COMBINE_ENTITY.getType())) {
            elementAp.put("Collapsible", Boolean.TRUE);
        } else {
            elementAp.put("FireUpdEvt", Boolean.TRUE);
        }
        designer.createUIElement(elementAp, containerMap);
    }

    private void handEntityInvoke(FormDesigner designer, String containerId, EntityItem<?> entityItem) {
        HashMap<String, String> entityItemMap = new HashMap<String, String>(16);
        entityItemMap.put("Id", entityItem.getId());
        entityItemMap.put("Key", entityItem.getKey());
        entityItemMap.put("Name", entityItem.getName().getLocaleValue());
        entityItemMap.put("ParentId", entityItem.getParentId());
        if (!(entityItem instanceof NameCombineEntity)) {
            entityItemMap.put("I18nNameFieldId", NameSegEnum.encodeNameSegId(entityItem.getKey(), entityItem.getId()));
        }
        if (entityItem instanceof Field) {
            entityItemMap.put("FieldName", ((Field)entityItem).getFieldName());
        } else if (entityItem instanceof NameCombineEntity) {
            entityItemMap.put("_Type_", NameCombineEntity.class.getSimpleName());
            entityItemMap.put("FieldType", NameCombineEntity.class.getSimpleName());
        }
        if (entityItem instanceof NameSegBasedataField) {
            entityItemMap.put("BaseEntityId", ((NameSegBasedataField)entityItem).getBaseEntityId());
            entityItemMap.put("FieldType", NameSegBasedataField.class.getSimpleName());
            entityItemMap.put("_Type_", NameSegBasedataField.class.getSimpleName());
            entityItemMap.put("I18nNameKey", StringUtils.getEmpty());
            entityItemMap.put("NameEntityId", entityItem.getParentId());
        } else if (entityItem instanceof NameSegTextField) {
            entityItemMap.put("FieldType", NameSegTextField.class.getSimpleName());
            entityItemMap.put("_Type_", NameSegTextField.class.getSimpleName());
            entityItemMap.put("I18nNameKey", StringUtils.getEmpty());
            entityItemMap.put("NameEntityId", entityItem.getParentId());
        } else if (entityItem instanceof NameSegComboField) {
            entityItemMap.put("FieldType", NameSegComboField.class.getSimpleName());
            entityItemMap.put("_Type_", NameSegComboField.class.getSimpleName());
            entityItemMap.put("I18nNameKey", StringUtils.getEmpty());
            entityItemMap.put("NameEntityId", entityItem.getParentId());
        }
        designer.createEntityElement(containerId, entityItemMap);
    }

    private void fillNameCombine(NameCombinePanelAp nameCombinePanelAp, NameCombineEntity nameCombineEntity, String containerId) {
        List<Map<String, Object>> nameSegList = NameSegEnum.getNameSegList();
        for (Map<String, Object> nameSeg : nameSegList) {
            nameSeg.put("Id", ID.genStringId());
            nameSeg.put("Key", nameSeg.get("Key"));
            Field<?> nameSegField = this.createNameSegField(nameSeg);
            nameSegField.setParentId(nameCombineEntity.getId());
            nameCombineEntity.getItems().add(nameSegField);
            FieldAp nameSegFieldAp = this.createNameSegFieldAp(nameSeg, containerId, nameSegField);
            nameCombinePanelAp.getItems().add(nameSegFieldAp);
        }
    }

    private FieldAp createNameSegFieldAp(Map<String, Object> nameSegMap, String parentId, Field<?> nameSegField) {
        NameSegFieldAp fieldAp = new NameSegFieldAp();
        fieldAp.setId(nameSegMap.get("Id").toString());
        fieldAp.setKey(nameSegMap.get("Key").toString());
        fieldAp.setName((LocaleString)nameSegMap.get("Name"));
        fieldAp.setFieldId(nameSegMap.get("Id").toString());
        fieldAp.setParentId(parentId);
        fieldAp.setField(nameSegField);
        fieldAp.setRelatedParentId(parentId);
        return fieldAp;
    }

    private Field<?> createNameSegField(Map<String, Object> nameSegMap) {
        String fieldType = nameSegMap.get("FieldType").toString();
        NameSegField nameSegField = null;
        switch (fieldType) {
            case "NameSegTextField": {
                nameSegField = new NameSegTextField();
                break;
            }
            case "NameSegComboField": {
                nameSegField = new NameSegComboField();
                break;
            }
            case "NameSegBasedataField": {
                nameSegField = new NameSegBasedataField();
                if (NameSegEnum.NS_COUNTRY.getKey().equals(nameSegMap.get("Key"))) {
                    ((NameSegBasedataField)nameSegField).setBaseEntityId("44eb2b11000021ac");
                    break;
                }
                if (!NameSegEnum.NS_NAME_STYLE.getKey().equals(nameSegMap.get("Key"))) break;
                ((NameSegBasedataField)nameSegField).setBaseEntityId("1BPLRUTRY1CU");
                break;
            }
        }
        assert (nameSegField != null);
        nameSegField.setId(nameSegMap.get("Id").toString());
        nameSegField.setKey(nameSegMap.get("Key").toString());
        nameSegField.setName((LocaleString)nameSegMap.get("Name"));
        nameSegField.setFieldName("f" + nameSegMap.get("Key"));
        return nameSegField;
    }
}

