/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.form.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AssociatResourceListPlugin
extends StandardTreeListPlugin {
    private static final String MODULE_COL = "module";
    private static final String BIZ_CLOUD = "bos_devportal_bizcloud";
    private static final String BIZ_APP = "bos_devportal_bizapp";
    private static final String ENTITY_ID = "ide_associatresource";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanel_treebtn"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AssociatResourceListPlugin_0", (String)"bos-ext-controls", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List userapps = PermissionServiceHelper.getUserBizApps((Long)Long.valueOf(RequestContext.get().getUserId()));
        root.addChildren(this.assemblyNodes(userapps));
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    private List<TreeNode> assemblyNodes(List<String> userapps) {
        List<TreeNode> cloudNodes = this.getCloudNodes();
        cloudNodes.forEach(cloudNode -> {
            List<TreeNode> groupNodes = this.getAppNodes(cloudNode.getId(), userapps);
            this.addChildNode((TreeNode)cloudNode, groupNodes);
        });
        return cloudNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        childNodes.forEach(cnode -> {
            String parentId = cnode.getParentid();
            if (pnode.getId().equals(parentId)) {
                pnode.addChild(this.addChildNode((TreeNode)cnode, childNodes));
            }
        });
        return pnode;
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            node.setId(dynamicObject.getString("id"));
            node.setText(dynamicObject.getString("name"));
            node.setParentid("-1");
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private List<TreeNode> getAppNodes(String cloudId, List<String> userapps) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String nodeId = dynamicObject.getString("id");
            if (userapps == null || !userapps.contains(nodeId)) continue;
            TreeNode node = new TreeNode();
            node.setId(nodeId);
            node.setText(dynamicObject.getString("name"));
            node.setParentid(cloudId);
            appNodes.add(node);
        }
        return appNodes;
    }

    public void refreshNode(RefreshNodeEvent e) {
        List userapps = PermissionServiceHelper.getUserBizApps((Long)Long.valueOf(RequestContext.get().getUserId()));
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId(), userapps);
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId, List<String> userapps) {
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            return this.assemblyNodes(userapps);
        }
        return Collections.EMPTY_LIST;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        if ("-1".equals(nodeId)) {
            nodeEvent.addQFilter(new QFilter(MODULE_COL, "is not null", (Object)""));
        } else if (this.isCloudNode(nodeId)) {
            List<String> appIds = this.getBizIdsByCloudId(nodeId);
            nodeEvent.addQFilter(new QFilter(MODULE_COL, "in", appIds));
        } else {
            nodeEvent.addQFilter(new QFilter(MODULE_COL, "=", (Object)nodeId));
        }
        nodeEvent.setCancel(true);
    }

    private boolean isCloudNode(String nodeId) {
        ORM orm = ORM.create();
        return orm.exists(BIZ_CLOUD, (Object)nodeId);
    }

    private List<String> getBizIdsByCloudId(String bizCloudId) {
        QFilter[] filters = new QFilter[]{new QFilter("bizcloud", "=", (Object)bizCloudId)};
        ORM orm = ORM.create();
        DynamicObjectCollection query = orm.query(BIZ_APP, "id", filters, "");
        if (query != null) {
            ArrayList<String> appIds = new ArrayList<String>(query.size());
            query.forEach(dyo -> appIds.add(dyo.getString("id")));
            return appIds;
        }
        return Collections.EMPTY_LIST;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("save".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        HashMap para = new HashMap();
        HashMap<String, String> data = new HashMap<String, String>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        data.put("_Type_", "AssociatResource");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow selectData = billList.getCurrentSelectedRowInfo();
        if (selectData == null) {
            this.getView().showErrorNotification(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c.", (String)"AssociatResourceListPlugin_1", (String)"bos-ext-controls", (Object[])new Object[0])).toString());
            return;
        }
        long id = (Long)selectData.getPrimaryKeyValue();
        DynamicObject ar = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ID);
        data.put("Id", ar.getString("ctlid"));
        data.put("Name", ar.getString("name"));
        data.put("Version", ar.getString("version"));
        data.put("JsPath", ar.getString("jspath"));
        data.put("Module", ar.getString(MODULE_COL));
        para.put("value", data);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }
}

