/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.form.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.File;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.model.MCUploadFileInfo;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.portal.MCUploadFileServiceHelper;
import kd.bos.url.UrlService;

public class ControlSchemaPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log logger = LogFactory.getLog(ControlSchemaPlugin.class);
    private static final String KEY_SCHEMA_ID = "schemaid";
    private static final String KEY_VERSION = "version";
    private static final String KEY_ATTACHMENT = "attachmentpanelap";
    private static final String KEY_BILL_ID = "ide_controlschema";
    private static final String KEY_ISVID = "isvid";
    private static final String ATTACH_FILES = "fileInfos";
    private static final String VALIDATE = "validate";
    private static final String MUTEX_OBJ_ID = "MUTEX_OBJ_ID";
    private static final String VALIEDATA_TIPS = "validate_tips";
    private static final String SCHEMA_PANEL = "schemapanel";
    private static final String SAVE_BTN = "buttonap1";

    private static final String getZipNull() {
        return ResManager.loadKDString((String)"\u538b\u7f29\u5305\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ControlSchemaPlugin_0", (String)"bos-ext-controls", (Object[])new Object[0]);
    }

    private static final String getEntryFileNotExist() {
        return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u538b\u7f29\u5305\u6839\u76ee\u5f55\u6ca1\u6709index.js\u5165\u53e3\u6587\u4ef6\uff0c\u8bf7\u5904\u7406", (String)"ControlSchemaPlugin_1", (String)"bos-ext-controls", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENT);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs evt) {
        String fid = (String)((FormShowParameter)evt.getSource()).getCustomParam(MUTEX_OBJ_ID);
        if (kd.bos.util.StringUtils.isNotEmpty((String)fid)) {
            DynamicObject dObject = BusinessDataServiceHelper.loadSingle((Object)fid, (String)KEY_BILL_ID);
            if (dObject != null) {
                String isvId = dObject.getString(KEY_ISVID);
                if (kd.bos.util.StringUtils.isEmpty((String)isvId)) {
                    isvId = ISVServiceHelper.getISVInfo().getId();
                }
                if (!this.isNeedUploadAttachment(isvId)) {
                    evt.setFormHeight("350px");
                }
            }
        } else if (!this.isNeedUploadAttachment(ISVServiceHelper.getISVInfo().getId())) {
            evt.setFormHeight("350px");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        FormOperate fo = (FormOperate)evt.getSource();
        String opKey = fo.getOperateKey();
        if ("save".equals(opKey)) {
            String attachFiles = this.getPageCache().get(ATTACH_FILES);
            String isvIdFromModel = (String)this.getModel().getValue(KEY_ISVID);
            if (this.isNeedUploadAttachment(isvIdFromModel) && kd.bos.util.StringUtils.isEmpty((String)attachFiles) && this.getAttachmentDyn() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8d44\u6e90\u6587\u4ef6\u3002", (String)"ControlSchemaPlugin_2", (String)"bos-ext-controls", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String validateFromPageCache = this.getPageCache().get(VALIDATE);
            if (StringUtils.isNotEmpty((CharSequence)validateFromPageCache) && !Boolean.parseBoolean(validateFromPageCache)) {
                this.getView().showErrorNotification(this.getPageCache().get(VALIEDATA_TIPS));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey = evt.getOperateKey();
        if ("save".equals(opKey)) {
            String isvIdFromModel = (String)this.getModel().getValue(KEY_ISVID);
            if (!this.isNeedUploadAttachment(isvIdFromModel)) {
                return;
            }
            String attachFiles = this.getPageCache().get(ATTACH_FILES);
            ArrayList<Map<String, Object>> data = null;
            if (StringUtils.isNotEmpty((CharSequence)attachFiles)) {
                data = (ArrayList<Map<String, Object>>)SerializationUtils.fromJsonString((String)attachFiles, List.class);
            } else {
                DynamicObject dynamicObject = this.getAttachmentDyn();
                if (dynamicObject == null) {
                    return;
                }
                data = new ArrayList<Map<String, Object>>();
                HashMap<String, String> item = new HashMap<String, String>(2);
                item.put("name", dynamicObject.getString("FAttachmentName"));
                item.put("url", dynamicObject.getString("FFileId"));
                data.add(item);
            }
            if (data != null && data.size() > 0) {
                this.upload2MC(data);
            }
        }
    }

    private void upload2MC(List<Map<String, Object>> data) {
        List<File> listFile = this.getListFile(data, true);
        boolean flag = true;
        for (File file : listFile) {
            MCUploadFileInfo mcUploadFileInfo = this.getMCUploadFile(file);
            flag = MCUploadFileServiceHelper.setWebClientFiles((MCUploadFileInfo)mcUploadFileInfo);
            if (mcUploadFileInfo.getInputStream() != null) {
                try {
                    mcUploadFileInfo.getInputStream().close();
                }
                catch (IOException e) {
                    logger.error("close inputStream error", (Throwable)e);
                }
            }
            if (flag) continue;
            logger.error("upload file to MC failed by stream");
            break;
        }
        if (!flag) {
            try {
                List<File> urlFile = this.getListFile(data, false);
                this.setWebClientFiles(urlFile);
            }
            catch (Exception e) {
                logger.error("upload file to MC failed by url", (Throwable)e);
                this.getView().showErrMessage(this.getErrorMsg(e), ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"ControlSchemaPlugin_3", (String)"bos-ext-controls", (Object[])new Object[0]));
            }
        }
    }

    private MCUploadFileInfo getMCUploadFile(File file) {
        MCUploadFileInfo mcUploadFileInfo = new MCUploadFileInfo();
        mcUploadFileInfo.setDcid(RequestContext.get().getAccountId());
        mcUploadFileInfo.setIsv(ISVServiceHelper.getISVInfo().getId());
        mcUploadFileInfo.setKeys(this.getUniqueId(ATTACH_FILES));
        mcUploadFileInfo.setTenantId(RequestContext.get().getTenantId());
        mcUploadFileInfo.setDestPath(file.getDestPath());
        mcUploadFileInfo.setName(file.getName());
        mcUploadFileInfo.setServerType(file.getServerType());
        mcUploadFileInfo.setNeedUpdate(file.isNeedUpdate());
        mcUploadFileInfo.setFileServerPath(file.getFileServerPath());
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(file.getFileServerPath());
        mcUploadFileInfo.setInputStream(in);
        return mcUploadFileInfo;
    }

    private String getUploadStreamUrl(String urlFileService) {
        return FileServiceExtFactory.getAttachFileServiceExt().getRealPath(urlFileService);
    }

    public void afterCreateNewData(EventObject e) {
        this.hideResousePanel();
    }

    public void afterBindData(EventObject e) {
        this.hideResousePanel();
        String isvIdFromModel = (String)this.getModel().getValue(KEY_ISVID);
        if (!ISVServiceHelper.getISVInfo().getId().equalsIgnoreCase(isvIdFromModel)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SCHEMA_PANEL});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SAVE_BTN});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_ATTACHMENT});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u975e\u672c\u5f00\u53d1\u5546\u7684\u63a7\u4ef6\u65b9\u6848\u3002", (String)"ControlSchemaPlugin_4", (String)"bos-ext-controls", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String ctlKey = e.getProperty().getName();
        if (KEY_SCHEMA_ID.equals(ctlKey)) {
            String value = (String)e.getChangeSet()[0].getNewValue();
            ORM orm = ORM.create();
            FieldTip tips = new FieldTip(FieldTip.FieldTipType.Warning, ctlKey, new LocaleString(ResManager.loadKDString((String)"\u65b9\u6848id\u5df2\u5b58\u5728", (String)"ControlSchemaPlugin_5", (String)"bos-ext-controls", (Object[])new Object[0])).toString());
            tips.setSuccess(!orm.exists(KEY_BILL_ID, new QFilter[]{new QFilter(KEY_SCHEMA_ID, "=", (Object)value)}));
            this.getView().showFieldTip(tips);
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            ArrayList<Object> newFileInfos = new ArrayList<Object>(Arrays.asList(urls));
            boolean validate = this.check(newFileInfos);
            this.getPageCache().put(VALIDATE, Boolean.toString(validate));
            if (validate) {
                this.getPageCache().put(ATTACH_FILES, SerializationUtils.toJsonString(newFileInfos));
            }
        }
    }

    public void afterRemove(UploadEvent evt) {
        Integer oldVersion = (Integer)this.getModel().getValue(KEY_VERSION);
        this.getModel().setValue(KEY_VERSION, (Object)(oldVersion + 1));
        this.getPageCache().remove(ATTACH_FILES);
    }

    private boolean check(List<Object> newFileInfos) {
        if (newFileInfos == null) {
            return false;
        }
        for (Map map : newFileInfos) {
            List<FileInfo> fileInfos = this.getFileInfo((String)map.get("url"));
            if (fileInfos.size() == 0) {
                return false;
            }
            if (this.checkEntryFileExist(fileInfos)) continue;
            this.getView().showErrorNotification(ControlSchemaPlugin.getEntryFileNotExist());
            this.getPageCache().put(VALIEDATA_TIPS, ControlSchemaPlugin.getEntryFileNotExist());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileInfo> getFileInfo(String url) {
        logger.info("\u9644\u4ef6url:" + url);
        String failedTips = new LocaleString(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (String)"ControlSchemaPlugin_6", (String)"bos-ext-controls", (Object[])new Object[0])).toString();
        InputStream in = this.getInputStreamByUrl(url);
        ZipEntry zipEntry = null;
        ZipInputStream zipInput = null;
        ArrayList<FileInfo> data = new ArrayList<FileInfo>();
        try {
            if (in != null) {
                zipInput = new ZipInputStream(in, Charset.forName("utf-8"));
                while ((zipEntry = zipInput.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String fileFullPath = zipEntry.getName();
                    int idx = fileFullPath.lastIndexOf(".");
                    String suffix = idx != -1 ? fileFullPath.substring(idx, fileFullPath.length()) : null;
                    data.add(new FileInfo(fileFullPath, suffix, zipEntry));
                }
                if (data.size() == 0) {
                    this.getPageCache().put(VALIEDATA_TIPS, ControlSchemaPlugin.getZipNull());
                    this.getView().showErrorNotification(ControlSchemaPlugin.getZipNull());
                }
            } else {
                this.getView().showErrMessage(String.format(ResManager.loadKDString((String)"\u6587\u4ef6url: %s\u3002", (String)"ControlSchemaPlugin_7", (String)"bos-ext-controls", (Object[])new Object[0]), url), failedTips);
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage() + "\r\n" + url, failedTips);
        }
        finally {
            try {
                if (zipInput != null) {
                    zipInput.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.getView().showErrMessage(e.getMessage(), failedTips);
            }
        }
        return data;
    }

    private boolean checkEntryFileExist(List<FileInfo> fileInfos) {
        ArrayList fileNames = new ArrayList();
        fileInfos.forEach(fileInfo -> fileNames.add(fileInfo.getFullPath()));
        return fileNames.contains("index.js");
    }

    private boolean isTempUrl(String url) {
        return StringUtils.isNotEmpty((CharSequence)url) && url.contains("configKey");
    }

    private String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97md5\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getMd5FileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return "";
        }
        String suffix = "";
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (-1 != index) {
            name = fileName.substring(0, index);
            suffix = fileName.substring(index);
        }
        name = this.md5(name) + suffix;
        return name;
    }

    private List<File> getListFile(List<Map<String, Object>> data, boolean inputStream) {
        if (data != null) {
            ArrayList<File> listFile = new ArrayList<File>();
            data.forEach(item -> {
                String url = "";
                String urlFileService = this.getUrlinFileService();
                url = inputStream ? this.getUploadStreamUrl(urlFileService) : this.getDownloadURL(urlFileService);
                String fileName = (String)item.get("name");
                File file = new File();
                file.setDestPath(this.getModel().getValue("moduleid") + "/" + this.getModel().getValue(KEY_SCHEMA_ID));
                file.setName(this.getMd5FileName(fileName));
                file.setServerType("FS");
                file.setNeedUpdate(true);
                file.setFileServerPath(url);
                listFile.add(file);
            });
            return listFile;
        }
        return Collections.EMPTY_LIST;
    }

    private void setWebClientFiles(List<File> listFile) throws Exception {
        WebClientFiles client = new WebClientFiles();
        client.setDcid(RequestContext.get().getAccountId());
        client.setIsv(ISVServiceHelper.getISVInfo().getId());
        client.setKeys(this.getUniqueId(ATTACH_FILES));
        client.setTenantId(RequestContext.get().getTenantId());
        client.setFiles(listFile == null ? Collections.EMPTY_LIST : listFile);
        LoginMCService.create().setWebClientFiles(client);
    }

    private DynamicObject getAttachmentDyn() {
        ORM orm;
        DynamicObjectCollection dynColl;
        DynamicObject dyn;
        String schemaId = (String)this.getModel().getValue(KEY_SCHEMA_ID);
        String fid = (String)this.getView().getFormShowParameter().getCustomParam(MUTEX_OBJ_ID);
        QFilter[] filters = new QFilter[]{new QFilter(KEY_SCHEMA_ID, "=", (Object)schemaId)};
        if (kd.bos.util.StringUtils.isNotEmpty((String)fid)) {
            filters = new QFilter[]{new QFilter("id", "=", (Object)fid)};
        }
        if ((dyn = BusinessDataServiceHelper.loadSingle((String)KEY_BILL_ID, (String)"id", (QFilter[])filters)) != null && (dynColl = (orm = ORM.create()).query("bos_attachment", filters = new QFilter[]{new QFilter("FInterID", "=", (Object)dyn.getString("id")), new QFilter("FBillType", "=", (Object)this.getView().getFormShowParameter().getFormId()), new QFilter("fattachmentpanel", "=", (Object)KEY_ATTACHMENT)})) != null && !dynColl.isEmpty()) {
            return (DynamicObject)dynColl.get(0);
        }
        return null;
    }

    private String getUrlinFileService() {
        DynamicObject dyn = this.getAttachmentDyn();
        if (dyn != null) {
            return dyn.getString("FFileId");
        }
        return null;
    }

    private String getDownloadURL(String tempUrl) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)tempUrl)) {
            return AttachmentServiceHelper.getEncreptURL((String)UrlService.getAttachmentFullUrl((String)this.encodeUrl(tempUrl)));
        }
        return tempUrl;
    }

    private String encodeUrl(String url) {
        try {
            return StringUtils.isNotEmpty((CharSequence)url) ? URLEncoder.encode(url, "UTF-8") : url;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"url\u7f16\u7801\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ControlSchemaPlugin_8", (String)"bos-ext-controls", (Object[])new Object[0]));
            return url;
        }
    }

    private String getUniqueId(String suffix) {
        return "_control_schema_" + RequestContext.get().getTenantId() + "_" + suffix;
    }

    private void hideResousePanel() {
        String isvId = (String)this.getModel().getValue(KEY_ISVID);
        if (kd.bos.util.StringUtils.isEmpty((String)isvId)) {
            isvId = ISVServiceHelper.getISVInfo().getId();
            this.getModel().setValue(KEY_ISVID, (Object)ISVServiceHelper.getISVInfo().getId());
        }
        if (!this.isNeedUploadAttachment(isvId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_ATTACHMENT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ATTACHMENT});
        }
    }

    private boolean isNeedUploadAttachment(String isvId) {
        String isCustomerDevModel = System.getProperty("customerDevModel");
        if (StringUtils.isNotEmpty((CharSequence)isCustomerDevModel)) {
            return "false".equals(isCustomerDevModel);
        }
        return !"kingdee".equalsIgnoreCase(isvId) && ISVServiceHelper.getISVInfo().getId().equalsIgnoreCase(isvId);
    }

    private String getErrorMsg(Exception e) {
        if (e == null) {
            return "";
        }
        if (e instanceof KDException) {
            KDException kde = (KDException)e;
            Object[] args = kde.getArgs();
            StringBuilder buf = new StringBuilder();
            if (args != null && args.length > 0) {
                for (Object o : args) {
                    buf.append(o);
                }
            }
            return buf.append("\r\n").append(kde.getMessage()).append("\r\n").append(kde.getStackTraceMessage()).toString();
        }
        return e.getMessage();
    }

    private InputStream getInputStreamByUrl(String url) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            return cache.getInputStream(url);
        }
        return null;
    }

    private static class FileInfo {
        private String fullPath;
        private String suffix;
        private ZipEntry zipEntry;

        public FileInfo(String fullPath, String suffix, ZipEntry zipEntry) {
            this.fullPath = fullPath;
            this.suffix = suffix;
            this.zipEntry = zipEntry;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public void setFullPath(String fullPath) {
            this.fullPath = fullPath;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        public void setZipEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }
    }
}

