/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.form.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FormHelpEditPlugin
extends AbstractFormPlugin {
    private static final String BTN_SAVE = "btnsave";
    private static final String MARKDOWN_AP = "markdownap";
    private static final String ENTITY_ID = "ide_formhelp";
    private static final String FORMID_COL = "formid";
    private static final String FCONTENT_COL = "content";
    private static final String HELP_FORM_ID = "ide_showformhelp";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formId = this.getFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            DynamicObject[] doArray = this.query(formId);
            if (doArray == null || doArray.length == 0) {
                return;
            }
            DynamicObject helpInfo = doArray[0];
            Markdown mk = (Markdown)this.getView().getControl(MARKDOWN_AP);
            mk.setText(helpInfo.getString(FCONTENT_COL));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_SAVE.equals(key)) {
            this.saveOrUpdate();
        }
    }

    private void returnDataToParentAndClose(String newContent) {
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", HELP_FORM_ID);
        this.getView().returnDataToParent(para);
    }

    private void saveOrUpdate() {
        String formId = this.getFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        Markdown mk = (Markdown)this.getView().getControl(MARKDOWN_AP);
        String newContent = mk.getText();
        DynamicObject[] doArray = this.query(formId);
        DynamicObject helpInfo = null;
        if (doArray == null || doArray.length == 0) {
            if (StringUtils.isNotBlank((CharSequence)newContent)) {
                this.insert(formId, new LocaleString(newContent).toString());
            }
        } else {
            helpInfo = doArray[0];
            String preContent = helpInfo.getString(FCONTENT_COL);
            if (!preContent.equals(newContent)) {
                helpInfo.set(FCONTENT_COL, (Object)new LocaleString(newContent).toString());
                BusinessDataServiceHelper.save((IDataEntityType)helpInfo.getDataEntityType(), (Object[])new DynamicObject[]{helpInfo});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)newContent)) {
            this.returnDataToParentAndClose(newContent);
        }
        this.getView().close();
    }

    private String getFormId() {
        JSONArray context = (JSONArray)this.getView().getFormShowParameter().getCustomParam("context");
        if (context == null || context.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = (JSONArray)context.get(0);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return null;
        }
        JSONObject info = (JSONObject)jsonArray.get(0);
        return info.getString("Key");
    }

    private void insert(String formId, String newContent) {
        DynamicObject helpInfo = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ID);
        helpInfo.set(FORMID_COL, (Object)formId);
        helpInfo.set(FCONTENT_COL, (Object)newContent);
        BusinessDataServiceHelper.save((IDataEntityType)helpInfo.getDataEntityType(), (Object[])new DynamicObject[]{helpInfo});
    }

    private DynamicObject[] query(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter(FORMID_COL, "=", (Object)formId)};
        StringBuilder sbSelField = new StringBuilder("id").append(",").append(FORMID_COL).append(",").append(FCONTENT_COL);
        DynamicObject[] doArray = BusinessDataServiceHelper.load((String)ENTITY_ID, (String)sbSelField.toString(), (QFilter[])filters);
        return doArray;
    }
}

