/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.ext.form.control.events.NameSegEnum;
import kd.bos.ext.utils.NameControlUtil;
import kd.bos.form.BindingContext;
import org.apache.commons.lang3.StringUtils;

public interface NameSegField {
    public String getNameEntityId();

    public void setNameEntityId(String var1);

    public String getI18nNameFieldId();

    public void setI18nNameFieldId(String var1);

    public String getI18nNameKey();

    public void setI18nNameKey(String var1);

    default public String generateI18nName(BindingContext bctx) {
        String i18nNameKey = this.getI18nNameKey();
        DataEntityPropertyCollection properties = ((DynamicObject)bctx.getDataEntity()).getDataEntityType().getProperties();
        HashMap<String, String> stableKey2Value = new HashMap<String, String>();
        Long nameStyleConfigId = null;
        for (IDataEntityProperty property : properties) {
            NameSegField prop;
            if (!(property instanceof NameSegField) || !StringUtils.equals((CharSequence)(prop = (NameSegField)property).getI18nNameKey(), (CharSequence)i18nNameKey)) continue;
            String nameFieldId = prop.getI18nNameFieldId();
            String[] stableKeyAndId = NameSegEnum.decodeNameSegId(nameFieldId);
            String stableKey = Arrays.stream(Arrays.stream(stableKeyAndId).toArray()).findFirst().orElse("").toString();
            if (StringUtils.equals((CharSequence)stableKey, (CharSequence)NameSegEnum.NS_NAME_STYLE.getKey())) {
                nameStyleConfigId = Optional.ofNullable(((DynamicObject)bctx.getDataEntity()).getDynamicObject(property.getName())).map(item -> item.getLong("id")).orElse(null);
            }
            String value = ((DynamicObject)bctx.getDataEntity()).getString(property.getName());
            stableKey2Value.put(stableKey, value);
        }
        return this.getI18nName(nameStyleConfigId, stableKey2Value);
    }

    default public String getI18nName(Long nameStyleConfigId, Map<String, String> stableKey2Value) {
        boolean isAllNull = stableKey2Value.values().stream().anyMatch(StringUtils::isNotEmpty);
        if (!isAllNull) {
            return "";
        }
        stableKey2Value.remove(NameSegEnum.NS_NAME_STYLE.getKey());
        stableKey2Value.remove(NameSegEnum.NS_COUNTRY.getKey());
        HashMap<String, String> dataMap = new HashMap<String, String>();
        stableKey2Value.forEach((k, v) -> dataMap.put(NameSegEnum.getPresetNameKeyByKey(k), (String)v));
        return NameControlUtil.getNameFormatStr(nameStyleConfigId, dataMap);
    }
}

