/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.metadata.entity.businessfield;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.property.TextProp;
import kd.bos.ext.metadata.entity.NameCombineEntity;
import kd.bos.ext.metadata.entity.property.I18nNameProp;
import kd.bos.ext.metadata.form.field.I18nNameFieldEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.TextField;

public class I18nNameField
extends TextField {
    private static final String TYPE = "i18nname";
    private boolean simpleModeId;
    private boolean encrypt = true;

    public I18nNameField() {
        this.setMaxLength(500);
    }

    @SimplePropertyAttribute(name="Encrypt")
    @DefaultValueAttribute(value="true")
    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    @SimplePropertyAttribute(name="SimpleModeId")
    public boolean isSimpleModeId() {
        return this.simpleModeId;
    }

    public void setSimpleModeId(boolean simpleModeId) {
        this.simpleModeId = simpleModeId;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="500")
    public int getMaxLength() {
        return super.getMaxLength();
    }

    protected FieldEdit createServerEditor() {
        I18nNameFieldEdit edit = new I18nNameFieldEdit();
        edit.setSimpleModeId(this.isSimpleModeId());
        this.entityMetadata.getItems().forEach(item -> {
            if (item instanceof NameCombineEntity) {
                NameCombineEntity nameCombineEntity = (NameCombineEntity)((Object)item);
                String i18nNameId = nameCombineEntity.getI18nNameId();
                if (this.getId().equals(i18nNameId)) {
                    List childItems = nameCombineEntity.getItems();
                    List<String> nameSegKeyList = edit.getNameSegKeyList();
                    childItems.forEach(childItem -> nameSegKeyList.add(childItem.getKey()));
                }
            }
        });
        return edit;
    }

    public TextProp createDynamicProperty() {
        I18nNameProp prop = new I18nNameProp();
        prop.setSimpleModeId(this.isSimpleModeId());
        this.entityMetadata.getItems().forEach(item -> {
            if (item instanceof NameCombineEntity) {
                NameCombineEntity nameCombineEntity = (NameCombineEntity)((Object)item);
                String i18nNameId = nameCombineEntity.getI18nNameId();
                if (this.getId().equals(i18nNameId)) {
                    List childItems = nameCombineEntity.getItems();
                    List<String> nameSegKeyList = prop.getNameSegKeyList();
                    childItems.forEach(childItem -> nameSegKeyList.add(childItem.getKey()));
                }
            }
        });
        return prop;
    }

    public Map<String, Object> createEditor() {
        Map ctlRet = super.createEditor();
        ctlRet.put("type", TYPE);
        ctlRet.put("simpleModeId", this.isSimpleModeId());
        ctlRet.put("encrypt", this.encrypt);
        return ctlRet;
    }
}

