/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.metadata.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.events.NameSegEnum;
import kd.bos.ext.metadata.NameSegField;
import kd.bos.ext.metadata.entity.NameCombineEntity;
import kd.bos.ext.metadata.entity.businessfield.I18nNameField;
import kd.bos.ext.metadata.entity.businessfield.NameSegBasedataField;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;

public class NameSegFieldAp
extends FieldAp {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final String SAME_PAGE_VERSION_DATE = "same_page_version_date";
    private static final int CACHE_TIME = 5;
    private String relatedParentId;

    @SimplePropertyAttribute
    public String getRelatedParentId() {
        return this.relatedParentId;
    }

    public void setRelatedParentId(String relatedParentId) {
        this.relatedParentId = relatedParentId;
    }

    public FieldEdit createRuntimeControl() {
        Field field = this.getField();
        if (field instanceof NameSegBasedataField) {
            String nameFieldId = ((NameSegBasedataField)field).getI18nNameFieldId();
            String[] strings = NameSegEnum.decodeNameSegId(nameFieldId);
            String stableKey = strings[0];
            if (NameSegEnum.NS_NAME_STYLE.getKey().equals(stableKey)) {
                String i18nNameKey = ((NameSegField)field).getI18nNameKey();
                if (i18nNameKey == null) {
                    this.addBuildError(2, "i18nNameKey", ResManager.loadKDString((String)"\u201c\u56fd\u9645\u59d3\u540d\u201d\u63a7\u4ef6\u7684\u59d3\u540d\u5c5e\u6027\u5fc5\u586b\u3002", (String)"NameSegFieldAp_0", (String)"bos-ext-controls", (Object[])new Object[0]));
                }
                this.formMetadata.getEntityMetadata().getItems().forEach(item -> {
                    if (item.getKey().equals(i18nNameKey) && item instanceof I18nNameField && ((I18nNameField)((Object)item)).isSimpleModeId()) {
                        this.addBuildError(2, "simpleModeId", ResManager.loadKDString((String)"\u201c\u59d3\u540d\u201d\u63a7\u4ef6\u7b80\u5355\u6a21\u5f0f\u4e0d\u652f\u6301\u7ed1\u5b9a\u201c\u56fd\u9645\u59d3\u540d\u201d\u63a7\u4ef6\uff0c\u8bf7\u5173\u95ed\u7b80\u5355\u6a21\u5f0f\u6216\u4ece\u201c\u56fd\u9645\u59d3\u540d\u201d\u63a7\u4ef6\u89e3\u9664\u7ed1\u5b9a\u5173\u7cfb\u3002", (String)"NameSegFieldAp_1", (String)"bos-ext-controls", (Object[])new Object[0]));
                    }
                });
            }
        }
        String cacheValue = (String)cache.get(SAME_PAGE_VERSION_DATE);
        String willBeSaveCacheValue = this.formMetadata.getMergeVersion() + this.formMetadata.getModifyDate().getTime();
        if (cacheValue == null || !cacheValue.equals(willBeSaveCacheValue)) {
            cache.put(SAME_PAGE_VERSION_DATE, (Object)willBeSaveCacheValue, 5);
            this.hasDiffNameCombineEntityBindingOnSameI18nNameField();
            this.nameControlComplexModeAndHasNotBeenBind();
            this.nameStyleMustNotBeHidden();
        }
        return super.createRuntimeControl();
    }

    private void nameStyleMustNotBeHidden() {
        this.formMetadata.getItems().forEach(item -> {
            if (item instanceof NameSegFieldAp) {
                Field field = ((NameSegFieldAp)((Object)item)).getField();
                NameSegField nameSegField = (NameSegField)field;
                String i18nNameFieldId = nameSegField.getI18nNameFieldId();
                String[] stableKeyAndId = NameSegEnum.decodeNameSegId(i18nNameFieldId);
                String stableKey = stableKeyAndId[0];
                String id = stableKeyAndId[1];
                if (NameSegEnum.NS_NAME_STYLE.getKey().equals(stableKey) && this.formMetadata.getItem(id).isHidden()) {
                    this.addBuildError(2, "nameSegStyle", ResManager.loadKDString((String)"\u59d3\u540d\u683c\u5f0f\u4e0d\u5141\u8bb8\u9690\u85cf\u3002", (String)"NameSegFieldAp_2", (String)"bos-ext-controls", (Object[])new Object[0]));
                }
            }
        });
    }

    private void hasDiffNameCombineEntityBindingOnSameI18nNameField() {
        List items = this.formMetadata.getEntityMetadata().getItems();
        List<EntityItem> nameCombineEntityList = items.stream().filter(item -> item instanceof NameCombineEntity).collect(Collectors.toList());
        if (nameCombineEntityList.size() <= 1) {
            return;
        }
        HashMap<String, List> i18nNameKeyEntityKeyListMap = new HashMap<String, List>();
        nameCombineEntityList.forEach(item -> {
            NameCombineEntity nameCombineEntity = (NameCombineEntity)((Object)item);
            String i18nNameKey = nameCombineEntity.getItems().stream().findAny().map(nameSegField -> ((NameSegField)nameSegField).getI18nNameKey()).orElse(null);
            List list = i18nNameKeyEntityKeyListMap.computeIfAbsent(i18nNameKey, k -> new LinkedList());
            list.add(nameCombineEntity.getKey());
        });
        StringJoiner joiner = new StringJoiner(",");
        i18nNameKeyEntityKeyListMap.forEach((k, v) -> {
            if (v.size() > 1) {
                v.forEach(joiner::add);
                this.addBuildError(2, "i18nNameId", String.format(ResManager.loadKDString((String)"\u4e24\u4e2a\u6216\u4ee5\u4e0a\u201c\u56fd\u9645\u59d3\u540d\u201d\u63a7\u4ef6\u7ed1\u5b9a\u540c\u4e00\u4e2a\u201c\u591a\u8bed\u8a00\u6587\u672c/\u6587\u672c/\u59d3\u540d\u201d\u63a7\u4ef6\u3002 \u201c\u56fd\u9645\u59d3\u540d\u201d\uff1a%1$s\uff0c \u201c\u591a\u8bed\u8a00\u6587\u672c/\u6587\u672c/\u59d3\u540d\u201d\uff1a%2$s\uff0c\u8bf7\u79fb\u9664\u91cd\u590d\u7ed1\u5b9a\u3002", (String)"NameSegFieldAp_3", (String)"bos-ext-controls", (Object[])new Object[0]), joiner.toString(), k));
            }
        });
    }

    private void nameControlComplexModeAndHasNotBeenBind() {
        List items = this.formMetadata.getEntityMetadata().getItems();
        List<EntityItem> nameCombineEntityList = items.stream().filter(item -> item instanceof NameCombineEntity).collect(Collectors.toList());
        List<EntityItem> nameControlList = items.stream().filter(item -> item instanceof I18nNameField).collect(Collectors.toList());
        if (nameControlList.size() <= 0) {
            return;
        }
        ArrayList nameCombineEntityHasKeyList = new ArrayList();
        nameCombineEntityList.forEach(item -> {
            NameCombineEntity nameCombineEntity = (NameCombineEntity)((Object)item);
            List panelContainsItems = nameCombineEntity.getItems();
            if (panelContainsItems.isEmpty()) {
                String nameCombineEntityId = nameCombineEntity.getId();
                panelContainsItems = items.stream().filter(nameSegItem -> nameSegItem instanceof NameSegField && nameCombineEntityId.equals(((NameSegField)nameSegItem).getNameEntityId())).collect(Collectors.toList());
            }
            String i18nNameKey = panelContainsItems.stream().findAny().map(nameSegField -> ((NameSegField)nameSegField).getI18nNameKey()).orElse(null);
            nameCombineEntityHasKeyList.add(i18nNameKey);
        });
        ArrayList complexModeKeyList = new ArrayList();
        nameControlList.forEach(item -> {
            I18nNameField i18nNameField = (I18nNameField)((Object)item);
            if (!i18nNameField.isSimpleModeId()) {
                complexModeKeyList.add(i18nNameField.getKey());
            }
        });
        List<String> notBindList = complexModeKeyList.stream().filter(item -> !nameCombineEntityHasKeyList.contains(item)).collect(Collectors.toList());
        if (notBindList.size() > 0) {
            StringJoiner joiner = new StringJoiner(",");
            notBindList.forEach(joiner::add);
            this.addBuildError(2, "simpleModeId", String.format(ResManager.loadKDString((String)"\u59d3\u540d\uff1a%s\uff0c\u4f7f\u7528\u590d\u6742\u6a21\u5f0f\u9700\u5173\u8054\u201c\u56fd\u9645\u59d3\u540d\u201d\u63a7\u4ef6\u3002", (String)"NameSegFieldAp_4", (String)"bos-ext-controls", (Object[])new Object[0]), joiner.toString()));
        }
    }
}

