/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.metadata.form.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.events.NameSegEnum;
import kd.bos.ext.metadata.NameSegField;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;

public class I18nNameFieldEdit
extends TextEdit
implements ICloseCallBack {
    private List<String> nameSegKeyList = new ArrayList<String>();
    private boolean simpleModeId;

    @SimplePropertyAttribute(name="SimpleModeId")
    public boolean isSimpleModeId() {
        return this.simpleModeId;
    }

    public void setSimpleModeId(boolean simpleModeId) {
        this.simpleModeId = simpleModeId;
    }

    public List<String> getNameSegKeyList() {
        return this.nameSegKeyList;
    }

    public void setNameSegKeyList(List<String> nameSegKeyList) {
        this.nameSegKeyList = nameSegKeyList;
    }

    public Object getBindingValue(BindingContext bctx) {
        String modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
        if (modelType != null && !modelType.contains("mobile")) {
            this.getView().setEnable(Boolean.valueOf(this.isSimpleModeId()), new String[]{this.getKey()});
        }
        return super.getBindingValue(bctx);
    }

    public void click() {
        super.click();
        String modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
        if (modelType != null && modelType.contains("mobile")) {
            String key = this.getKey();
            Map<String, String> keyMap = this.keyStableKeyCurrentNameStyleRelatedControls(key);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("cts_name_mobile");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            HashMap valueMap = new HashMap(16);
            map.put("keyMap", keyMap);
            keyMap.forEach((k, v) -> {
                Object value = this.getModel().getValue(v);
                if (StringUtils.isNotBlank((Object)value)) {
                    if (value instanceof DynamicObject) {
                        value = ((DynamicObject)value).getPkValue();
                    }
                    valueMap.put(k, value);
                }
            });
            map.put("valueMap", valueMap);
            map.put("key", key);
            showParameter.setCustomParams(map);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            CloseCallBack closeCallBack = new CloseCallBack();
            closeCallBack.setControlKey(key);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private Map<String, String> keyStableKeyCurrentNameStyleRelatedControls(String i18nNameKey) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        return allFields.values().stream().filter(field -> field instanceof NameSegField).filter(item -> {
            String nameSegI18nNameKey = ((NameSegField)item).getI18nNameKey();
            return StringUtils.equals((CharSequence)i18nNameKey, (CharSequence)nameSegI18nNameKey);
        }).collect(Collectors.toMap(item -> this.getStableKeyByNameFieldId(((NameSegField)item).getI18nNameFieldId()), IMetadata::getName));
    }

    private String getStableKeyByNameFieldId(String nameFieldId) {
        String[] stableKeyAndIdCountry = NameSegEnum.decodeNameSegId(nameFieldId);
        return NameSegEnum.getPresetNameKeyByKey(Arrays.stream(Arrays.stream(stableKeyAndIdCountry).toArray()).findFirst().orElse("").toString());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            Map map = (Map)e.getReturnData();
            map.forEach((k, v) -> this.getModel().setValue(k, v));
        }
    }
}

