/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.metadata.form.field;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.ext.form.control.events.NameSegEnum;
import kd.bos.ext.metadata.NameSegField;
import kd.bos.ext.metadata.entity.property.NameSegBasedataProp;
import kd.bos.ext.utils.NameControlUtil;
import kd.bos.form.BindingContext;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.inte.api.EnabledLang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class NameSegBasedataFieldEdit
extends BasedataEdit
implements NameSegField {
    private static final Log LOGGER = LogFactory.getLog(NameSegBasedataFieldEdit.class);
    private static final String ID = "id";
    private String nameCombinePanelId;
    private String i18nNameKey;
    private String i18nNameFieldId;
    private String nameEntityId;

    @Override
    @SimplePropertyAttribute
    public String getNameEntityId() {
        return this.nameEntityId;
    }

    @Override
    public void setNameEntityId(String nameEntityId) {
        this.nameEntityId = nameEntityId;
    }

    @Override
    @SimplePropertyAttribute(name="I18nNameFieldId")
    public String getI18nNameFieldId() {
        return this.i18nNameFieldId;
    }

    @Override
    public void setI18nNameFieldId(String i18nNameFieldId) {
        this.i18nNameFieldId = i18nNameFieldId;
    }

    @Override
    @SimplePropertyAttribute
    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    @Override
    public void setI18nNameKey(String i18nNameKey) {
        this.i18nNameKey = i18nNameKey;
    }

    @SimplePropertyAttribute
    public String getNameCombinePanelId() {
        return this.nameCombinePanelId;
    }

    public void setNameCombinePanelId(String nameCombinePanelId) {
        this.nameCombinePanelId = nameCombinePanelId;
    }

    private String findKeyByStableKey(String i18nNameKey, NameSegEnum nameSegEnum) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        String key = allFields.entrySet().stream().filter(item -> {
            IDataEntityProperty fieldProp = (IDataEntityProperty)item.getValue();
            if (fieldProp instanceof NameSegBasedataProp) {
                String currentI18nNameKey = ((NameSegBasedataProp)fieldProp).getI18nNameKey();
                String stableKey = this.getStableKeyByNameFieldId(((NameSegBasedataProp)fieldProp).getI18nNameFieldId());
                if (StringUtils.equals((CharSequence)currentI18nNameKey, (CharSequence)i18nNameKey) && StringUtils.equals((CharSequence)stableKey, (CharSequence)nameSegEnum.getKey())) {
                    return true;
                }
            }
            return false;
        }).map(Map.Entry::getKey).findAny().orElse(null);
        return key;
    }

    private String getStableKeyByNameFieldId(String nameFieldId) {
        String[] stableKeyAndIdCountry = NameSegEnum.decodeNameSegId(nameFieldId);
        return Arrays.stream(Arrays.stream(stableKeyAndIdCountry).toArray()).findFirst().orElse("").toString();
    }

    public List<QFilter> getQFilters() {
        String stableKeyCountry = this.getStableKeyByNameFieldId(this.getI18nNameFieldId());
        if (StringUtils.equals((CharSequence)stableKeyCountry, (CharSequence)NameSegEnum.NS_COUNTRY.getKey())) {
            return super.getQFilters();
        }
        List<QFilter> list = this.getCountryQFilter();
        return list;
    }

    private List<QFilter> getCountryQFilter() {
        String i18nNameKey = this.getI18nNameKey();
        String countryKey = this.findKeyByStableKey(i18nNameKey, NameSegEnum.NS_COUNTRY);
        String nameStyleKey = this.findKeyByStableKey(i18nNameKey, NameSegEnum.NS_NAME_STYLE);
        DynamicObject country = (DynamicObject)this.getModel().getValue(countryKey);
        DynamicObject nameStyle = (DynamicObject)this.getModel().getValue(nameStyleKey);
        ArrayList<QFilter> list = super.getQFilters();
        if (list == null) {
            list = new ArrayList<QFilter>();
        }
        if (country != null) {
            Set<Long> nameTextStyleIds = NameControlUtil.getCountryNameTextStyles(country.getLong(ID));
            QFilter qFilter = new QFilter(ID, "in", (Object)nameTextStyleIds.toArray());
            list.add(qFilter);
        }
        return list;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String stableKey = this.getStableKeyByNameFieldId(this.getI18nNameFieldId());
        if (NameSegEnum.NS_NAME_STYLE.getKey().equals(stableKey)) {
            this.handleControlsShowOrHidden();
            this.handleControlsPosition();
        } else if (NameSegEnum.NS_COUNTRY.getKey().equals(stableKey) && e.getReturnData() != null) {
            Long countryIdLong = (Long)((ListSelectedRowCollection)e.getReturnData()).get(0).getPrimaryKeyValue();
            this.countryChangedSetNameStyle(countryIdLong);
        }
        super.closedCallBack(e);
    }

    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        String stableKey = this.getStableKeyByNameFieldId(this.getI18nNameFieldId());
        this.pageLoadingInitNameStyleDefaultValue();
        if (NameSegEnum.NS_NAME_STYLE.getKey().equals(stableKey)) {
            this.handleControlsShowOrHidden();
            this.handleControlsPosition();
            String i18nName = this.generateI18nName(bctx);
            if (StringUtils.isNotEmpty((CharSequence)i18nName) && !" ".equals(i18nName)) {
                DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
                List propertyList = properties.stream().filter(v -> v.getName().equals(this.getI18nNameKey())).collect(Collectors.toList());
                if (propertyList.size() > 0 && propertyList.get(0) instanceof MuliLangTextProp) {
                    LocaleString localeString = new LocaleString();
                    List multiLangList = InteServiceHelper.getMultiLangEnabledLang();
                    for (EnabledLang enabledLang : multiLangList) {
                        localeString.setItem(enabledLang.getNumber(), (Object)i18nName);
                    }
                    this.getModel().setValue(this.getI18nNameKey(), (Object)localeString);
                } else {
                    this.getModel().setValue(this.getI18nNameKey(), (Object)i18nName);
                }
            }
        } else if (NameSegEnum.NS_COUNTRY.getKey().equals(stableKey)) {
            String nameStyleKey = this.findNameStyleKey(NameSegEnum.NS_NAME_STYLE);
            Object style = this.getModel().getValue(nameStyleKey);
            if (style == null) {
                this.getModel().setValue(nameStyleKey, (Object)NameControlUtil.getCountryDefaultNameStyleId(this.getCountryId()));
            }
        }
    }

    private Long getCountryId() {
        Object country = this.getModel().getValue(this.getProperty().getName());
        Long countryIdLong = null;
        if (country != null) {
            countryIdLong = ((DynamicObject)country).getLong(ID);
        }
        return countryIdLong;
    }

    private void pageLoadingInitNameStyleDefaultValue() {
        String nameStyleKey = this.findNameStyleKey(NameSegEnum.NS_NAME_STYLE);
        NameSegBasedataFieldEdit control = (NameSegBasedataFieldEdit)this.getView().getControl(nameStyleKey);
        control.setMustInput(true);
        String countryKey = this.findNameStyleKey(NameSegEnum.NS_COUNTRY);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            Object nameStyle;
            Object country = this.getModel().getValue(countryKey);
            Object isAllowedNull = this.getView().getFormShowParameter().getCustomParam("isNSCountryAllowedNull");
            if (!(country != null || isAllowedNull != null && ((Boolean)isAllowedNull).booleanValue())) {
                DynamicObject dynamicObject;
                long countryId = 1000001L;
                Object defaultcountry = SystemParamServiceHelper.loadPublicParameterFromCache((String)"defaultcountry");
                if (defaultcountry != null) {
                    Map map = (Map)defaultcountry;
                    countryId = Long.parseLong(map.get(ID).toString());
                }
                if ((dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)countryId, (String)"bd_country")) != null && "1".equals(dynamicObject.getString("enable"))) {
                    this.getModel().setValue(countryKey, (Object)countryId);
                }
            }
            if ((nameStyle = this.getModel().getValue(nameStyleKey)) == null) {
                Long countryIdLong = this.getCountryId();
                this.getModel().setValue(nameStyleKey, (Object)NameControlUtil.getCountryDefaultNameStyleId(countryIdLong));
            }
        }
    }

    private void countryChangedSetNameStyle(Long countryId) {
        this.getModel().setValue(this.findNameStyleKey(NameSegEnum.NS_NAME_STYLE), (Object)NameControlUtil.getCountryDefaultNameStyleId(countryId));
    }

    private Map<String, String> keyStableKeyCurrentNameStyleRelatedControls(String i18nNameKey) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        Map<String, String> collect = allFields.values().stream().filter(field -> field instanceof NameSegField).filter(item -> {
            String nameSegI18nNameKey = ((NameSegField)item).getI18nNameKey();
            return StringUtils.equals((CharSequence)i18nNameKey, (CharSequence)nameSegI18nNameKey);
        }).collect(Collectors.toMap(IMetadata::getName, item -> this.getStableKeyByNameFieldId(((NameSegField)item).getI18nNameFieldId())));
        return collect;
    }

    private String findNameStyleKey(NameSegEnum nameSegEnum) {
        String i18nNameKey = this.getI18nNameKey();
        return this.getModel().getDataEntity().getDataEntityType().getProperties().stream().filter(prop -> prop instanceof NameSegBasedataProp).filter(prop -> {
            NameSegBasedataProp nameStyleProp = (NameSegBasedataProp)prop;
            String stableKey = this.getStableKeyByNameFieldId(nameStyleProp.getI18nNameFieldId());
            return nameSegEnum.getKey().equals(stableKey) && nameStyleProp.getI18nNameKey().equals(i18nNameKey);
        }).map(IMetadata::getName).findAny().orElse(null);
    }

    private void handleControlsShowOrHidden() {
        LinkedHashMap stableKey2Field = new LinkedHashMap();
        Object nameStyle = this.getModel().getValue(this.getProperty().getName());
        if (nameStyle != null) {
            DynamicObject nameStyleDynamicObject = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)nameStyle).getLong(ID), (String)"cts_nameconfigformat");
            List<Map<String, Object>> nameStyleConfig = NameControlUtil.getNameStyleConfig(nameStyleDynamicObject.getDynamicObject("nameconfig").getLong(ID));
            JSONArray nameStyleConfigArray = JSON.parseArray((String)JSON.toJSONString(nameStyleConfig));
            nameStyleConfigArray.forEach(jsonObject -> {
                JSONObject fieldDefine = (JSONObject)jsonObject;
                stableKey2Field.put(fieldDefine.getString("fieldKey"), fieldDefine);
            });
        }
        String i18nNameKey = this.getI18nNameKey();
        Map<String, String> i18nNameRelatedKeyStableKey = this.keyStableKeyCurrentNameStyleRelatedControls(i18nNameKey);
        i18nNameRelatedKeyStableKey.forEach((key, stableKey) -> {
            boolean isCountryOrIsNameStyle;
            boolean bl = isCountryOrIsNameStyle = StringUtils.equals((CharSequence)stableKey, (CharSequence)NameSegEnum.NS_COUNTRY.getKey()) || StringUtils.equals((CharSequence)stableKey, (CharSequence)NameSegEnum.NS_NAME_STYLE.getKey());
            if (!isCountryOrIsNameStyle) {
                String refKey = NameSegEnum.getPresetNameKeyByKey(stableKey);
                JSONObject fieldDefine = (JSONObject)stableKey2Field.get(refKey);
                if (fieldDefine == null) {
                    if (this.getModel().getValue(key) != null) {
                        this.getModel().setValue(key, (Object)"");
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{key});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{key});
                    this.setComboOptions((String)key, (String)stableKey, fieldDefine);
                    this.setMustInput((String)key, fieldDefine);
                    this.setCustomTag((String)key, fieldDefine);
                }
            }
        });
    }

    private void setCustomTag(String key, JSONObject fieldDefine) {
        String customerTag = Optional.ofNullable(fieldDefine).map(fieldDefineItem -> fieldDefineItem.getString("customerTag")).orElse("");
        String titleTag = Optional.ofNullable(fieldDefine).map(fieldDefineItem -> fieldDefineItem.getString("fieldName")).orElse("");
        HashMap<String, LocaleString> onlyCustomerTagMap = new HashMap<String, LocaleString>();
        if (StringUtils.isNotEmpty((CharSequence)customerTag)) {
            onlyCustomerTagMap.put("caption", new LocaleString(customerTag));
        } else {
            onlyCustomerTagMap.put("caption", new LocaleString(titleTag));
        }
        this.getView().updateControlMetadata(key, onlyCustomerTagMap);
    }

    private void setComboOptions(String key, String stableKey, JSONObject fieldDefine) {
        if (StringUtils.equals((CharSequence)stableKey, (CharSequence)NameSegEnum.NS_POST_TITLE.getKey()) || StringUtils.equals((CharSequence)stableKey, (CharSequence)NameSegEnum.NS_TITLE.getKey())) {
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(key);
            JSONArray comboValues = fieldDefine.getJSONArray("comboValues");
            ArrayList data = new ArrayList();
            if (comboValues != null) {
                comboValues.forEach(item -> {
                    String comboValue = item.toString();
                    data.add(new ComboItem(new LocaleString(comboValue), comboValue));
                });
            }
            comboEdit.setComboItems(data);
        }
    }

    private void setMustInput(String key, JSONObject fieldDefine) {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(key);
        boolean isMustInput = Optional.ofNullable(fieldDefine).map(fieldDefineCurrent -> fieldDefineCurrent.getBoolean("mustInput")).orElse(Boolean.FALSE);
        fieldEdit.setMustInput(isMustInput);
    }

    private void handleControlsPosition() {
    }
}

